/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionFactory;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.MathDoubleExpression;
import org.eclipse.persistence.jpa.jpql.parser.MathSingleExpression;

public abstract class MathExpressionFactory
extends ExpressionFactory {
    MathExpressionFactory(String id) {
        super(id, id);
    }

    @Override
    protected AbstractExpression buildExpression(AbstractExpression parent, WordParser wordParser, String word, JPQLQueryBNF queryBNF, AbstractExpression expression, boolean tolerant) {
        expression.parse(wordParser, tolerant);
        return expression;
    }

    public static final class Sign
    extends MathExpressionFactory {
        public static final String ID = "SIGN";

        public Sign() {
            super(ID);
        }

        @Override
        protected AbstractExpression buildExpression(AbstractExpression parent, WordParser wordParser, String word, JPQLQueryBNF queryBNF, AbstractExpression expression, boolean tolerant) {
            return super.buildExpression(parent, wordParser, word, queryBNF, new MathSingleExpression.Sign(parent), tolerant);
        }
    }

    public static final class Round
    extends MathExpressionFactory {
        public static final String ID = "ROUND";

        public Round() {
            super(ID);
        }

        @Override
        protected AbstractExpression buildExpression(AbstractExpression parent, WordParser wordParser, String word, JPQLQueryBNF queryBNF, AbstractExpression expression, boolean tolerant) {
            return super.buildExpression(parent, wordParser, word, queryBNF, new MathDoubleExpression.Round(parent), tolerant);
        }
    }

    public static final class Power
    extends MathExpressionFactory {
        public static final String ID = "POWER";

        public Power() {
            super(ID);
        }

        @Override
        protected AbstractExpression buildExpression(AbstractExpression parent, WordParser wordParser, String word, JPQLQueryBNF queryBNF, AbstractExpression expression, boolean tolerant) {
            return super.buildExpression(parent, wordParser, word, queryBNF, new MathDoubleExpression.Power(parent), tolerant);
        }
    }

    public static final class Ln
    extends MathExpressionFactory {
        public static final String ID = "LN";

        public Ln() {
            super(ID);
        }

        @Override
        protected AbstractExpression buildExpression(AbstractExpression parent, WordParser wordParser, String word, JPQLQueryBNF queryBNF, AbstractExpression expression, boolean tolerant) {
            return super.buildExpression(parent, wordParser, word, queryBNF, new MathSingleExpression.Ln(parent), tolerant);
        }
    }

    public static final class Floor
    extends MathExpressionFactory {
        public static final String ID = "FLOOR";

        public Floor() {
            super(ID);
        }

        @Override
        protected AbstractExpression buildExpression(AbstractExpression parent, WordParser wordParser, String word, JPQLQueryBNF queryBNF, AbstractExpression expression, boolean tolerant) {
            return super.buildExpression(parent, wordParser, word, queryBNF, new MathSingleExpression.Floor(parent), tolerant);
        }
    }

    public static final class Exp
    extends MathExpressionFactory {
        public static final String ID = "EXP";

        public Exp() {
            super(ID);
        }

        @Override
        protected AbstractExpression buildExpression(AbstractExpression parent, WordParser wordParser, String word, JPQLQueryBNF queryBNF, AbstractExpression expression, boolean tolerant) {
            return super.buildExpression(parent, wordParser, word, queryBNF, new MathSingleExpression.Exp(parent), tolerant);
        }
    }

    public static final class Ceiling
    extends MathExpressionFactory {
        public static final String ID = "CEILING";

        public Ceiling() {
            super(ID);
        }

        @Override
        protected AbstractExpression buildExpression(AbstractExpression parent, WordParser wordParser, String word, JPQLQueryBNF queryBNF, AbstractExpression expression, boolean tolerant) {
            return super.buildExpression(parent, wordParser, word, queryBNF, new MathSingleExpression.Ceiling(parent), tolerant);
        }
    }
}

