/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.jcraft.jsch.SftpATTRS;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.util.cluster.RemoteType;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import org.glassfish.cluster.ssh.launcher.SSHException;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.launcher.SSHSession;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.glassfish.cluster.ssh.sftp.SFTPPath;

public abstract class SecureAdminBootstrapHelper
implements AutoCloseable {
    private static final System.Logger LOG = System.getLogger(SecureAdminBootstrapHelper.class.getName());
    private static final Path DOMAIN_XML_PATH = Path.of("config", "domain.xml");
    private static final Path[] SECURE_ADMIN_FILE_REL_URIS_TO_COPY = new Path[]{DOMAIN_XML_PATH, Path.of("config", "keystore.p12"), Path.of("config", "cacerts.p12")};
    private static final Path[] SECURE_ADMIN_FILE_DIRS_TO_CREATE = new Path[]{Path.of("config", new String[0])};

    public static SecureAdminBootstrapHelper getRemoteHelper(SSHLauncher sshL, File dasInstanceDir, String remoteNodeDir, String instance, Node node) throws BootstrapException {
        RemoteType type;
        try {
            type = RemoteType.valueOf((String)node.getType());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(Strings.get("internal.error", "unknown type"));
        }
        switch (type) {
            case SSH: {
                return new SSHHelper(sshL, dasInstanceDir, remoteNodeDir, instance, node);
            }
        }
        throw new IllegalArgumentException(Strings.get("internal.error", "A new type must have been added --> unknown type: " + type.toString()));
    }

    public static SecureAdminBootstrapHelper getLocalHelper(File existingInstanceDir, File newInstanceDir) {
        return new LocalHelper(existingInstanceDir, newInstanceDir);
    }

    protected abstract void mkdirs(Path var1) throws IOException;

    @Override
    public void close() {
    }

    protected abstract void copyBootstrapFiles() throws FileNotFoundException, IOException;

    protected abstract void backdateInstanceDomainXML() throws BootstrapException;

    public void bootstrapInstance() throws BootstrapException {
        try {
            this.mkdirs();
            this.copyBootstrapFiles();
            this.backdateInstanceDomainXML();
        }
        catch (Exception ex) {
            throw new BootstrapException(ex);
        }
    }

    private void mkdirs() throws IOException {
        for (Path dirPath : SECURE_ADMIN_FILE_DIRS_TO_CREATE) {
            this.mkdirs(dirPath);
        }
    }

    private static class SSHHelper
    extends RemoteHelper {
        private final SSHSession session;
        private final SFTPClient ftpClient;
        private final SSHLauncher launcher;

        private SSHHelper(SSHLauncher sshLauncher, File dasInstanceDir, String remoteNodeDir, String instance, Node node) throws BootstrapException {
            super(dasInstanceDir, remoteNodeDir, instance, node);
            this.launcher = sshLauncher;
            try {
                this.session = this.launcher.openSession();
            }
            catch (SSHException e) {
                throw new BootstrapException((Exception)((Object)e));
            }
            try {
                this.ftpClient = this.session.createSFTPClient();
            }
            catch (SSHException e) {
                if (this.session != null) {
                    this.session.close();
                }
                throw new BootstrapException((Exception)((Object)e));
            }
        }

        @Override
        protected void mkdirs(Path dir) throws IOException {
            SFTPPath remoteDir = this.remoteInstanceDir.resolve(dir);
            LOG.log(System.Logger.Level.DEBUG, "Trying to create directories for remote path {0}", remoteDir);
            SftpATTRS attrs = this.ftpClient.lstat(this.remoteNodeDir);
            if (attrs == null) {
                throw new IOException("Remote path " + String.valueOf(this.remoteNodeDir) + " does not exist.");
            }
            int instanceDirPermissions = attrs.getPermissions();
            LOG.log(System.Logger.Level.DEBUG, "Creating remote bootstrap directory " + String.valueOf(remoteDir) + " with permissions " + Integer.toOctalString(instanceDirPermissions));
            this.ftpClient.mkdirs(remoteDir);
            if (this.launcher.getCapabilities().isChmodSupported()) {
                this.ftpClient.chmod(remoteDir, instanceDirPermissions);
            }
        }

        @Override
        public void close() {
            if (this.ftpClient != null) {
                this.ftpClient.close();
            }
            if (this.session != null) {
                this.session.close();
            }
        }

        @Override
        void writeToFile(Path remotePath, File localFile) throws IOException {
            this.ftpClient.put(localFile, SFTPPath.of((Path)remotePath));
        }

        @Override
        protected void backdateInstanceDomainXML() throws BootstrapException {
            SFTPPath remoteDomainXML = this.remoteInstanceDir.resolve(DOMAIN_XML_PATH);
            try {
                this.setLastModified((Path)remoteDomainXML, 0L);
            }
            catch (IOException ex) {
                throw new BootstrapException(ex);
            }
            LOG.log(System.Logger.Level.DEBUG, "Backdated the instance's copy of domain.xml");
        }

        @Override
        void setLastModified(Path path, long when) throws IOException {
            this.ftpClient.setTimeModified(SFTPPath.of((Path)path), when);
        }
    }

    private static class LocalHelper
    extends SecureAdminBootstrapHelper {
        private final URI existingInstanceDirURI;
        private final URI newInstanceDirURI;

        private LocalHelper(File existingInstanceDir, File newInstanceDir) {
            this.existingInstanceDirURI = existingInstanceDir.toURI();
            this.newInstanceDirURI = newInstanceDir.toURI();
        }

        @Override
        protected void mkdirs(Path dir) {
            File newDir = Path.of(this.newInstanceDirURI).resolve(dir).toFile();
            if (!newDir.exists() && !newDir.mkdirs()) {
                throw new RuntimeException(Strings.get("secure.admin.boot.errCreDir", newDir.getAbsolutePath()));
            }
        }

        @Override
        public void copyBootstrapFiles() throws IOException {
            for (Path relativePathToFile : SECURE_ADMIN_FILE_REL_URIS_TO_COPY) {
                File origin = Path.of(this.existingInstanceDirURI).resolve(relativePathToFile).toFile();
                File dest = Path.of(this.newInstanceDirURI).resolve(relativePathToFile).toFile();
                FileUtils.copy((File)origin, (File)dest);
            }
        }

        @Override
        protected void backdateInstanceDomainXML() throws BootstrapException {
            File newDomainXMLFile = Path.of(this.newInstanceDirURI).resolve(DOMAIN_XML_PATH).toFile();
            if (!newDomainXMLFile.setLastModified(0L)) {
                throw new RuntimeException(Strings.get("secure.admin.boot.errSetLastMod", newDomainXMLFile.getAbsolutePath()));
            }
        }
    }

    public static class BootstrapException
    extends Exception {
        private static final long serialVersionUID = -5488899043810477670L;

        public BootstrapException(String message, Exception ex) {
            super(message + "; Cause: " + ex.getMessage(), ex);
        }

        public BootstrapException(Exception ex) {
            super(ex.getMessage(), ex);
        }

        public BootstrapException(String msg) {
            super(msg);
        }
    }

    private static abstract class RemoteHelper
    extends SecureAdminBootstrapHelper {
        final File dasInstanceDir;
        final SFTPPath remoteNodeDir;
        final SFTPPath remoteInstanceDir;

        RemoteHelper(File dasInstanceDir, String remoteNodeDir, String instance, Node node) {
            this.dasInstanceDir = dasInstanceDir;
            this.remoteNodeDir = RemoteHelper.remoteNodeDirUnixStyle(node, remoteNodeDir);
            this.remoteInstanceDir = this.remoteNodeDir.resolve(instance);
        }

        abstract void writeToFile(Path var1, File var2) throws IOException;

        abstract void setLastModified(Path var1, long var2) throws IOException;

        private static SFTPPath remoteNodeDirUnixStyle(Node node, String remoteNodeDir) {
            if (remoteNodeDir == null) {
                return SFTPPath.of((String)node.getInstallDirUnixStyle()).resolve((Path)SFTPPath.ofRelativePath((String[])new String[]{"glassfish", "nodes", node.getName()}));
            }
            return SFTPPath.of((String)remoteNodeDir);
        }

        @Override
        protected void copyBootstrapFiles() throws FileNotFoundException, IOException {
            for (Path fileRelativePath : SECURE_ADMIN_FILE_REL_URIS_TO_COPY) {
                SFTPPath remoteFilePath = this.remoteInstanceDir.resolve(fileRelativePath);
                try {
                    this.writeToFile((Path)remoteFilePath, this.dasInstanceDir.toPath().resolve(fileRelativePath).toFile());
                    LOG.log(System.Logger.Level.DEBUG, "Copied bootstrap file to {0}", remoteFilePath);
                }
                catch (Exception ex) {
                    LOG.log(System.Logger.Level.DEBUG, "Error copying bootstrap file to " + String.valueOf(remoteFilePath), (Throwable)ex);
                    throw new IOException(ex);
                }
            }
        }
    }
}

