/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.config.dom;

import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.glassfish.grizzly.config.dom.NetworkAddress;
import org.glassfish.grizzly.config.dom.NetworkListeners;
import org.glassfish.grizzly.config.dom.PortUnification;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.ProtocolFinder;
import org.glassfish.grizzly.config.dom.Range;
import org.glassfish.grizzly.config.dom.ThreadPool;
import org.glassfish.grizzly.config.dom.Transport;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.types.PropertyBag;

@Configured
public interface NetworkListener
extends ConfigBeanProxy,
PropertyBag {
    public static final boolean ENABLED = true;
    public static final boolean JK_ENABLED = false;
    public static final String DEFAULT_ADDRESS = "0.0.0.0";
    public static final String DEFAULT_CONFIGURATION_FILE = "${com.sun.aas.instanceRoot}/config/glassfish-jk.properties";
    public static final String LISTENER_TYPES = "(standard|proxy)";
    public static final String DEFAULT_TYPE = "standard";

    @Attribute(defaultValue="0.0.0.0")
    @NetworkAddress
    public String getAddress();

    public void setAddress(String var1);

    @Attribute(defaultValue="true", dataType=Boolean.class)
    public String getEnabled();

    public void setEnabled(String var1);

    @Attribute(defaultValue="${com.sun.aas.instanceRoot}/config/glassfish-jk.properties")
    public String getJkConfigurationFile();

    public void setJkConfigurationFile(String var1);

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getJkEnabled();

    public void setJkEnabled(String var1);

    @Attribute(required=true, key=true)
    public String getName();

    public void setName(String var1);

    @Attribute(required=true, defaultValue="standard")
    @Pattern(regexp="(standard|proxy)", message="Valid values: (standard|proxy)")
    public @Pattern(regexp="(standard|proxy)", message="Valid values: (standard|proxy)") String getType();

    public void setType(String var1);

    @Attribute(required=true, dataType=Integer.class)
    @Range(max=65535)
    public String getPort();

    public void setPort(String var1);

    @Attribute(required=true)
    public String getProtocol();

    public void setProtocol(String var1);

    @Attribute
    public String getThreadPool();

    public void setThreadPool(String var1);

    @Attribute(required=true)
    public String getTransport();

    public void setTransport(String var1);

    default public Protocol findHttpProtocol() {
        return this.findHttpProtocol(new HashSet<String>(), this.findProtocol());
    }

    default public String findHttpProtocolName() {
        Protocol httpProtocol = this.findHttpProtocol();
        if (httpProtocol != null) {
            return httpProtocol.getName();
        }
        return null;
    }

    default public Protocol findProtocol() {
        return this.getParent().getParent().findProtocol(this.getProtocol());
    }

    default public ThreadPool findThreadPool() {
        NetworkListeners listeners = this.getParent();
        List<ThreadPool> threadPools = listeners.getThreadPool();
        if (threadPools == null || threadPools.isEmpty()) {
            ConfigBeanProxy parent = listeners.getParent().getParent();
            Dom proxy = Objects.requireNonNull(Dom.unwrap((ConfigBeanProxy)parent)).element("thread-pools");
            List nodeElements = proxy.nodeElements("thread-pool");
            threadPools = new ArrayList<ThreadPool>(nodeElements.size());
            for (Dom node : nodeElements) {
                threadPools.add((ThreadPool)node.createProxy());
            }
        }
        for (ThreadPool pool : threadPools) {
            if (!this.getThreadPool().equals(pool.getName())) continue;
            return pool;
        }
        return null;
    }

    default public Transport findTransport() {
        List<Transport> transports = this.getParent().getParent().getTransports().getTransport();
        String transportName = this.getTransport();
        for (Transport transport : transports) {
            if (!transportName.equals(transport.getName())) continue;
            return transport;
        }
        return null;
    }

    default public NetworkListeners getParent() {
        return (NetworkListeners)this.getParent(NetworkListeners.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Protocol findHttpProtocol(Set<String> tray, Protocol protocol) {
        if (protocol == null) {
            return null;
        }
        String protocolName = protocol.getName();
        if (tray.contains(protocolName)) {
            throw new IllegalStateException("Loop found in Protocol definition. Protocol name: " + protocolName);
        }
        if (protocol.getHttp() != null) {
            return protocol;
        }
        PortUnification portUnification = protocol.getPortUnification();
        if (portUnification != null) {
            List<ProtocolFinder> finders = portUnification.getProtocolFinder();
            tray.add(protocolName);
            try {
                Protocol foundHttpProtocol = null;
                for (ProtocolFinder finder : finders) {
                    Protocol httpProtocol;
                    Protocol subProtocol = finder.findProtocol();
                    if (subProtocol == null || (httpProtocol = this.findHttpProtocol(tray, subProtocol)) == null) continue;
                    foundHttpProtocol = httpProtocol;
                }
                Iterator<ProtocolFinder> iterator = foundHttpProtocol;
                return iterator;
            }
            finally {
                tray.remove(protocolName);
            }
        }
        return null;
    }
}

