/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.util;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.RestUtil;
import org.glassfish.admingui.common.util.TargetUtil;

public class AppUtil {
    public static final List sniffersHide = new ArrayList();
    public static final List<String> appResTypes;
    public static final List<String> appResTypesToDisplay;
    public static final List<String> appResTypesEdit;

    public static List<String> getSnifferListOfModule(String appName, String moduleName) {
        Map childResourcesMap;
        Map extraProperties;
        Map<String, Object> subMap = RestUtil.restRequest(String.valueOf(GuiUtil.getSessionValue("REST_URL")) + "/applications/application/" + appName + "/module/" + moduleName + "/engine", null, "GET", null, false);
        Map dataMap = (Map)subMap.get("data");
        ArrayList<String> sniffersList = new ArrayList<String>();
        if (dataMap != null && (extraProperties = (Map)dataMap.get("extraProperties")) != null && (childResourcesMap = (Map)extraProperties.get("childResources")) != null) {
            for (String oneSniffer : childResourcesMap.keySet()) {
                if (sniffersHide.contains(oneSniffer)) continue;
                sniffersList.add(oneSniffer);
            }
            Collections.sort(sniffersList);
            return sniffersList;
        }
        return sniffersList;
    }

    public static boolean isApplicationEnabled(String appName, String target) {
        String prefix = (String)GuiUtil.getSessionValue("REST_URL");
        List clusters = TargetUtil.getClusters();
        List standalone = TargetUtil.getStandaloneInstances();
        standalone.add("server");
        Map attrs = null;
        Object endpoint = "";
        if (clusters.contains(target)) {
            endpoint = prefix + "/clusters/cluster/" + target + "/application-ref/" + appName;
            attrs = RestUtil.getAttributesMap(prefix + (String)endpoint);
        } else {
            endpoint = prefix + "/servers/server/" + target + "/application-ref/" + appName;
            attrs = RestUtil.getAttributesMap((String)endpoint);
        }
        return Boolean.parseBoolean((String)attrs.get("enabled"));
    }

    public static Map getWsEndpointMap(String appName, String moduleName, List snifferList) {
        Map wsAppMap;
        block4: {
            wsAppMap = new HashMap();
            try {
                String encodedAppName = URLEncoder.encode(appName, "UTF-8");
                String encodedModuleName = URLEncoder.encode(moduleName, "UTF-8");
                String prefix = String.valueOf(GuiUtil.getSessionValue("REST_URL")) + "/applications/application/" + encodedAppName;
                if (snifferList.contains("webservices")) {
                    HashMap<String, Object> wsAttrMap = new HashMap<String, Object>();
                    wsAttrMap.put("modulename", encodedModuleName);
                    Map<String, Object> wsMap = RestUtil.restRequest(prefix + "/list-webservices", wsAttrMap, "GET", null, false);
                    Map extraProps = (Map)((Map)wsMap.get("data")).get("extraProperties");
                    if (extraProps != null) {
                        wsAppMap = (Map)extraProps.get(appName);
                    }
                }
            }
            catch (Exception ex) {
                GuiUtil.getLogger().info(GuiUtil.getCommonMessage("log.error.wsException") + ex.getLocalizedMessage());
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block4;
                ex.printStackTrace();
            }
        }
        return wsAppMap;
    }

    public static Map getEndpointDetails(Map wsEndpointMap, String moduleName, String componentName) {
        if (wsEndpointMap == null) {
            return null;
        }
        Map modMap = (Map)wsEndpointMap.get(moduleName);
        if (modMap == null) {
            return null;
        }
        return (Map)modMap.get(componentName);
    }

    public static void manageAppTarget(String applicationName, String targetName, boolean add, String enabled, List clusterList, List standaloneList, HandlerContext handlerCtx) {
        List clusters = clusterList == null ? TargetUtil.getClusters() : clusterList;
        String clusterEndpoint = String.valueOf(GuiUtil.getSessionValue("REST_URL")) + "/clusters/cluster/";
        String serverEndpoint = String.valueOf(GuiUtil.getSessionValue("REST_URL")) + "/servers/server/";
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        String endpoint = clusters.contains(targetName) ? clusterEndpoint + targetName + "/application-ref" : serverEndpoint + targetName + "/application-ref";
        if (add) {
            attrs.put("id", applicationName);
            if (enabled != null) {
                attrs.put("enabled", enabled);
            }
        } else {
            endpoint = endpoint + "/" + applicationName;
        }
        attrs.put("target", targetName);
        RestUtil.restRequest(endpoint, attrs, add ? "POST" : "DELETE", handlerCtx, false);
    }

    public static Boolean doesAppContainsResources(String appName) {
        return RestUtil.doesProxyExist(String.valueOf(GuiUtil.getSessionValue("REST_URL")) + "/applications/application/" + appName + "/resources");
    }

    public static String getAppScopedResType(String resName, String type) {
        int index = appResTypes.indexOf(resName);
        if (index != -1) {
            if (type.equals("display")) {
                return appResTypesToDisplay.get(index);
            }
            if (type.equals("edit")) {
                return appResTypesEdit.get(index);
            }
        }
        return null;
    }

    static {
        sniffersHide.add("security");
        appResTypes = new ArrayList<String>();
        appResTypes.add("<JdbcResource>");
        appResTypes.add("<ConnectorResource>");
        appResTypes.add("<ExternalJndiResource>");
        appResTypes.add("<CustomResource>");
        appResTypes.add("<AdminObjectResource>");
        appResTypes.add("<MailResource>");
        appResTypes.add("<JdbcConnectionPool>");
        appResTypes.add("<ConnectorConnectionPool>");
        appResTypes.add("<ResourceAdapterConfig>");
        appResTypes.add("<WorkSecurityMap>");
        appResTypesToDisplay = new ArrayList<String>();
        appResTypesToDisplay.add(GuiUtil.getMessage("tree.jdbcResources"));
        appResTypesToDisplay.add(GuiUtil.getMessage("tree.connectorResources"));
        appResTypesToDisplay.add(GuiUtil.getMessage("tree.externalResources"));
        appResTypesToDisplay.add(GuiUtil.getMessage("tree.customResources"));
        appResTypesToDisplay.add(GuiUtil.getMessage("tree.adminObjectResources"));
        appResTypesToDisplay.add(GuiUtil.getMessage("tree.javaMailSessions"));
        appResTypesToDisplay.add(GuiUtil.getMessage("common.JdbcConnectionPools"));
        appResTypesToDisplay.add(GuiUtil.getMessage("tree.connectorConnectionPools"));
        appResTypesToDisplay.add(GuiUtil.getMessage("tree.resourceAdapterConfigs"));
        appResTypesToDisplay.add(GuiUtil.getMessage("tree.workSecurityMaps"));
        appResTypesEdit = new ArrayList<String>();
        appResTypesEdit.add("jdbc/jdbcResourceEdit.jsf?name=");
        appResTypesEdit.add("jca/connectorResourceEdit.jsf?name=");
        appResTypesEdit.add("full/externalResourceEdit.jsf?name=");
        appResTypesEdit.add("full/customResourceEdit.jsf?name=");
        appResTypesEdit.add("jca/adminObjectEdit.jsf?name=");
        appResTypesEdit.add("full/mailResourceEdit.jsf?name=");
        appResTypesEdit.add("jdbc/jdbcConnectionPoolEdit.jsf?name=");
        appResTypesEdit.add("jca/connectorConnectionPoolEdit.jsf?name=");
        appResTypesEdit.add("jca/resourceAdapterConfigEdit.jsf?name=");
        appResTypesEdit.add("jca/workSecurityMapEdit.jsf?mapName=");
    }
}

