/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.apache.naming.NamingContextBindingsEnumeration;
import org.apache.naming.NamingContextEnumeration;
import org.apache.naming.NamingEntry;
import org.apache.naming.resources.FileDirContext;
import org.apache.naming.resources.JarFileResourcesProvider;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;

public class WebDirContext
extends FileDirContext {
    private static final System.Logger LOG = System.getLogger(WebDirContext.class.getName());
    protected static final String META_INF_RESOURCES = "META-INF/resources/";
    protected JarFileResourcesProvider jarFileResourcesProvider = null;
    protected String jarResourceBase = "META-INF/resources/";

    public WebDirContext() {
    }

    public WebDirContext(Hashtable<String, Object> env) {
        super(env);
    }

    public void setJarFileResourcesProvider(JarFileResourcesProvider jarFileResourcesProvider) {
        this.jarFileResourcesProvider = jarFileResourcesProvider;
    }

    void setJarResourceBase(String jarResourceBase) {
        this.jarResourceBase = jarResourceBase;
    }

    @Override
    public void release() {
        this.jarFileResourcesProvider = null;
        this.jarResourceBase = null;
        super.release();
    }

    @Override
    public Object lookup(String name) throws NamingException {
        Object result = null;
        File file = this.file(name);
        JarFileEntry jfEntry = null;
        if (file == null && (jfEntry = this.lookupFromJars(name)) == null) {
            throw new NamingException(MessageFormat.format(rb.getString("AS-WEB-NAMING-00009"), name));
        }
        if (file != null && file.isDirectory() || jfEntry != null && jfEntry.getJarEntry().isDirectory()) {
            WebDirContext tempContext = new WebDirContext(this.env);
            tempContext.docBase = name;
            tempContext.setAllowLinking(this.getAllowLinking());
            tempContext.setCaseSensitive(this.isCaseSensitive());
            tempContext.setJarFileResourcesProvider(this.jarFileResourcesProvider);
            tempContext.setJarResourceBase(this.getAbsoluteJarResourceName(name));
            result = tempContext;
        } else if (file != null) {
            result = new FileDirContext.FileResource(file);
        } else if (jfEntry != null) {
            result = new JarResource(jfEntry.jarFile, jfEntry.jarEntry);
        }
        return result;
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        List<NamingEntry> namingEntries = null;
        File file = this.file(name);
        if (file != null) {
            namingEntries = this.list(file);
        }
        List<JarFileEntry> jfeEntries = this.lookupAllFromJars(name);
        for (JarFileEntry jfeEntry : jfeEntries) {
            List<NamingEntry> jfList = this.list(jfeEntry);
            if (namingEntries != null) {
                namingEntries.addAll(jfList);
                continue;
            }
            namingEntries = jfList;
        }
        if (file == null && jfeEntries.size() == 0) {
            throw new NamingException(MessageFormat.format(rb.getString("AS-WEB-NAMING-00009"), name));
        }
        return new NamingContextEnumeration(namingEntries.iterator());
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        List<NamingEntry> namingEntries = null;
        File file = this.file(name);
        if (file != null) {
            namingEntries = this.list(file);
        }
        List<JarFileEntry> jfeEntries = this.lookupAllFromJars(name);
        for (JarFileEntry jfeEntry : jfeEntries) {
            List<NamingEntry> jfeList = this.list(jfeEntry);
            if (namingEntries != null) {
                namingEntries.addAll(jfeList);
                continue;
            }
            namingEntries = jfeList;
        }
        if (file == null && jfeEntries.size() == 0) {
            throw new NamingException(MessageFormat.format(rb.getString("AS-WEB-NAMING-00009"), name));
        }
        return new NamingContextBindingsEnumeration(namingEntries.iterator(), this);
    }

    @Override
    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        File file = this.file(name);
        if (file == null) {
            JarFileEntry jfEntry = this.lookupFromJars(name);
            if (jfEntry == null) {
                throw new NamingException(MessageFormat.format(rb.getString("AS-WEB-NAMING-00009"), name));
            }
            return new JarResourceAttributes(jfEntry.getJarEntry());
        }
        return new FileDirContext.FileResourceAttributes(file);
    }

    protected JarFileEntry lookupFromJars(String name) {
        LOG.log(System.Logger.Level.DEBUG, "lookupFromJars(name={0})", name);
        JarFileEntry result = null;
        JarFile[] jarFiles = null;
        if (this.jarFileResourcesProvider != null) {
            jarFiles = this.jarFileResourcesProvider.getJarFiles();
        }
        if (jarFiles != null) {
            String jeName = this.getAbsoluteJarResourceName(name);
            for (JarFile jarFile : jarFiles) {
                JarEntry jarEntry = null;
                if (jeName.charAt(jeName.length() - 1) != '/' && (jarEntry = jarFile.getJarEntry(jeName + "/")) != null) {
                    result = new JarFileEntry(jarFile, jarEntry);
                    break;
                }
                jarEntry = jarFile.getJarEntry(jeName);
                if (jarEntry == null) continue;
                result = new JarFileEntry(jarFile, jarEntry);
                break;
            }
        }
        return result;
    }

    protected List<JarFileEntry> lookupAllFromJars(String name) {
        LOG.log(System.Logger.Level.DEBUG, "lookupAllFromJars(name={0})", name);
        ArrayList<JarFileEntry> results = new ArrayList<JarFileEntry>();
        JarFile[] jarFiles = null;
        if (this.jarFileResourcesProvider != null) {
            jarFiles = this.jarFileResourcesProvider.getJarFiles();
        }
        if (jarFiles != null) {
            String jeName = this.getAbsoluteJarResourceName(name);
            for (JarFile jarFile : jarFiles) {
                JarEntry jarEntry = null;
                if (jeName.charAt(jeName.length() - 1) != '/' && (jarEntry = jarFile.getJarEntry(jeName + "/")) != null) {
                    results.add(new JarFileEntry(jarFile, jarEntry));
                }
                if ((jarEntry = jarFile.getJarEntry(jeName)) == null) continue;
                results.add(new JarFileEntry(jarFile, jarEntry));
            }
        }
        return results;
    }

    protected List<NamingEntry> list(JarFileEntry jfeEntry) {
        ArrayList<NamingEntry> entries = new ArrayList<NamingEntry>();
        JarFile jarFile = jfeEntry.jarFile;
        JarEntry jarEntry = jfeEntry.jarEntry;
        if (!jarEntry.isDirectory()) {
            return entries;
        }
        String prefix = jarEntry.getName();
        int prefixLength = prefix.length();
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            int endIndex;
            JarEntry je = e.nextElement();
            String name = je.getName();
            if (name.length() <= prefixLength || !name.startsWith(prefix) || (endIndex = name.indexOf(47, prefixLength)) != -1 && endIndex != name.length() - 1) continue;
            String subName = endIndex != -1 ? name.substring(prefixLength, endIndex) : name.substring(prefixLength);
            Object object = null;
            if (je.isDirectory()) {
                WebDirContext tempContext = new WebDirContext(this.env);
                tempContext.docBase = name;
                tempContext.setAllowLinking(this.getAllowLinking());
                tempContext.setCaseSensitive(this.isCaseSensitive());
                tempContext.setJarFileResourcesProvider(this.jarFileResourcesProvider);
                tempContext.setJarResourceBase(name);
                object = tempContext;
            } else {
                object = new JarResource(jarFile, je);
            }
            entries.add(new NamingEntry(subName, object, 0));
        }
        return entries;
    }

    protected String getAbsoluteJarResourceName(String name) {
        boolean secondStartWithSlash;
        if (name.length() == 0) {
            return this.jarResourceBase;
        }
        boolean firstEndsWithSlash = this.jarResourceBase.charAt(this.jarResourceBase.length() - 1) == '/';
        boolean bl = secondStartWithSlash = name.charAt(0) == '/';
        if (firstEndsWithSlash && secondStartWithSlash) {
            return this.jarResourceBase.substring(0, this.jarResourceBase.length() - 1) + name;
        }
        if (!firstEndsWithSlash && !secondStartWithSlash) {
            return this.jarResourceBase + "/" + name;
        }
        return this.jarResourceBase + name;
    }

    public String toString() {
        return super.toString() + "[" + this.docBase + "]";
    }

    protected static class JarFileEntry {
        private JarFile jarFile = null;
        private JarEntry jarEntry = null;

        protected JarFileEntry(JarFile jf, JarEntry je) {
            this.jarFile = jf;
            this.jarEntry = je;
        }

        JarFile getJarFile() {
            return this.jarFile;
        }

        JarEntry getJarEntry() {
            return this.jarEntry;
        }
    }

    protected static class JarResource
    extends Resource {
        protected JarFile jarFile;
        protected JarEntry jarEntry;

        public JarResource(JarFile jarFile, JarEntry jarEntry) {
            this.jarFile = jarFile;
            this.jarEntry = jarEntry;
        }

        @Override
        public InputStream streamContent() throws IOException {
            if (this.binaryContent == null) {
                InputStream jin;
                this.inputStream = jin = this.jarFile.getInputStream(this.jarEntry);
                return jin;
            }
            return super.streamContent();
        }
    }

    protected static class JarResourceAttributes
    extends ResourceAttributes {
        protected transient JarEntry jarEntry;
        protected boolean accessed = false;

        public JarResourceAttributes(JarEntry jarEntry) {
            this.jarEntry = jarEntry;
            this.getCreation();
            this.getLastModified();
        }

        @Override
        public boolean isCollection() {
            if (!this.accessed) {
                this.collection = this.jarEntry.isDirectory();
                this.accessed = true;
            }
            return super.isCollection();
        }

        @Override
        public long getContentLength() {
            if (this.contentLength != -1L) {
                return this.contentLength;
            }
            this.contentLength = this.jarEntry.getSize();
            return this.contentLength;
        }

        @Override
        public long getCreation() {
            if (this.creation != -1L) {
                return this.creation;
            }
            this.creation = this.getLastModified();
            return this.creation;
        }

        @Override
        public Date getCreationDate() {
            if (this.creation == -1L) {
                this.creation = this.jarEntry.getTime();
            }
            return super.getCreationDate();
        }

        @Override
        public long getLastModified() {
            if (this.lastModified != -1L) {
                return this.lastModified;
            }
            this.lastModified = this.jarEntry.getTime();
            return this.lastModified;
        }

        @Override
        public Date getLastModifiedDate() {
            if (this.lastModified == -1L) {
                this.lastModified = this.jarEntry.getTime();
            }
            return super.getLastModifiedDate();
        }

        @Override
        public String getName() {
            if (this.name == null) {
                this.name = this.jarEntry.getName();
            }
            return this.name;
        }

        @Override
        public String getResourceType() {
            if (!this.accessed) {
                this.collection = this.jarEntry.isDirectory();
                this.accessed = true;
            }
            return super.getResourceType();
        }

        @Override
        public String getCanonicalPath() {
            return null;
        }

        private void readObject(ObjectInputStream ois) throws IOException {
            throw new UnsupportedOperationException();
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

