/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import com.sun.enterprise.admin.launcher.GFLauncherException;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.logging.annotation.LogMessagesResourceBundle;
import org.glassfish.logging.annotation.LoggerInfo;
import org.glassfish.main.jdke.i18n.LocalStringsImpl;
import org.glassfish.main.jul.formatter.ODLLogFormatter;
import org.glassfish.main.jul.handler.SimpleLogHandler;

public class GFLauncherLogger {
    @LogMessagesResourceBundle
    public static final String SHARED_LOGMESSAGE_RESOURCE = "com.sun.enterprise.admin.launcher.LogMessages";
    @LoggerInfo(subsystem="Launcher", description="Launcher Logger", publish=true)
    public static final String LOGGER_NAME = "jakarta.enterprise.launcher";
    private static final Logger LOG;
    private static final LocalStringsImpl strings;
    private static final Handler HANDLER_STDOUT;
    private static FileHandler logfileHandler;
    @LogMessageInfo(message="Single and double quote characters are not allowed in the CLASSPATH environmental variable.  They were stripped out for you.\nBefore: {0}\nAfter: {1}", comment="CLASSPATH is illegal.", cause="see message", action="see message", level="SEVERE")
    public static final String NO_QUOTES_ALLOWED = "NCLS-GFLAUNCHER-00001";
    @LogMessageInfo(message="Error Launching: {0}", comment="Launcher Error", cause="see message", action="fix the CLASSPATH", level="SEVERE")
    public static final String LAUNCH_FAILURE = "NCLS-GFLAUNCHER-00002";
    @LogMessageInfo(message="Could not locate the flashlight agent here: {0}", comment="catastrophic error", cause="see message", action="Find the agent file.", level="SEVERE")
    public static final String NO_FLASHLIGHT_AGENT = "NCLS-GFLAUNCHER-00003";
    @LogMessageInfo(message="Will copy glassfish/lib/templates/server.policy file to domain before upgrading.", comment="Upgrade Information", level="INFO")
    public static final String copy_server_policy = "NCLS-GFLAUNCHER-00004";
    @LogMessageInfo(message="JVM invocation command line:\n{0}", comment="Routine Information", cause="NA", action="NA", level="INFO")
    public static final String COMMAND_LINE = "NCLS-GFLAUNCHER-00005";

    private GFLauncherLogger() {
    }

    public static void warning(String msg, Object ... objs) {
        LOG.log(Level.WARNING, msg, objs);
    }

    public static void info(String msg, Object ... objs) {
        LOG.log(Level.INFO, msg, objs);
    }

    public static void severe(String msg, Object ... objs) {
        LOG.log(Level.SEVERE, msg, objs);
    }

    public static void fine(String msg, Object ... objs) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(strings.get(msg, objs));
        }
    }

    static void setConsoleLevel(Level level) {
        HANDLER_STDOUT.setLevel(level);
    }

    static void addLogFileHandler(String logFile) throws GFLauncherException {
        try {
            if (logFile == null || logfileHandler != null) {
                return;
            }
            logfileHandler = new FileHandler(logFile, true);
            logfileHandler.setFormatter((Formatter)new ODLLogFormatter());
            logfileHandler.setLevel(Level.INFO);
            LOG.addHandler(logfileHandler);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static void removeLogFileHandler() {
        FileHandler handler = logfileHandler;
        logfileHandler = null;
        if (handler != null) {
            LOG.removeHandler(handler);
            handler.close();
        }
    }

    static {
        strings = new LocalStringsImpl(GFLauncherLogger.class);
        LOG = Logger.getLogger(LOGGER_NAME, SHARED_LOGMESSAGE_RESOURCE);
        LOG.setLevel(Level.INFO);
        LOG.setUseParentHandlers(false);
        HANDLER_STDOUT = new SimpleLogHandler(System.out);
        HANDLER_STDOUT.setFormatter(new SimpleFormatter());
        LOG.addHandler(HANDLER_STDOUT);
    }
}

