/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.faces;

import com.sun.faces.facelets.tag.MetaRulesetImpl;
import com.sun.faces.facelets.tag.faces.ComponentSupport;
import com.sun.faces.facelets.tag.faces.CompositeComponentTagHandler;
import com.sun.faces.util.Util;
import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.ValueHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.view.AttachedObjectHandler;
import jakarta.faces.view.facelets.ConverterHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.MetaRuleset;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagException;
import jakarta.faces.view.facelets.TagHandlerDelegate;
import java.io.IOException;

public class ConverterTagHandlerDelegateImpl
extends TagHandlerDelegate
implements AttachedObjectHandler {
    private ConverterHandler owner;

    public ConverterTagHandlerDelegateImpl(ConverterHandler owner) {
        this.owner = owner;
    }

    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        if (parent == null || parent.getParent() != null) {
            return;
        }
        ComponentSupport.copyPassthroughAttributes(ctx, parent, this.owner.getTag());
        if (parent instanceof ValueHolder) {
            this.owner.applyAttachedObject(ctx.getFacesContext(), parent);
        } else if (UIComponent.isCompositeComponent(parent)) {
            if (null == this.owner.getFor()) {
                throw new TagException(this.owner.getTag(), "converter tags nested within composite components must have a non-null \"for\" attribute");
            }
            CompositeComponentTagHandler.getAttachedObjectHandlers(parent).add(this.owner);
        } else {
            throw new TagException(this.owner.getTag(), "Parent not an instance of ValueHolder: " + parent);
        }
    }

    @Override
    public MetaRuleset createMetaRuleset(Class type) {
        Util.notNull("type", type);
        MetaRulesetImpl m = new MetaRulesetImpl(this.owner.getTag(), type);
        return ((MetaRuleset)m).ignore("binding").ignore("for");
    }

    @Override
    public String getFor() {
        String result = null;
        TagAttribute attr = this.owner.getTagAttribute("for");
        if (null != attr) {
            if (attr.isLiteral()) {
                result = attr.getValue();
            } else {
                FacesContext context = FacesContext.getCurrentInstance();
                FaceletContext ctx = (FaceletContext)((Object)context.getAttributes().get(FaceletContext.FACELET_CONTEXT_KEY));
                result = (String)attr.getValueExpression(ctx, String.class).getValue((ELContext)ctx);
            }
        }
        return result;
    }

    @Override
    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        FaceletContext ctx = (FaceletContext)((Object)context.getAttributes().get(FaceletContext.FACELET_CONTEXT_KEY));
        ValueHolder vh = (ValueHolder)((Object)parent);
        ValueExpression ve = null;
        Converter c = null;
        if (this.owner.getBinding() != null) {
            ve = this.owner.getBinding().getValueExpression(ctx, Converter.class);
            c = (Converter)ve.getValue((ELContext)ctx);
        }
        if (c == null) {
            c = this.createConverter(ctx);
            if (ve != null) {
                ve.setValue((ELContext)ctx, (Object)c);
            }
        }
        if (c == null) {
            throw new TagException(this.owner.getTag(), "No Converter was created");
        }
        this.owner.setAttributes(ctx, c);
        vh.setConverter(c);
        Object lv = vh.getLocalValue();
        FacesContext faces = ctx.getFacesContext();
        if (lv instanceof String) {
            vh.setValue(c.getAsObject(faces, parent, (String)lv));
        }
    }

    private Converter createConverter(FaceletContext ctx) {
        if (this.owner.getConverterId(ctx) == null) {
            throw new TagException(this.owner.getTag(), "Default behavior invoked of requiring a converter-id passed in the constructor, must override ConvertHandler(ConverterConfig)");
        }
        return ctx.getFacesContext().getApplication().createConverter(this.owner.getConverterId(ctx));
    }
}

