/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul.handler;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.logging.Level;
import org.glassfish.main.jul.tracing.GlassFishLoggingTracer;

class Syslog {
    private final InetAddress addr;
    private final int port;
    private final Charset encoding;

    Syslog(String host, int port, Charset encoding) {
        try {
            this.addr = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Initialization of Syslog failed.", e);
        }
        this.port = port;
        this.encoding = encoding;
    }

    void log(SyslogLevel level, String msg) {
        try (DatagramSocket datagramSocket = new DatagramSocket();){
            byte[] buf = msg.getBytes(this.encoding);
            DatagramPacket packet = new DatagramPacket(buf, buf.length, this.addr, this.port);
            datagramSocket.send(packet);
        }
        catch (IOException e) {
            GlassFishLoggingTracer.error(this.getClass(), "Failed to send the log message: " + msg, e);
        }
    }

    static enum SyslogLevel {
        err(3),
        warning(4),
        info(6),
        debug(7);

        private int code;

        private SyslogLevel(int code) {
            this.code = code;
        }

        public int code() {
            return this.code;
        }

        public static SyslogLevel of(Level level) {
            if (level.intValue() <= Level.SEVERE.intValue()) {
                return err;
            }
            if (level.intValue() <= Level.WARNING.intValue()) {
                return warning;
            }
            if (level.intValue() <= Level.INFO.intValue()) {
                return info;
            }
            return debug;
        }
    }
}

