/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.jmsclient.ContainerType;
import com.sun.messaging.jmq.jmsclient.JMSContextImpl;
import com.sun.messaging.jmq.jmsclient.MQMessageConsumer;
import com.sun.messaging.jmq.jmsclient.Traceable;
import com.sun.messaging.jms.MQIllegalStateRuntimeException;
import com.sun.messaging.jms.MQInvalidDestinationRuntimeException;
import com.sun.messaging.jms.MQInvalidSelectorRuntimeException;
import com.sun.messaging.jms.MQMessageFormatRuntimeException;
import com.sun.messaging.jms.MQRuntimeException;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.InvalidSelectorException;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSException;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageListener;
import jakarta.jms.Topic;
import java.io.PrintStream;

public class JMSConsumerImpl
implements JMSConsumer,
Traceable {
    JMSContextImpl context;
    MQMessageConsumer messageConsumer;
    boolean closed = false;

    protected void initialiseConsumer(JMSContextImpl context, Destination destination) {
        context.checkNotClosed();
        this.context = context;
        try {
            this.messageConsumer = (MQMessageConsumer)context._getSession().createConsumer(destination);
        }
        catch (InvalidDestinationException e) {
            throw new MQInvalidDestinationRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
        if (context.getAutoStart()) {
            context.start();
        }
    }

    protected void initialiseConsumer(JMSContextImpl context, Destination destination, String messageSelector) {
        context.checkNotClosed();
        this.context = context;
        try {
            this.messageConsumer = (MQMessageConsumer)context._getSession().createConsumer(destination, messageSelector);
        }
        catch (InvalidDestinationException e) {
            throw new MQInvalidDestinationRuntimeException(e);
        }
        catch (InvalidSelectorException e) {
            throw new MQInvalidSelectorRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
        if (context.getAutoStart()) {
            context.start();
        }
    }

    protected void initialiseConsumer(JMSContextImpl context, Destination destination, String messageSelector, boolean noLocal) {
        context.checkNotClosed();
        this.context = context;
        try {
            this.messageConsumer = (MQMessageConsumer)context._getSession().createConsumer(destination, messageSelector, noLocal);
        }
        catch (InvalidDestinationException e) {
            throw new MQInvalidDestinationRuntimeException(e);
        }
        catch (InvalidSelectorException e) {
            throw new MQInvalidSelectorRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
        if (context.getAutoStart()) {
            context.start();
        }
    }

    protected void initialiseDurableConsumer(JMSContextImpl context, Topic topic, String name) {
        context.checkNotClosed();
        this.context = context;
        try {
            this.messageConsumer = (MQMessageConsumer)context._getSession().createDurableConsumer(topic, name);
        }
        catch (InvalidDestinationException e) {
            throw new MQInvalidDestinationRuntimeException(e);
        }
        catch (IllegalStateException e) {
            throw new MQIllegalStateRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
        if (context.getAutoStart()) {
            context.start();
        }
    }

    protected void initialiseDurableConsumer(JMSContextImpl context, Topic topic, String name, String messageSelector, boolean noLocal) {
        context.checkNotClosed();
        this.context = context;
        try {
            this.messageConsumer = (MQMessageConsumer)context._getSession().createDurableConsumer(topic, name, messageSelector, noLocal);
        }
        catch (InvalidDestinationException e) {
            throw new MQInvalidDestinationRuntimeException(e);
        }
        catch (InvalidSelectorException e) {
            throw new MQInvalidSelectorRuntimeException(e);
        }
        catch (IllegalStateException e) {
            throw new MQIllegalStateRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
        if (context.getAutoStart()) {
            context.start();
        }
    }

    protected void initialiseSharedDurableConsumer(JMSContextImpl context, Topic topic, String name) {
        context.checkNotClosed();
        this.context = context;
        try {
            this.messageConsumer = (MQMessageConsumer)context._getSession().createSharedDurableConsumer(topic, name);
        }
        catch (InvalidDestinationException e) {
            throw new MQInvalidDestinationRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
        if (context.getAutoStart()) {
            context.start();
        }
    }

    protected void initialiseSharedDurableConsumer(JMSContextImpl context, Topic topic, String name, String messageSelector) {
        context.checkNotClosed();
        this.context = context;
        try {
            this.messageConsumer = (MQMessageConsumer)context._getSession().createSharedDurableConsumer(topic, name, messageSelector);
        }
        catch (InvalidDestinationException e) {
            throw new MQInvalidDestinationRuntimeException(e);
        }
        catch (InvalidSelectorException e) {
            throw new MQInvalidSelectorRuntimeException(e);
        }
        catch (IllegalStateException e) {
            throw new MQIllegalStateRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
        if (context.getAutoStart()) {
            context.start();
        }
    }

    protected void initialiseSharedConsumer(JMSContextImpl context, Topic topic, String sharedSubscriptionName) {
        context.checkNotClosed();
        this.context = context;
        try {
            this.messageConsumer = (MQMessageConsumer)context._getSession().createSharedConsumer(topic, sharedSubscriptionName);
        }
        catch (InvalidDestinationException e) {
            throw new MQInvalidDestinationRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
        if (context.getAutoStart()) {
            context.start();
        }
    }

    protected void initialiseSharedConsumer(JMSContextImpl context, Topic topic, String sharedSubscriptionName, String messageSelector) {
        context.checkNotClosed();
        this.context = context;
        try {
            this.messageConsumer = (MQMessageConsumer)context._getSession().createSharedConsumer(topic, sharedSubscriptionName, messageSelector);
        }
        catch (InvalidDestinationException e) {
            throw new MQInvalidDestinationRuntimeException(e);
        }
        catch (InvalidSelectorException e) {
            throw new MQInvalidSelectorRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
        if (context.getAutoStart()) {
            context.start();
        }
    }

    @Override
    public void dump(PrintStream ps) {
        ps.println("------ JMSConsumerImpl dump start ------");
        ps.println("closed=" + this.closed);
        ps.println("Here is the MessageConsumer:");
        if (this.messageConsumer instanceof Traceable) {
            ((Traceable)((Object)this.messageConsumer)).dump(ps);
        }
        ps.println("------ JMSConsumerImpl dump end ------");
    }

    @Override
    public String getMessageSelector() {
        this.checkNotClosed();
        this.context.checkNotClosed();
        try {
            return this.messageConsumer.getMessageSelector();
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    @Override
    public MessageListener getMessageListener() {
        if (this.context.getContainerType() == ContainerType.JavaEE_Web_or_EJB) {
            String errorString = AdministeredObject.cr.getKString("C4306");
            throw new JMSRuntimeException(errorString);
        }
        this.checkNotClosed();
        this.context.checkNotClosed();
        try {
            return this.messageConsumer.getMessageListener();
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    @Override
    public void setMessageListener(MessageListener listener) {
        if (this.context.getContainerType() == ContainerType.JavaEE_Web_or_EJB) {
            String errorString = AdministeredObject.cr.getKString("C4306");
            throw new JMSRuntimeException(errorString);
        }
        this.checkNotClosed();
        this.context.checkNotClosed();
        try {
            this.messageConsumer.setMessageListener(listener);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    @Override
    public Message receive() {
        this.checkNotClosed();
        this.context.checkNotClosed();
        try {
            return this.messageConsumer.receive();
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    @Override
    public Message receive(long timeout) {
        this.checkNotClosed();
        this.context.checkNotClosed();
        try {
            return this.messageConsumer.receive(timeout);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    @Override
    public Message receiveNoWait() {
        this.checkNotClosed();
        this.context.checkNotClosed();
        try {
            return this.messageConsumer.receiveNoWait();
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    @Override
    public <T> T receiveBody(Class<T> c) {
        this.checkNotClosed();
        this.context.checkNotClosed();
        try {
            return this.messageConsumer.receiveBody(c);
        }
        catch (MessageFormatException mfe) {
            throw new MQMessageFormatRuntimeException(mfe);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    @Override
    public <T> T receiveBody(Class<T> c, long timeout) {
        this.checkNotClosed();
        this.context.checkNotClosed();
        try {
            return this.messageConsumer.receiveBody(c, timeout);
        }
        catch (MessageFormatException mfe) {
            throw new MQMessageFormatRuntimeException(mfe);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    @Override
    public <T> T receiveBodyNoWait(Class<T> c) {
        this.checkNotClosed();
        this.context.checkNotClosed();
        try {
            return this.messageConsumer.receiveBodyNoWait(c);
        }
        catch (MessageFormatException mfe) {
            throw new MQMessageFormatRuntimeException(mfe);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.context.removeConsumer(this);
        try {
            this.messageConsumer.close();
        }
        catch (IllegalStateException e) {
            throw new MQIllegalStateRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    protected void checkNotClosed() {
        if (this.closed) {
            String errorString = AdministeredObject.cr.getKString("C4308");
            throw new JMSRuntimeException(errorString);
        }
    }
}

