/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.transformers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetMethodParameterTypes;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.mappings.transformers.FieldTransformer;
import org.eclipse.persistence.sessions.Session;

public class MethodBasedFieldTransformer
implements FieldTransformer {
    protected transient Method fieldTransformationMethod;
    protected String methodName;
    protected AbstractTransformationMapping mapping;

    public MethodBasedFieldTransformer(String methodName) {
        this.methodName = methodName;
    }

    @Override
    public void initialize(AbstractTransformationMapping mapping) {
        this.mapping = mapping;
        Class javaClass = this.mapping.getDescriptor().getJavaClass();
        try {
            this.fieldTransformationMethod = Helper.getDeclaredMethod(javaClass, this.methodName, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            try {
                Class[] methodParameterTypes = new Class[]{ClassConstants.PublicInterfaceSession_Class};
                this.fieldTransformationMethod = Helper.getDeclaredMethod(javaClass, this.methodName, methodParameterTypes);
            }
            catch (NoSuchMethodException ex2) {
                try {
                    Class[] methodParameterTypes = new Class[]{ClassConstants.SessionsSession_Class};
                    this.fieldTransformationMethod = Helper.getDeclaredMethod(javaClass, this.methodName, methodParameterTypes);
                }
                catch (NoSuchMethodException exception) {
                    throw DescriptorException.noSuchMethodWhileConvertingToMethod(this.methodName, this.mapping, exception);
                }
                catch (SecurityException exception) {
                    throw DescriptorException.securityWhileConvertingToMethod(this.methodName, this.mapping, exception);
                }
            }
            catch (SecurityException exception) {
                throw DescriptorException.securityWhileConvertingToMethod(this.methodName, this.mapping, exception);
            }
        }
        catch (SecurityException exception) {
            throw DescriptorException.securityWhileConvertingToMethod(this.methodName, this.mapping, exception);
        }
    }

    public Class<?> getFieldType() {
        if (this.fieldTransformationMethod != null) {
            return this.fieldTransformationMethod.getReturnType();
        }
        return null;
    }

    @Override
    public Object buildFieldValue(Object object, String fieldName, Session session) {
        Class<?>[] parameterTypes = null;
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                parameterTypes = AccessController.doPrivileged(new PrivilegedGetMethodParameterTypes(this.fieldTransformationMethod));
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getCause();
            }
        } else {
            parameterTypes = PrivilegedAccessHelper.getMethodParameterTypes(this.fieldTransformationMethod);
        }
        Object[] parameters = new Object[parameterTypes.length];
        if (parameters.length == 1) {
            parameters[0] = session;
        }
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedMethodInvoker(this.fieldTransformationMethod, object, parameters));
                }
                catch (PrivilegedActionException ex) {
                    if (ex.getCause() instanceof IllegalAccessException) {
                        throw (IllegalAccessException)ex.getCause();
                    }
                    if (ex.getCause() instanceof InvocationTargetException) {
                        throw (InvocationTargetException)ex.getCause();
                    }
                    throw (RuntimeException)ex.getCause();
                }
            }
            return PrivilegedAccessHelper.invokeMethod(this.fieldTransformationMethod, object, parameters);
        }
        catch (IllegalAccessException exception) {
            throw DescriptorException.illegalAccessWhileInvokingFieldToMethod(this.fieldTransformationMethod.getName(), this.mapping, exception);
        }
        catch (IllegalArgumentException exception) {
            throw DescriptorException.illegalArgumentWhileInvokingFieldToMethod(this.fieldTransformationMethod.getName(), this.mapping, exception);
        }
        catch (InvocationTargetException exception) {
            throw DescriptorException.targetInvocationWhileInvokingFieldToMethod(this.fieldTransformationMethod.getName(), this.mapping, exception);
        }
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String name) {
        this.methodName = name;
    }
}

