/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseTable;

public class ForUpdateClause
implements Serializable,
Cloneable {
    protected static final ForUpdateClause NO_LOCK_CLAUSE = new ForUpdateClause();
    short lockMode;
    Integer waitTimeout;

    public ForUpdateClause() {
        this.lockMode = 0;
    }

    public ForUpdateClause(short lockMode) {
        this.lockMode = lockMode;
    }

    public ForUpdateClause(Integer waitTimeout) {
        this.lockMode = 1;
        this.waitTimeout = waitTimeout;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException never) {
            return null;
        }
    }

    public static ForUpdateClause newInstance(short lockMode) {
        if (lockMode == 0) {
            return NO_LOCK_CLAUSE;
        }
        return new ForUpdateClause(lockMode);
    }

    public static ForUpdateClause newInstance(Integer waitTimeout) {
        return new ForUpdateClause(waitTimeout);
    }

    public boolean isForUpdateOfClause() {
        return false;
    }

    public boolean isReferenceClassLocked() {
        return true;
    }

    public short getLockMode() {
        return this.lockMode;
    }

    public Integer getWaitTimeout() {
        return this.waitTimeout;
    }

    public void printSQL(ExpressionSQLPrinter printer, SQLSelectStatement statement) {
        if (this.getLockMode() == 1) {
            if (this.waitTimeout == null) {
                printer.printString(printer.getPlatform().getSelectForUpdateString());
            } else {
                printer.printString(printer.getPlatform().getSelectForUpdateWaitString(this.waitTimeout));
            }
        } else if (this.lockMode == 2) {
            printer.printString(printer.getPlatform().getSelectForUpdateNoWaitString());
        }
    }

    public Collection getAliasesOfTablesToBeLocked(SQLSelectStatement statement) {
        return new HashSet<DatabaseTable>(statement.getTableAliases().keySet());
    }
}

