/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.stringsubs.impl.algorithm;

import com.sun.enterprise.admin.servermgmt.stringsubs.StringSubstitutionException;
import com.sun.enterprise.admin.servermgmt.stringsubs.Substitutable;
import com.sun.enterprise.admin.servermgmt.stringsubs.SubstitutionAlgorithm;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.algorithm.RadixTree;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.algorithm.RadixTreeSubstitution;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import org.glassfish.main.jdke.i18n.LocalStringsImpl;

public class RadixTreeSubstitutionAlgo
implements SubstitutionAlgorithm {
    private RadixTree _tree;
    private static final LocalStringsImpl _strings = new LocalStringsImpl(RadixTreeSubstitutionAlgo.class);

    public RadixTreeSubstitutionAlgo(Map<String, String> substitutionMap) {
        if (substitutionMap == null || substitutionMap.isEmpty()) {
            throw new IllegalArgumentException(_strings.get("noKeyValuePairForSubstitution"));
        }
        this._tree = new RadixTree();
        for (Map.Entry<String, String> entry : substitutionMap.entrySet()) {
            this._tree.insert(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void substitute(Substitutable substitutable) throws StringSubstitutionException {
        Reader reader = substitutable.getReader();
        Writer writer = substitutable.getWriter();
        RadixTreeSubstitution sub = new RadixTreeSubstitution(this._tree);
        String output = null;
        char[] cbuffer = new char[8192];
        int count = 0;
        try {
            while ((count = reader.read(cbuffer)) > 0) {
                for (int i = 0; i < count; ++i) {
                    output = sub.substitute(Character.valueOf(cbuffer[i]));
                    if (output == null) continue;
                    writer.write(output);
                }
            }
            output = sub.substitute(null);
            if (output != null) {
                writer.write(output);
            }
            writer.flush();
        }
        catch (IOException e) {
            throw new StringSubstitutionException(_strings.get("errorInStringSubstitution", new Object[]{substitutable.getName()}), e);
        }
    }
}

