/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.bootstrap;

import jakarta.servlet.ServletContext;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.FeatureContext;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.krazo.bootstrap.ConfigProvider;
import org.eclipse.krazo.core.ViewResponseFilter;
import org.eclipse.krazo.servlet.KrazoContainerInitializer;
import org.eclipse.krazo.util.ServiceLoaders;

public final class Initializer {
    private static final Logger log = Logger.getLogger(Initializer.class.getName());

    private Initializer() {
    }

    public static void initialize(FeatureContext context, ServletContext servletContext) {
        Objects.requireNonNull(context, "FeatureContext is required");
        Configuration config = context.getConfiguration();
        if (!Initializer.isAlreadyInitialized(config) && Initializer.isMvcApplication(servletContext)) {
            log.info("Initializing Eclipse Krazo...");
            for (ConfigProvider provider : ServiceLoaders.list(ConfigProvider.class)) {
                log.log(Level.FINE, "Executing: {0}", provider.getClass().getName());
                provider.configure(context);
            }
        }
    }

    private static boolean isAlreadyInitialized(Configuration config) {
        return config.isRegistered(ViewResponseFilter.class);
    }

    private static boolean isMvcApplication(ServletContext servletContext) {
        Set controllersFound = servletContext != null ? (Set)servletContext.getAttribute(KrazoContainerInitializer.CONTROLLER_CLASSES) : null;
        boolean enable = controllersFound != null && !controllersFound.isEmpty();
        log.log(Level.FINE, "Is Eclipse Krazo application detected: {0}", enable);
        return enable;
    }
}

