/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public class MQAddress
implements Serializable {
    static final long serialVersionUID = -8430608988259524061L;
    public static final String isHostTrusted = "isHostTrusted";
    public static final String SCHEME_NAME_MQWS = "mqws";
    public static final String SCHEME_NAME_MQWSS = "mqwss";
    public static final String DEFAULT_WS_SERVICE = "wsjms";
    public static final String DEFAULT_WSS_SERVICE = "wssjms";
    protected static final String DEFAULT_SCHEME_NAME = "mq";
    protected static final String DEFAULT_HOSTNAME = "localhost";
    protected static final int DEFAULT_PORTMAPPER_PORT = 7676;
    protected static final String DEFAULT_SERVICENAME = "jms";
    private String addr = null;
    protected String schemeName = null;
    protected String addrHost = null;
    protected int port = -1;
    protected String serviceName = null;
    protected boolean isHTTP = false;
    protected boolean isWebSocket = false;
    protected Properties props = new Properties();
    protected transient String tostring = null;
    protected transient boolean isSSLHostTrustedSet = false;

    protected MQAddress() {
    }

    protected void initialize(String addr) throws MalformedURLException {
        this.addr = addr;
        this.init();
        this.parseAndValidate();
    }

    protected void initialize(String host, int port) throws MalformedURLException {
        if (port < 0) {
            throw new MalformedURLException("Illegal port :" + port);
        }
        if (host == null || host.trim().length() == 0) {
            this.addr = ":" + port;
        } else {
            URL u = new URL("http", host, port, "");
            this.addr = u.getHost() + ":" + port;
        }
        this.init();
        this.parseAndValidate();
    }

    private void init() {
        this.props.setProperty(isHostTrusted, "false");
    }

    protected void parseAndValidate() throws MalformedURLException {
        String tmp = this.addr;
        this.schemeName = DEFAULT_SCHEME_NAME;
        int i = tmp.indexOf("://");
        if (i > 0) {
            this.schemeName = tmp.substring(0, i);
            tmp = tmp.substring(i + 3);
        }
        if (this.schemeName.equalsIgnoreCase(DEFAULT_SCHEME_NAME) || this.schemeName.equalsIgnoreCase("mq+ssl")) {
            i = tmp.indexOf(63);
            if (i >= 0) {
                String qs = tmp.substring(i + 1);
                this.parseQueryString(qs);
                tmp = tmp.substring(0, i);
            }
            if ((i = tmp.indexOf(47)) >= 0) {
                this.serviceName = tmp.substring(i + 1);
                tmp = tmp.substring(0, i);
            }
            this.parseHostPort(tmp);
            if (this.serviceName == null || this.serviceName.equals("")) {
                this.serviceName = this.getDefaultServiceName();
            }
        } else if (this.schemeName.equalsIgnoreCase("mqssl") || this.schemeName.equalsIgnoreCase("mqtcp") || this.schemeName.equalsIgnoreCase(SCHEME_NAME_MQWS) || this.schemeName.equalsIgnoreCase(SCHEME_NAME_MQWSS)) {
            if (this.schemeName.equalsIgnoreCase(SCHEME_NAME_MQWS) || this.schemeName.equalsIgnoreCase(SCHEME_NAME_MQWSS)) {
                this.isWebSocket = true;
            }
            if ((i = tmp.indexOf(63)) >= 0) {
                String qs = tmp.substring(i + 1);
                this.parseQueryString(qs);
                tmp = tmp.substring(0, i);
            }
            if ((i = tmp.indexOf(47)) >= 0) {
                this.serviceName = tmp.substring(i + 1);
                tmp = tmp.substring(0, i);
            }
            this.parseHostPort(tmp);
        } else {
            if (this.schemeName.equalsIgnoreCase("http") || this.schemeName.equalsIgnoreCase("https")) {
                this.isHTTP = true;
                return;
            }
            throw new MalformedURLException("Illegal address. Unknown address scheme : " + this.addr);
        }
    }

    protected void parseHostPort(String tmp) throws MalformedURLException {
        int i = tmp.indexOf(58);
        if (i != -1 && i == tmp.lastIndexOf(58)) {
            String half1 = tmp.substring(0, i).trim();
            String half2 = tmp.substring(i + 1).trim();
            if (half1.length() == 0 || half2.length() == 0) {
                this.addrHost = half1.length() == 0 ? DEFAULT_HOSTNAME : half1;
                if (half2.length() == 0) {
                    this.port = 7676;
                } else {
                    this.port = Integer.parseInt(half2);
                    if (this.port < 0) {
                        throw new MalformedURLException("Illegal port in :" + tmp);
                    }
                }
                return;
            }
        }
        URL hp = new URL("http://" + tmp);
        this.port = hp.getPort();
        if (this.port == -1) {
            this.port = 7676;
        }
        this.addrHost = hp.getHost();
        if (this.addrHost == null || this.addrHost.equals("")) {
            this.addrHost = DEFAULT_HOSTNAME;
        }
    }

    protected void parseQueryString(String qs) throws MalformedURLException {
        String tmp = qs;
        while (tmp.length() > 0) {
            String pair = tmp;
            int i = tmp.indexOf(38);
            if (i >= 0) {
                pair = tmp.substring(0, i);
                tmp = tmp.substring(i + 1);
            } else {
                tmp = "";
            }
            int n = pair.indexOf(61);
            if (n <= 0) {
                throw new MalformedURLException("Illegal address. Bad query string : " + this.addr);
            }
            String name = pair.substring(0, n);
            String value = pair.substring(n + 1);
            this.props.setProperty(name, value);
            if (!isHostTrusted.equals(name)) continue;
            this.isSSLHostTrustedSet = true;
        }
    }

    public boolean isServicePortFinal() {
        return this.isHTTP || this.isWebSocket || this.schemeName.equalsIgnoreCase("mqtcp") || this.schemeName.equalsIgnoreCase("mqssl");
    }

    public String getProperty(String pname) {
        return this.props.getProperty(pname);
    }

    public boolean getIsSSLHostTrustedSet() {
        return this.isSSLHostTrustedSet;
    }

    public String getSchemeName() {
        return this.schemeName;
    }

    public boolean isSSLPortMapperScheme() {
        return this.schemeName.equalsIgnoreCase("mq+ssl");
    }

    public String getHostName() {
        return this.addrHost;
    }

    public int getPort() {
        return this.port;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public boolean getIsHTTP() {
        return this.isHTTP;
    }

    public String getURL() {
        return this.addr;
    }

    public String toString() {
        if (this.tostring != null) {
            return this.tostring;
        }
        if (this.isHTTP || this.isWebSocket) {
            this.tostring = this.addr;
            return this.addr;
        }
        this.tostring = this.schemeName + "://" + this.addrHost + ":" + this.port + "/" + this.serviceName;
        return this.tostring;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        return this.toString().equals(((MQAddress)obj).toString());
    }

    public String getDefaultServiceName() {
        return DEFAULT_SERVICENAME;
    }

    public static MQAddress getMQAddress(String addr) throws MalformedURLException {
        MQAddress ret = new MQAddress();
        ret.initialize(addr);
        return ret;
    }

    public static MQAddress getMQAddress(String host, int port) throws MalformedURLException {
        MQAddress ret = new MQAddress();
        ret.initialize(host, port);
        return ret;
    }
}

