/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.AbstractSourceBuilder;
import io.helidon.config.Config;
import io.helidon.config.spi.ConfigParser;
import io.helidon.config.spi.Source;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public abstract class AbstractConfigSourceBuilder<B extends AbstractConfigSourceBuilder<B, U>, U>
extends AbstractSourceBuilder<B, U>
implements Source.Builder<B> {
    private ConfigParser parser;
    private String mediaType;
    private Function<Config.Key, Optional<String>> mediaTypeMapping;
    private Function<Config.Key, Optional<ConfigParser>> parserMapping;
    private final B me = this;

    @Override
    protected B config(Config metaConfig) {
        super.config(metaConfig);
        metaConfig.get("media-type").asString().ifPresent(this::mediaType);
        metaConfig.get("media-type-mapping").detach().asMap().ifPresent(this::mediaTypeMappingConfig);
        return this.me;
    }

    private void mediaTypeMappingConfig(Map<String, String> mappingMap) {
        this.mediaTypeMapping(key -> Optional.ofNullable((String)mappingMap.get(key.toString())));
    }

    public B mediaTypeMapping(Function<Config.Key, Optional<String>> mediaTypeMapping) {
        Objects.requireNonNull(mediaTypeMapping, "mediaTypeMapping cannot be null");
        this.mediaTypeMapping = mediaTypeMapping;
        return this.me;
    }

    public B parserMapping(Function<Config.Key, Optional<ConfigParser>> parserMapping) {
        Objects.requireNonNull(parserMapping, "parserMapping cannot be null");
        this.parserMapping = parserMapping;
        return this.me;
    }

    protected B parser(ConfigParser parser) {
        this.parser = parser;
        return this.me;
    }

    Optional<Function<Config.Key, Optional<String>>> mediaTypeMapping() {
        return Optional.ofNullable(this.mediaTypeMapping);
    }

    Optional<Function<Config.Key, Optional<ConfigParser>>> parserMapping() {
        return Optional.ofNullable(this.parserMapping);
    }

    protected B mediaType(String mediaType) {
        this.mediaType = mediaType;
        return this.me;
    }

    Optional<ConfigParser> parser() {
        return Optional.ofNullable(this.parser);
    }

    Optional<String> mediaType() {
        return Optional.ofNullable(this.mediaType);
    }
}

