/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyHashMap<K, V>
extends HashMap<K, V>
implements Map<K, V> {
    private final Map<K, Callable<V>> lazyValuesMap = new HashMap<K, Callable<V>>();

    public LazyHashMap(Collection<LazyValue<K, V>> lazyValues) {
        for (LazyValue<K, V> lv : lazyValues) {
            this.lazyValuesMap.put(lv.key, lv.callable);
        }
    }

    @Override
    public V get(Object key) {
        Callable<V> callable;
        Object val = super.get(key);
        if (val == null && (callable = this.lazyValuesMap.get(key)) != null) {
            try {
                val = callable.call();
                if (val == null) {
                    throw new NullPointerException("Lazy computed values may not be null");
                }
                Object genericKey = key;
                this.put(genericKey, val);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return val;
    }

    @Override
    public V put(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return super.put(key, value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LazyValue<K, V> {
        final K key;
        final Callable<V> callable;

        public LazyValue(K key, Callable<V> callable) {
            this.key = key;
            this.callable = callable;
        }
    }
}

