/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.expressly.parser;

import jakarta.el.ELException;
import jakarta.el.MethodInfo;
import jakarta.el.MethodReference;
import jakarta.el.PropertyNotWritableException;
import jakarta.el.ValueReference;
import org.glassfish.expressly.lang.ELSupport;
import org.glassfish.expressly.lang.EvaluationContext;
import org.glassfish.expressly.parser.ELParserTreeConstants;
import org.glassfish.expressly.parser.Node;
import org.glassfish.expressly.parser.NodeVisitor;
import org.glassfish.expressly.util.MessageFactory;

public abstract class SimpleNode
extends ELSupport
implements Node {
    protected int id;
    protected Node parent;
    protected Node[] children;
    protected String image;

    public SimpleNode(int i) {
        this.id = i;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = n;
    }

    @Override
    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        if (this.image != null) {
            return ELParserTreeConstants.jjtNodeName[this.id] + "[" + this.image + "]";
        }
        return ELParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n == null) continue;
                n.dump(prefix + " ");
            }
        }
    }

    @Override
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    @Override
    public Class<?> getType(EvaluationContext ctx) throws ELException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getValue(EvaluationContext ctx) throws ELException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ValueReference getValueReference(EvaluationContext ctx) throws ELException {
        return null;
    }

    @Override
    public boolean isReadOnly(EvaluationContext ctx) throws ELException {
        return true;
    }

    @Override
    public void setValue(EvaluationContext ctx, Object value) throws ELException {
        throw new PropertyNotWritableException(MessageFactory.get("error.syntax.set"));
    }

    @Override
    public void accept(NodeVisitor visitor) throws ELException {
        visitor.visit(this);
        if (this.children != null && this.children.length > 0) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].accept(visitor);
            }
        }
    }

    @Override
    public Object invoke(EvaluationContext ctx, Class<?>[] paramTypes, Object[] paramValues) throws ELException {
        throw new UnsupportedOperationException();
    }

    @Override
    public MethodInfo getMethodInfo(EvaluationContext ctx, Class<?>[] paramTypes) throws ELException {
        throw new UnsupportedOperationException();
    }

    @Override
    public MethodReference getMethodReference(EvaluationContext ctx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object node) {
        if (!(node instanceof SimpleNode)) {
            return false;
        }
        SimpleNode simpleNode = (SimpleNode)node;
        if (this.id != simpleNode.id) {
            return false;
        }
        if (this.children == null && simpleNode.children == null) {
            if (this.image == null) {
                return simpleNode.image == null;
            }
            return this.image.equals(simpleNode.image);
        }
        if (this.children == null || simpleNode.children == null) {
            return false;
        }
        if (this.children.length != simpleNode.children.length) {
            return false;
        }
        if (this.children.length == 0) {
            if (this.image == null) {
                return simpleNode.image == null;
            }
            return this.image.equals(simpleNode.image);
        }
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i].equals(simpleNode.children[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isParametersProvided() {
        return false;
    }

    @Override
    public int hashCode() {
        if (this.children == null || this.children.length == 0) {
            if (this.image != null) {
                return this.image.hashCode();
            }
            return this.id;
        }
        int h = 0;
        for (int i = this.children.length - 1; i >= 0; --i) {
            h = h + h + h + this.children[i].hashCode();
        }
        h = h + h + h + this.id;
        return h;
    }
}

