/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.StoredProcedureDefinition;

public class PackageDefinition
extends DatabaseObjectDefinition {
    protected List<String> statements = new Vector<String>();
    protected List<StoredProcedureDefinition> procedures = new Vector<StoredProcedureDefinition>();

    public void addProcedures(StoredProcedureDefinition procedure) {
        this.getProcedures().add(procedure);
    }

    public void addStatement(String statement) {
        this.getStatements().add(statement);
    }

    @Override
    public Writer buildCreationWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            DatabasePlatform platform = session.getPlatform();
            writer.write("CREATE PACKAGE " + this.getFullName());
            writer.write(" AS");
            writer.write("\n");
            for (String statement : this.statements) {
                writer.write(statement);
                writer.write(platform.getBatchDelimiterString());
                writer.write("\n");
            }
            for (StoredProcedureDefinition procedure : this.procedures) {
                writer.write("\n");
                String procedureString = procedure.buildCreationWriter(session, writer).toString();
                writer.write(procedureString.substring(7, procedureString.length()));
                writer.write("\n");
            }
            writer.write(platform.getBatchEndString());
            writer.write("\n" + session.getPlatform().getStoredProcedureTerminationToken());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    @Override
    public Writer buildDeletionWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            writer.write("DROP PACKAGE " + this.getFullName());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public List<StoredProcedureDefinition> getProcedures() {
        return this.procedures;
    }

    public List<String> getStatements() {
        return this.statements;
    }

    public void setProcedures(List<StoredProcedureDefinition> procedures) {
        this.procedures = procedures;
    }

    public void setStatements(List<String> statements) {
        this.statements = statements;
    }
}

