/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.component.dataprovider;

import com.sun.data.provider.DataProviderException;
import com.sun.data.provider.FieldKey;
import com.sun.data.provider.impl.ObjectFieldKeySupport;
import com.sun.jsftemplating.component.dataprovider.IndexFieldKey;
import com.sun.jsftemplating.component.dataprovider.MapObjectFieldKeySupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class MultipleObjectFieldKeySupport {
    private List<ObjectFieldKeySupport> _children = new ArrayList<ObjectFieldKeySupport>();

    public MultipleObjectFieldKeySupport(Object[] objs, boolean includeFields) {
        for (Object obj : objs) {
            if (obj instanceof Map) {
                this._children.add(new MapObjectFieldKeySupport(obj.getClass(), (Map)obj));
                continue;
            }
            this._children.add(new ObjectFieldKeySupport(obj.getClass(), includeFields));
        }
    }

    public FieldKey getFieldKey(String fieldId) throws DataProviderException {
        FieldKey key = null;
        int idx = 0;
        for (ObjectFieldKeySupport support : this._children) {
            key = support.getFieldKey(fieldId);
            if (key != null) {
                key = new IndexFieldKey(key, idx);
                break;
            }
            ++idx;
        }
        return key;
    }

    public FieldKey[] getFieldKeys() throws DataProviderException {
        TreeSet<FieldKey> keys = new TreeSet<FieldKey>();
        FieldKey[] keyArr = null;
        int idx = 0;
        for (ObjectFieldKeySupport support : this._children) {
            keyArr = support.getFieldKeys();
            for (int cnt = 0; cnt < keyArr.length; ++cnt) {
                keyArr[cnt] = new IndexFieldKey(keyArr[cnt], idx++);
            }
            keys.addAll(Arrays.asList(keyArr));
        }
        return keys.toArray(new FieldKey[keys.size()]);
    }

    public Class getType(FieldKey fieldKey) throws DataProviderException {
        Class type = null;
        if (fieldKey instanceof IndexFieldKey) {
            type = this._children.get(((IndexFieldKey)fieldKey).getIndex()).getType(fieldKey);
        } else {
            ObjectFieldKeySupport support;
            Iterator<ObjectFieldKeySupport> iterator = this._children.iterator();
            while (iterator.hasNext() && (type = (support = iterator.next()).getType(fieldKey)) == null) {
            }
        }
        return type;
    }

    public Object getValue(FieldKey fieldKey, Object base) throws DataProviderException {
        Object value = null;
        if (fieldKey instanceof IndexFieldKey) {
            value = this._children.get(((IndexFieldKey)fieldKey).getIndex()).getValue(fieldKey, base);
        } else {
            ObjectFieldKeySupport support;
            Iterator<ObjectFieldKeySupport> iterator = this._children.iterator();
            while (iterator.hasNext() && (value = (support = iterator.next()).getValue(fieldKey, base)) == null) {
            }
        }
        return value;
    }

    public boolean isAssignable(FieldKey fieldKey, Object value) throws DataProviderException {
        boolean assignable = false;
        if (fieldKey instanceof IndexFieldKey) {
            assignable = this._children.get(((IndexFieldKey)fieldKey).getIndex()).isAssignable(fieldKey, value);
        } else {
            ObjectFieldKeySupport support;
            Iterator<ObjectFieldKeySupport> iterator = this._children.iterator();
            while (iterator.hasNext() && !(assignable = (support = iterator.next()).isAssignable(fieldKey, value))) {
            }
        }
        return assignable;
    }

    public boolean isReadOnly(FieldKey fieldKey) throws DataProviderException {
        boolean readOnly = true;
        if (fieldKey instanceof IndexFieldKey) {
            readOnly = this._children.get(((IndexFieldKey)fieldKey).getIndex()).isReadOnly(fieldKey);
        } else {
            FieldKey fk = null;
            for (ObjectFieldKeySupport support : this._children) {
                fk = support.getFieldKey(fieldKey.getFieldId());
                if (fk == null) continue;
                readOnly = support.isReadOnly(fieldKey);
                break;
            }
        }
        return readOnly;
    }

    public void setValue(FieldKey fieldKey, Object base, Object value) throws DataProviderException {
        if (fieldKey instanceof IndexFieldKey) {
            this._children.get(((IndexFieldKey)fieldKey).getIndex()).setValue(fieldKey, base, value);
        } else {
            FieldKey fk = null;
            for (ObjectFieldKeySupport support : this._children) {
                fk = support.getFieldKey(fieldKey.getFieldId());
                if (fk == null) continue;
                support.setValue(fieldKey, base, value);
                break;
            }
        }
    }
}

