/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.ClassLineageIterator;
import com.sun.enterprise.admin.util.GenericAdminAuthenticator;
import jakarta.inject.Singleton;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.glassfish.api.admin.NamedResource;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class NamedResourceManager {
    private final WeakHashMap<Class<?>, Model> models = new WeakHashMap();
    private final WeakHashMap<Object, String> instanceNames = new WeakHashMap();
    private final String LINE_SEP = System.getProperty("line.separator");
    private static final Logger ADMSEC_LOGGER = GenericAdminAuthenticator.ADMSEC_LOGGER;

    public <T> T register(T instance) throws IllegalArgumentException, IllegalAccessException {
        Model model = this.findOrCreateModel(instance.getClass());
        if (!model.isPrimary) {
            throw new IllegalArgumentException(instance.getClass().getName() + " ! isPrimary");
        }
        StringBuilder addedNames = new StringBuilder();
        T result = this.register("", model.owningCollectionName, instance, model, addedNames);
        if (ADMSEC_LOGGER.isLoggable(Level.FINER)) {
            ADMSEC_LOGGER.log(Level.FINER, "Added named resources:\n{0}", addedNames.toString());
        }
        return result;
    }

    public String find(Object resource) {
        return this.instanceNames.get(resource);
    }

    private <T> T register(String prefix, String containingCollectionName, T instance, StringBuilder addedNames) throws IllegalArgumentException, IllegalAccessException {
        Model model = this.findOrCreateModel(instance.getClass());
        return this.register(prefix, containingCollectionName, instance, model, addedNames);
    }

    private <T> T register(String prefix, String containingCollectionName, T instance, Model model, StringBuilder addedNames) throws IllegalArgumentException, IllegalAccessException {
        String instanceName = prefix + this.instanceName(instance, containingCollectionName, model);
        this.instanceNames.put(instance, instanceName);
        addedNames.append(instanceName).append(this.LINE_SEP);
        this.registerChildren(instanceName + "/", instance, model, addedNames);
        return instance;
    }

    private <T> void registerChildren(String prefix, T instance, Model model, StringBuilder addedNames) throws IllegalArgumentException, IllegalAccessException {
        for (Field f : model.resourceNamedFields) {
            Object child = f.get(instance);
            if (f.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(child); ++i) {
                    this.register(prefix, this.collectionName(f), Array.get(child, i), addedNames);
                }
                continue;
            }
            if (Collection.class.isAssignableFrom(f.getType())) {
                Collection coll = (Collection)child;
                for (Object o : coll) {
                    this.register(prefix, this.collectionName(f), o, addedNames);
                }
                continue;
            }
            this.register(prefix, null, child, addedNames);
        }
    }

    private String collectionName(Field f) {
        return f.getName();
    }

    private Model findOrCreateModel(Class<?> c) {
        Model result = this.models.get(c);
        if (result == null) {
            result = this.buildModel(c);
            this.models.put(c, result);
        }
        return result;
    }

    private String instanceName(Object instance, String containingCollectionName, Model model) throws IllegalArgumentException, IllegalAccessException {
        StringBuilder sb = new StringBuilder();
        if (containingCollectionName != null && !containingCollectionName.isEmpty()) {
            sb.append(containingCollectionName).append('/').append(model.subpath).append('/');
        }
        return sb.append(model.keyField.get(instance).toString()).toString();
    }

    private Model buildModel(Class<?> c) {
        Model model = new Model(c);
        return model;
    }

    private static class Model {
        private boolean isPrimary;
        private boolean isSingleton;
        private String owningCollectionName;
        private String subpath;
        private final Collection<Field> resourceNamedFields = new ArrayList<Field>();
        private Field keyField;
        static final Pattern TOKENIZER;

        private static String split(String lookback, String lookahead) {
            return "((?<=" + lookback + ")(?=" + lookahead + "))";
        }

        private static String or(String ... tokens) {
            StringBuilder buf = new StringBuilder();
            for (String t : tokens) {
                if (buf.length() > 0) {
                    buf.append('|');
                }
                buf.append(t);
            }
            return buf.toString();
        }

        private static String convertName(String name) {
            StringBuilder buf = new StringBuilder(name.length() + 5);
            for (String t : TOKENIZER.split(name)) {
                if (buf.length() > 0) {
                    buf.append('-');
                }
                buf.append(t.toLowerCase(Locale.ENGLISH));
            }
            return buf.toString();
        }

        private static String defaultSubpath(Class<?> c) {
            String className = Model.convertName(c.getName());
            String shortClassName = className.substring(className.lastIndexOf(46) + 1);
            return shortClassName;
        }

        private static String defaultCollectionName(Class<?> c) {
            return Model.pluralize(Model.defaultSubpath(c));
        }

        private static String pluralize(String s) {
            char lastChar = s.charAt(s.length() - 1);
            if (lastChar == 's' || lastChar == 'S' || lastChar == 'x' || lastChar == 'X') {
                return s + "es";
            }
            return s + "s";
        }

        private Model(Class<?> c) {
            boolean isNamedResource = false;
            this.isSingleton = true;
            ClassLineageIterator cIT = new ClassLineageIterator(c);
            while (cIT.hasNext()) {
                Object currentClass = cIT.next();
                NamedResource r = ((Class)currentClass).getAnnotation(NamedResource.class);
                if (r == null) continue;
                isNamedResource = true;
                this.isPrimary = r.isPrimary();
                this.subpath = r.subpath().isEmpty() ? Model.defaultSubpath(c) : r.subpath();
                for (Field f : ((Class)currentClass).getDeclaredFields()) {
                    f.setAccessible(true);
                    if (f.getAnnotation(NamedResource.class) != null) {
                        this.resourceNamedFields.add(f);
                    }
                    if (f.getAnnotation(NamedResource.Key.class) == null) continue;
                    if (f.getType().isArray()) {
                        throw new IllegalArgumentException(c.getName() + "@NamedResource.ID");
                    }
                    this.keyField = f;
                }
                if (this.isSingleton) {
                    if (!r.collectionName().isEmpty()) {
                        throw new IllegalArgumentException(c.getName() + " @NamedResource isSingleton & collectionName");
                    }
                    this.owningCollectionName = null;
                    continue;
                }
                this.owningCollectionName = r.collectionName().isEmpty() ? Model.defaultCollectionName(c) : r.collectionName();
            }
            if (!isNamedResource) {
                throw new IllegalArgumentException(c.getName() + " ! @NamedResource");
            }
            if (this.keyField == null) {
                throw new IllegalArgumentException(c.getName() + " ! @NamedResource.ID");
            }
        }

        static {
            String pattern = Model.or(Model.split("x", "X"), Model.split("X", "Xx"), Model.split("\\d", "\\D"));
            pattern = pattern.replace("x", "\\p{Lower}").replace("X", "\\p{Upper}");
            TOKENIZER = Pattern.compile(pattern);
        }
    }
}

