/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Anchor;
import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.ClientSniffer;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.beans.Beans;
import java.io.IOException;
import java.net.URL;

public final class AnchorRenderer
extends AbstractRenderer {
    private static final String ANCHOR_IMAGE = "_img";
    private static final String DESIGN_TIME_ICON = "/com/sun/webui/jsf/design/resources/AnchorIcon.gif";

    @Override
    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Anchor anchor = (Anchor)component;
        writer.startElement("a", (UIComponent)anchor);
    }

    @Override
    protected void renderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Anchor anchor = (Anchor)component;
        String id = anchor.getId();
        if (Beans.isDesignTime()) {
            writer.startElement("img", (UIComponent)anchor);
            try {
                URL url = ((Object)((Object)this)).getClass().getResource(DESIGN_TIME_ICON);
                writer.writeURIAttribute("src", (Object)url, null);
            }
            catch (IOException e) {
                LogUtil.severe("Error getting anchor icon: ", e);
            }
            writer.endElement("img");
        }
        writer.writeAttribute("id", (Object)id, "id");
        String style = anchor.getStyle();
        String styleClass = anchor.getStyleClass();
        if (styleClass != null) {
            RenderingUtilities.renderStyleClass(context, writer, component, null);
        }
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.writeAttribute("name", (Object)id, null);
    }

    @Override
    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        ClientSniffer sniffer = ClientSniffer.getInstance(context);
        if (sniffer.isIe6up() || sniffer.isIe7() || sniffer.isIe7up()) {
            Icon icon = new Icon();
            icon.setIcon("DOT");
            icon.setId(component.getId() + ANCHOR_IMAGE);
            RenderingUtilities.renderComponent((UIComponent)icon, context);
        }
        Anchor anchor = (Anchor)component;
        writer.endElement("a");
    }
}

