/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.StringStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.StringStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="thread-system-mon", group="monitoring")
@ManagedObject
@Description(value="JVM Thread System Statistics")
public class JVMThreadSystemStatsProvider {
    private ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
    private StringStatisticImpl allThreadIds = new StringStatisticImpl("LiveThreads", "String", "Returns all live thread IDs");
    private CountStatisticImpl currentThreadCpuTime = new CountStatisticImpl("CurrentThreadCpuTime", "nanosecond", "Returns the total CPU time for the current thread in nanoseconds");
    private CountStatisticImpl currentThreadUserTime = new CountStatisticImpl("CurrentThreadUserTime", "nanosecond", "Returns the CPU time that the current thread has executed in user mode in nanoseconds");
    private CountStatisticImpl daemonThreadCount = new CountStatisticImpl("DaemonThreadCount", "count", "Returns the current number of live daemon threads");
    private StringStatisticImpl deadlockedThreads = new StringStatisticImpl("DeadlockedThreads", "String", "Finds cycles of threads that are in deadlock waiting to acquire object monitors or ownable synchronizers");
    private StringStatisticImpl monitorDeadlockedThreads = new StringStatisticImpl("MonitorDeadlockedThreads", "String", "Finds cycles of threads that are in deadlock waiting to acquire object monitors");
    private CountStatisticImpl peakThreadCount = new CountStatisticImpl("PeakThreadCount", "count", "Returns the peak live thread count since the Java virtual machine started or peak was reset");
    private CountStatisticImpl threadCount = new CountStatisticImpl("ThreadCount", "count", "Returns the current number of live threads including both daemon and non-daemon threads");
    private CountStatisticImpl totalStartedThreadCount = new CountStatisticImpl("TotalStartedThreadCount", "count", "Returns the total number of threads created and also started since the Java virtual machine started");

    @ManagedAttribute(id="allthreadids")
    @Description(value="Returns all live thread IDs")
    public StringStatistic getAllThreadIds() {
        long[] ids = this.threadBean.getAllThreadIds();
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (long id : ids) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(id);
        }
        this.allThreadIds.setCurrent(sb.toString());
        return this.allThreadIds;
    }

    @ManagedAttribute(id="currentthreadcputime")
    @Description(value="Returns the total CPU time for the current thread in nanoseconds")
    public CountStatistic getCurrentThreadCpuTime() {
        this.currentThreadCpuTime.setCount(this.threadBean.getCurrentThreadCpuTime());
        return this.currentThreadCpuTime;
    }

    @ManagedAttribute(id="currentthreadusertime")
    @Description(value="Returns the CPU time that the current thread has executed in user mode in nanoseconds")
    public CountStatistic getCurrentThreadUserTime() {
        this.currentThreadUserTime.setCount(this.threadBean.getCurrentThreadUserTime());
        return this.currentThreadUserTime;
    }

    @ManagedAttribute(id="daemonthreadcount")
    @Description(value="Returns the current number of live daemon threads")
    public CountStatistic getDaemonThreadCount() {
        this.daemonThreadCount.setCount((long)this.threadBean.getDaemonThreadCount());
        return this.daemonThreadCount;
    }

    @ManagedAttribute(id="deadlockedthreads")
    @Description(value="Finds cycles of threads that are in deadlock waiting to acquire object monitors or ownable synchronizers")
    public StringStatistic getDeadlockedThreads() {
        long[] threads = this.threadBean.findDeadlockedThreads();
        if (threads == null) {
            this.deadlockedThreads.setCurrent("None of the threads are deadlocked.");
        } else {
            StringBuffer sb = new StringBuffer();
            for (long thread : threads) {
                sb.append(thread);
                sb.append(',');
            }
            this.deadlockedThreads.setCurrent(sb.toString());
        }
        return this.deadlockedThreads;
    }

    @ManagedAttribute(id="monitordeadlockedthreads")
    @Description(value="Finds cycles of threads that are in deadlock waiting to acquire object monitors")
    public StringStatistic getMonitorDeadlockedThreads() {
        long[] threads = this.threadBean.findMonitorDeadlockedThreads();
        if (threads == null) {
            this.monitorDeadlockedThreads.setCurrent("None of the threads are monitor deadlocked.");
        } else {
            StringBuffer sb = new StringBuffer();
            for (long thread : threads) {
                sb.append(thread);
                sb.append(',');
            }
            this.monitorDeadlockedThreads.setCurrent(sb.toString());
        }
        return this.monitorDeadlockedThreads;
    }

    @ManagedAttribute(id="peakthreadcount")
    @Description(value="Returns the peak live thread count since the Java virtual machine started or peak was reset")
    public CountStatistic getPeakThreadCount() {
        this.peakThreadCount.setCount((long)this.threadBean.getPeakThreadCount());
        return this.peakThreadCount;
    }

    @ManagedAttribute(id="threadcount")
    @Description(value="Returns the current number of live threads including both daemon and non-daemon threads")
    public CountStatistic getThreadCount() {
        this.threadCount.setCount((long)this.threadBean.getThreadCount());
        return this.threadCount;
    }

    @ManagedAttribute(id="totalstartedthreadcount")
    @Description(value="Returns the total number of threads created and also started since the Java virtual machine started")
    public CountStatistic getTotalStartedThreadCount() {
        this.totalStartedThreadCount.setCount(this.threadBean.getTotalStartedThreadCount());
        return this.totalStartedThreadCount;
    }
}

