/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.boot.osgi;

import java.io.File;
import java.io.FileFilter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.glassfish.main.boot.log.LogFacade;
import org.glassfish.main.boot.osgi.BundleProvisionerCustomizer;
import org.glassfish.main.boot.osgi.Jar;

class DefaultBundleProvisionerCustomizer
implements BundleProvisionerCustomizer {
    private static final Logger LOG = LogFacade.BOOTSTRAP_LOGGER;
    private final Properties config;
    private final Map<URI, Integer> startLevels = new HashMap<URI, Integer>();
    private List<URI> autoInstallLocations;
    private List<URI> autoStartLocations;
    private List<URI> configuredAutoInstallLocations;

    DefaultBundleProvisionerCustomizer(Properties config) {
        this.config = config;
        this.processAutoInstallLocations();
        LOG.log(Level.CONFIG, () -> "autoInstallLocations:\n" + String.valueOf(this.autoInstallLocations));
        this.processAutoStartLocations();
        LOG.log(Level.CONFIG, () -> "autoStartLocations:\n" + String.valueOf(this.autoStartLocations));
        this.processStartLevels();
        LOG.log(Level.CONFIG, () -> "configuredAutoInstallLocations:\n" + String.valueOf(this.configuredAutoInstallLocations));
    }

    private void processAutoInstallLocations() {
        String list = this.config.getProperty("glassfish.osgi.auto.install");
        this.configuredAutoInstallLocations = this.getLocations(list, false);
        this.autoInstallLocations = this.getLocations(list);
    }

    private void processAutoStartLocations() {
        String list = this.config.getProperty("glassfish.osgi.auto.start");
        this.autoStartLocations = this.getLocations(list);
    }

    private void processStartLevels() {
        for (String key : this.config.stringPropertyNames()) {
            if (!key.startsWith("glassfish.osgi.auto.start.level")) continue;
            try {
                Integer startLevel = Integer.parseInt(key.substring(key.lastIndexOf(46) + 1));
                String list = this.config.getProperty(key);
                for (URI uri : this.getLocations(list)) {
                    if (this.startLevels.containsKey(uri)) {
                        LOG.log(Level.WARNING, "NCLS-BOOTSTRAP-00014", new Object[]{uri, this.startLevels.get(uri), startLevel});
                        continue;
                    }
                    this.startLevels.put(uri, startLevel);
                }
            }
            catch (NumberFormatException ex) {
                System.err.println("Invalid property: " + key);
            }
        }
    }

    @Override
    public List<URI> getAutoInstallLocations() {
        return this.autoInstallLocations;
    }

    @Override
    public List<URI> getAutoStartLocations() {
        return this.autoStartLocations;
    }

    private List<URI> getLocations(String list) {
        return this.getLocations(list, true);
    }

    private List<URI> getLocations(String list, boolean expand) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<URI> uris = new ArrayList<URI>();
        for (String uriString : list.split("\\s")) {
            try {
                URI uri = new URI(uriString);
                if (!uri.isAbsolute()) {
                    LOG.log(Level.WARNING, "NCLS-BOOTSTRAP-00015", uri);
                    continue;
                }
                if (expand && this.isDirectory(uri)) {
                    uris.addAll(this.listJarFiles(uri));
                    continue;
                }
                uris.add(uri);
            }
            catch (URISyntaxException e) {
                LogFacade.log(LOG, Level.WARNING, "NCLS-BOOTSTRAP-00016", e, uriString);
            }
        }
        return uris;
    }

    @Override
    public int getStartOptions() {
        String autostart = this.config.getProperty("glassfish.osgi.auto.start.options");
        return autostart == null ? 2 : Integer.parseInt(autostart);
    }

    @Override
    public String makeLocation(Jar jar) {
        return jar.getURI().toString();
    }

    protected boolean isDirectory(URI uri) {
        try {
            return new File(uri).isDirectory();
        }
        catch (Exception e) {
            return false;
        }
    }

    protected List<? extends URI> listJarFiles(URI aDirectoryURI) {
        if (!"file".equalsIgnoreCase(aDirectoryURI.getScheme())) {
            throw new IllegalStateException("Currently we only support file URI scheme.");
        }
        FileFilter filter = path -> path.getName().endsWith(".jar") && !path.isDirectory();
        return Stream.of(new File(aDirectoryURI).listFiles(filter)).map(File::toURI).collect(Collectors.toList());
    }

    @Override
    public boolean isManaged(Jar jar) {
        URI uri = jar.getURI();
        if (uri == null) {
            return false;
        }
        for (URI configuredLocation : this.getConfiguredAutoInstallLocations()) {
            String otherLocationAsString = configuredLocation.toString();
            if (!uri.toString().regionMatches(0, otherLocationAsString, 0, otherLocationAsString.length())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Integer getStartLevel(Jar jar) {
        return this.startLevels.get(jar.getURI());
    }

    protected List<URI> getConfiguredAutoInstallLocations() {
        return this.configuredAutoInstallLocations;
    }
}

