/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JaccProvider;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.cli.CLIUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.beans.PropertyVetoException;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-jacc-provider")
@PerLookup
@I18n(value="delete.jacc.provider")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
public class DeleteJaccProvider
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteJaccProvider.class);
    @Param(name="jaccprovidername", primary=true)
    private String jaccprovider;
    @Param(name="target", optional=true, defaultValue="server")
    private String target;
    @Inject
    @Named(value="default-instance-name")
    private Config config;
    @Inject
    private Domain domain;
    private SecurityService securityService;
    @AccessRequired.To(value={"delete"})
    private JaccProvider jprov;

    public boolean preAuthorization(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        this.config = CLIUtil.chooseConfig(this.domain, this.target, report);
        if (this.config == null) {
            return false;
        }
        this.securityService = this.config.getSecurityService();
        this.jprov = CLIUtil.findJaccProvider(this.securityService, this.jaccprovider);
        if (this.jprov == null) {
            report.setMessage(localStrings.getLocalString("delete.jacc.provider.notfound", "JaccProvider named {0} not found", new Object[]{this.jaccprovider}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        if ("default".equals(this.jprov.getName()) || "simple".equals(this.jprov.getName())) {
            report.setMessage(localStrings.getLocalString("delete.jacc.provider.notallowed", "JaccProvider named {0} is a system provider and cannot be deleted", new Object[]{this.jaccprovider}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        return true;
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            List jaccProviders = this.securityService.getJaccProvider();
            JaccProvider jprov = null;
            for (JaccProvider jaccProv : jaccProviders) {
                if (!jaccProv.getName().equals(this.jaccprovider)) continue;
                jprov = jaccProv;
                break;
            }
            final JaccProvider jaccprov = jprov;
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<SecurityService>(){

                public Object run(SecurityService param) throws PropertyVetoException, TransactionFailure {
                    param.getJaccProvider().remove(jaccprov);
                    return null;
                }
            }, (ConfigBeanProxy)this.securityService);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("delete.jacc.provider.fail", "Deletion of JaccProvider {0} failed", new Object[]{this.jaccprovider}) + "  " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

