/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.jmsclient.BrowserConsumer;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import java.util.Enumeration;
import java.util.Vector;

public class QueueBrowserImpl
implements QueueBrowser {
    private SessionImpl session = null;
    private Queue queue = null;
    private String messageSelector = null;
    private Vector consumers = new Vector();
    private boolean isClosed = false;

    public QueueBrowserImpl(SessionImpl session, Queue queue) throws JMSException {
        this(session, queue, null);
    }

    public QueueBrowserImpl(SessionImpl session, Queue queue, String selector) throws JMSException {
        if (queue == null) {
            String errorString = AdministeredObject.cr.getKString("C4050", "null");
            throw new InvalidDestinationException(errorString, "C4050");
        }
        this.session = session;
        this.queue = queue;
        this.messageSelector = selector;
        this.init();
    }

    private void init() throws JMSException {
        this.session.checkBrowserCreation();
        this.session.verifyDestination((Destination)this.queue, this.messageSelector, true);
    }

    public Queue getQueue() throws JMSException {
        this.checkState();
        return this.queue;
    }

    public String getMessageSelector() throws JMSException {
        this.checkState();
        return this.messageSelector;
    }

    public Enumeration getEnumeration() throws JMSException {
        this.checkState();
        return new BrowserConsumer(this, (Destination)this.queue, this.messageSelector);
    }

    protected void addBrowserConsumer(BrowserConsumer consumer) {
        this.consumers.addElement(consumer);
    }

    protected void removeBrowserConsumer(BrowserConsumer consumer) {
        this.consumers.removeElement(consumer);
    }

    public void close() throws JMSException {
        BrowserConsumer consumer = null;
        for (int i = this.consumers.size() - 1; i >= 0; --i) {
            consumer = (BrowserConsumer)this.consumers.elementAt(i);
            consumer.close();
        }
        this.isClosed = true;
    }

    protected SessionImpl getSession() {
        return this.session;
    }

    protected void checkState() throws JMSException {
        if (this.isClosed) {
            String errorString = AdministeredObject.cr.getKString("C4046");
            throw new IllegalStateException(errorString, "C4046");
        }
        this.session.checkSessionState();
    }
}

