/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.mbean;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.enterprise.server.logging.ServerLogFileManager;
import com.sun.enterprise.server.logging.diagnostics.MessageIdCatalog;
import com.sun.enterprise.server.logging.logviewer.backend.LogFilter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.ObjectName;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.impl.mbean.AMXImplBase;
import org.glassfish.admin.amx.impl.util.InjectedValues;
import org.glassfish.admin.amx.logging.LogRecordEmitter;
import org.glassfish.admin.amx.logging.Logging;
import org.glassfish.admin.amx.util.CollectionUtil;
import org.glassfish.admin.amx.util.ExceptionUtil;
import org.glassfish.admin.amx.util.ListUtil;
import org.glassfish.admin.amx.util.SetUtil;
import org.glassfish.admin.amx.util.ThrowableMapper;
import org.glassfish.admin.amx.util.TypeCast;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.glassfish.admin.amx.util.jmx.NotificationBuilder;
import org.glassfish.external.amx.AMXGlassfish;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.main.jul.cfg.GlassFishLogManagerProperty;
import org.glassfish.main.jul.handler.GlassFishLogHandlerProperty;
import org.glassfish.server.ServerEnvironmentImpl;

public final class LoggingImpl
extends AMXImplBase {
    private static MBeanNotificationInfo[] SELF_NOTIFICATION_INFOS = null;
    private final Map<Level, String> mLevelToNotificationTypeMap = LoggingImpl.initLevelToNotificationTypeMap();
    private final Map<String, NotificationBuilder> mNotificationTypeToNotificationBuilderMap = new HashMap<String, NotificationBuilder>();
    private final LoggingConfigImpl loggingConfig;
    private final ServerLogFileManager logManagerService;
    private final LogFilter logFilter;
    private final MessageIdCatalog msgIdCatalog;
    private final Logger logger;
    private final ServiceLocator mHabitat;
    private static final Object[] LEVELS_AND_NOTIF_TYPES = new Object[]{Level.SEVERE, LogRecordEmitter.LOG_RECORD_SEVERE_NOTIFICATION_TYPE, Level.WARNING, LogRecordEmitter.LOG_RECORD_WARNING_NOTIFICATION_TYPE, Level.INFO, LogRecordEmitter.LOG_RECORD_INFO_NOTIFICATION_TYPE, Level.CONFIG, LogRecordEmitter.LOG_RECORD_CONFIG_NOTIFICATION_TYPE, Level.FINE, LogRecordEmitter.LOG_RECORD_FINE_NOTIFICATION_TYPE, Level.FINER, LogRecordEmitter.LOG_RECORD_FINER_NOTIFICATION_TYPE, Level.FINEST, LogRecordEmitter.LOG_RECORD_FINEST_NOTIFICATION_TYPE};
    private long mMyThreadID = -1L;

    public static ObjectName getObjectName(String serverName) {
        String requiredProps = Util.makeRequiredProps(Util.deduceType(Logging.class), serverName);
        String ServerRootMonitorType = "ServerRootMonitor";
        String parentProp = Util.makeProp("ServerRootMonitor", serverName);
        String props = Util.concatenateProps(requiredProps, parentProp);
        return Util.newObjectName(AMXGlassfish.DEFAULT.amxJMXDomain(), props);
    }

    public LoggingImpl(ObjectName parent, String serverName) {
        super(parent, Logging.class);
        ServerEnvironmentImpl env = InjectedValues.getInstance().getServerEnvironment();
        this.loggingConfig = new LoggingConfigImpl();
        this.loggingConfig.setupConfigDir(env.getConfigDirPath(), env.getLibPath());
        this.msgIdCatalog = new MessageIdCatalog();
        this.mHabitat = InjectedValues.getInstance().getHabitat();
        this.logManagerService = (ServerLogFileManager)this.mHabitat.getService(ServerLogFileManager.class, new Annotation[0]);
        this.logFilter = (LogFilter)this.mHabitat.getService(LogFilter.class, new Annotation[0]);
        this.logger = Logger.getAnonymousLogger();
    }

    private static synchronized MBeanNotificationInfo[] getSelfNotificationInfos() {
        if (SELF_NOTIFICATION_INFOS == null) {
            String[] types = SetUtil.toStringArray(LogRecordEmitter.ALL_LOG_RECORD_NOTIFICATION_TYPES);
            MBeanNotificationInfo selfInfo = new MBeanNotificationInfo(types, Notification.class.getName(), "LogRecord notifications");
            SELF_NOTIFICATION_INFOS = new MBeanNotificationInfo[]{selfInfo};
        }
        return SELF_NOTIFICATION_INFOS;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] superInfos = super.getNotificationInfo();
        return JMXUtil.mergeMBeanNotificationInfos(superInfos, LoggingImpl.getSelfNotificationInfos());
    }

    private void unimplemented() {
        throw new RuntimeException("Not implemented.");
    }

    public void setModuleLogLevel(String module, String level) {
        try {
            this.loggingConfig.setLoggingProperty(module + ".level", level);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Can not set module log level");
        }
    }

    public String getModuleLogLevel(String module) {
        try {
            Map props = this.loggingConfig.getLoggingProperties();
            if (props != null) {
                return (String)props.get(module + ".level");
            }
            return null;
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Can not get module log level");
            return null;
        }
    }

    public Map<String, String> getLoggingProperties() {
        try {
            Map props = this.loggingConfig.getLoggingProperties();
            return props;
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Can not get module log level");
            return null;
        }
    }

    public void updateLoggingProperties(Map<String, String> properties) {
        try {
            this.loggingConfig.updateLoggingProperties(properties);
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Can not get module log level");
        }
    }

    public int getLogLevelListenerCount(Level logLevel) {
        String notifType = this.logLevelToNotificationType(logLevel);
        int count = this.getNotificationEmitter().getNotificationTypeListenerCount(notifType);
        return count;
    }

    public String[] getLogFileKeys() {
        this.unimplemented();
        return new String[]{"server", "access"};
    }

    public synchronized String[] getLogFileNames(String key) {
        if (!"server".equals(key)) {
            throw new IllegalArgumentException(key);
        }
        return null;
    }

    public Map<String, String> getLoggingAttributes() {
        try {
            Map props = this.loggingConfig.getLoggingProperties();
            if (props == null) {
                return null;
            }
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put(GlassFishLogManagerProperty.KEY_ROOT_HANDLERS.getPropertyName(), (String)props.get(GlassFishLogManagerProperty.KEY_ROOT_HANDLERS.getPropertyName()));
            Arrays.stream(GlassFishLogHandlerProperty.values()).map(GlassFishLogHandlerProperty::getPropertyFullName).forEach(k -> attributes.put((String)k, (String)props.get(k)));
            return attributes;
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Can not get logging attributes");
            return null;
        }
    }

    public void updateLoggingAttributes(Map<String, String> properties) {
        try {
            this.loggingConfig.updateLoggingProperties(properties);
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Can not set logging attributes");
        }
    }

    public synchronized void rotateAllLogFiles() {
        this.logManagerService.roll();
    }

    public synchronized void rotateLogFile(String key) {
        if ("access".equals(key)) {
            throw new IllegalArgumentException("not supported: " + key);
        }
        if (!"server".equals(key)) {
            throw new IllegalArgumentException(key);
        }
        this.logManagerService.roll();
    }

    private Properties attributesToProps(List<Attribute> attrs) {
        Properties props = new Properties();
        if (attrs != null) {
            for (Attribute attr : attrs) {
                Object value = attr.getValue();
                if (value == null) {
                    throw new IllegalArgumentException(attr.getName() + "=null");
                }
                props.put(attr.getName(), value.toString());
            }
        }
        return props;
    }

    private List<Serializable[]> convertQueryResult(AttributeList queryResult) {
        AttributeList fieldAttrs = (AttributeList)((Attribute)queryResult.get(0)).getValue();
        String[] fieldHeaders = new String[fieldAttrs.size()];
        for (int i = 0; i < fieldHeaders.length; ++i) {
            Attribute attr = (Attribute)fieldAttrs.get(i);
            fieldHeaders[i] = (String)attr.getValue();
        }
        List srcRecords = TypeCast.asList(((Attribute)queryResult.get(1)).getValue());
        ArrayList<Serializable[]> results = new ArrayList<Serializable[]>(srcRecords.size());
        results.add((Serializable[])fieldHeaders);
        for (int recordIdx = 0; recordIdx < srcRecords.size(); ++recordIdx) {
            List record = (List)srcRecords.get(recordIdx);
            assert (record.size() == fieldHeaders.length);
            Serializable[] fieldValues = new Serializable[fieldHeaders.length];
            for (int fieldIdx = 0; fieldIdx < fieldValues.length; ++fieldIdx) {
                fieldValues[fieldIdx] = (Serializable)record.get(fieldIdx);
            }
            results.add(fieldValues);
        }
        return results;
    }

    public List<Serializable[]> queryServerLog(String name, long startIndex, boolean searchForward, int maximumNumberOfResults, Long fromTime, Long toTime, String logLevel, Set<String> modules, List<Attribute> nameValuePairs, String anySearch) {
        List<Serializable[]> result = this.queryServerLogInternal(name, startIndex, searchForward, maximumNumberOfResults, fromTime, toTime, logLevel, modules, nameValuePairs, anySearch);
        return result;
    }

    private List<Serializable[]> queryServerLogInternal(String name, long startIndex, boolean searchForward, int maximumNumberOfResults, Long fromTime, Long toTime, String logLevel, Set<String> modules, List<Attribute> nameValuePairs, String anySearch) {
        if (name == null) {
            throw new IllegalArgumentException("use MOST_RECENT_NAME, not null");
        }
        boolean sortAscending = true;
        List<String> moduleList = null;
        if (modules != null) {
            moduleList = ListUtil.newListFromCollection(modules);
        }
        Properties props = this.attributesToProps(nameValuePairs);
        String actualName = "MostRecentLogFileName".equals(name) ? null : name;
        if (!searchForward) {
            sortAscending = false;
        }
        AttributeList result = this.logFilter.getLogRecordsUsingQuery(actualName, Long.valueOf(startIndex), Boolean.valueOf(searchForward), Boolean.valueOf(sortAscending), Integer.valueOf(maximumNumberOfResults), fromTime == null ? null : Instant.ofEpochMilli(fromTime), toTime == null ? null : Instant.ofEpochMilli(toTime), logLevel, Boolean.valueOf(false), moduleList, props, anySearch);
        return this.convertQueryResult(result);
    }

    public Map<String, Number>[] getErrorInfo() {
        this.unimplemented();
        ArrayList infos = new ArrayList();
        Map[] results = (Map[])TypeCast.asArray(new HashMap[infos.size()]);
        for (int i = 0; i < results.length; ++i) {
            Map info = (Map)infos.get(i);
            assert (info.keySet().size() == 3);
            Long timestamp = Long.parseLong(info.get("TimeStamp").toString());
            Integer severeCount = Integer.parseInt(info.get("SevereCount").toString());
            Integer warningCount = Integer.parseInt(info.get("WarningCount").toString());
            HashMap<String, Number> item = new HashMap<String, Number>(info.size());
            item.put("TimeStamp", timestamp);
            item.put("SevereCount", severeCount);
            item.put("WarningCount", warningCount);
            results[i] = item;
        }
        return results;
    }

    public void setKeepErrorStatisticsForIntervals(int num) {
        this.unimplemented();
    }

    public int getKeepErrorStatisticsForIntervals() {
        return 0;
    }

    public void setErrorStatisticsIntervalMinutes(long minutes) {
        this.unimplemented();
    }

    public long getErrorStatisticsIntervalMinutes() {
        return 0L;
    }

    public String[] getLoggerNames() {
        return EMPTY_STRING_ARRAY;
    }

    public String[] getLoggerNamesUnder(String loggerName) {
        this.unimplemented();
        return null;
    }

    public String[] getDiagnosticCauses(String messageID, String moduleName) {
        ArrayList causes = this.msgIdCatalog.getDiagnosticCausesForMessageId(messageID, moduleName);
        String[] result = null;
        if (causes != null) {
            result = CollectionUtil.toArray(causes, String.class);
        }
        return result;
    }

    public String[] getDiagnosticChecks(String messageID, String moduleName) {
        ArrayList checks = this.msgIdCatalog.getDiagnosticChecksForMessageId(messageID, moduleName);
        String[] result = null;
        if (checks != null) {
            result = CollectionUtil.toArray(checks, String.class);
        }
        return result;
    }

    public String getDiagnosticURI(String messageID) {
        this.unimplemented();
        return null;
    }

    private static Map<Level, String> initLevelToNotificationTypeMap() {
        HashMap<Level, String> m = new HashMap<Level, String>();
        for (int i = 0; i < LEVELS_AND_NOTIF_TYPES.length; i += 2) {
            Level level = (Level)LEVELS_AND_NOTIF_TYPES[i];
            String notifType = (String)LEVELS_AND_NOTIF_TYPES[i + 1];
            m.put(level, notifType);
        }
        return Collections.unmodifiableMap(m);
    }

    private String logLevelToNotificationType(Level level) {
        return this.mLevelToNotificationTypeMap.get(level);
    }

    @Override
    protected void preRegisterDone() throws Exception {
        this.initNotificationTypeToNotificationBuilderMap(this.getObjectName());
    }

    private void initNotificationTypeToNotificationBuilderMap(ObjectName objectName) {
        this.mNotificationTypeToNotificationBuilderMap.clear();
        for (String notifType : LogRecordEmitter.ALL_LOG_RECORD_NOTIFICATION_TYPES) {
            this.mNotificationTypeToNotificationBuilderMap.put(notifType, new NotificationBuilder(notifType, objectName));
        }
    }

    private NotificationBuilder notificationTypeToNotificationBuilder(String notificationType) {
        NotificationBuilder builder = this.mNotificationTypeToNotificationBuilderMap.get(notificationType);
        assert (builder != null);
        return builder;
    }

    private Map<String, Serializable> logRecordToMap(LogRecord record, String recordAsString) {
        HashMap<String, Serializable> m = new HashMap<String, Serializable>();
        m.put("LogRecord.toString", (Serializable)((Object)recordAsString));
        m.put("LogRecord.Level", record.getLevel());
        m.put("LogRecord.LoggerName", (Serializable)((Object)record.getLoggerName()));
        m.put("LogRecord.Message", (Serializable)((Object)record.getMessage()));
        m.put("LogRecord.Millis", Long.valueOf(record.getMillis()));
        m.put("LogRecord.SequenceNumber", Long.valueOf(record.getSequenceNumber()));
        m.put("LogRecord.SourceClassName", (Serializable)((Object)record.getSourceClassName()));
        m.put("LogRecord.SourceMethodName", (Serializable)((Object)record.getSourceMethodName()));
        m.put("LogRecord.ThreadID", Integer.valueOf(record.getThreadID()));
        Throwable thrown = record.getThrown();
        if (thrown != null) {
            Throwable mapped = new ThrowableMapper(thrown).map();
            m.put("LogRecord.Thrown", mapped);
            Throwable rootCause = ExceptionUtil.getRootCause(thrown);
            if (rootCause != thrown) {
                Throwable mappedRootCause = new ThrowableMapper(rootCause).map();
                m.put("LogRecord.ThrownRootCause", mappedRootCause);
            }
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void privateLoggingHook(LogRecord logRecord, Formatter formatter) {
        if ((long)logRecord.getThreadID() == this.mMyThreadID) {
            this.debug((Object)"privateLoggingHook: recusive call!!!");
            throw new RuntimeException("recursive call");
        }
        LoggingImpl loggingImpl = this;
        synchronized (loggingImpl) {
            this.mMyThreadID = Thread.currentThread().getId();
            Level level = logRecord.getLevel();
            try {
                if (this.getLogLevelListenerCount(level) != 0) {
                    String notifType = this.logLevelToNotificationType(level);
                    NotificationBuilder builder = this.notificationTypeToNotificationBuilder(notifType);
                    String logRecordAsString = formatter.format(logRecord);
                    Map<String, Serializable> userData = this.logRecordToMap(logRecord, logRecordAsString);
                    Notification notif = builder.buildNewWithMap(logRecordAsString, userData);
                    this.debug((Object)("privateLoggingHook: sending: " + String.valueOf(notif)));
                    this.sendNotification(notif);
                }
            }
            finally {
                this.mMyThreadID = -1L;
            }
        }
    }

    public void testEmitLogMessage(String level, String message) {
        this.setMBeanLogLevel(level);
        this.debug((Object)("testEmitLogMessage: logging: message = " + message));
        this.getLogger().log(Level.parse(level), message);
    }
}

