/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.inject.build.compatible.spi.Types;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.types.ArrayType;
import jakarta.enterprise.lang.model.types.ClassType;
import jakarta.enterprise.lang.model.types.ParameterizedType;
import jakarta.enterprise.lang.model.types.PrimitiveType;
import jakarta.enterprise.lang.model.types.VoidType;
import jakarta.enterprise.lang.model.types.WildcardType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import org.jboss.weld.lite.extension.translator.ArrayTypeImpl;
import org.jboss.weld.lite.extension.translator.ClassInfoImpl;
import org.jboss.weld.lite.extension.translator.ClassTypeImpl;
import org.jboss.weld.lite.extension.translator.ParameterizedTypeImpl;
import org.jboss.weld.lite.extension.translator.PrimitiveTypeImpl;
import org.jboss.weld.lite.extension.translator.TypeImpl;
import org.jboss.weld.lite.extension.translator.VoidTypeImpl;
import org.jboss.weld.lite.extension.translator.WildcardTypeImpl;
import org.jboss.weld.lite.extension.translator.logging.LiteExtensionTranslatorLogger;
import org.jboss.weld.lite.extension.translator.util.reflection.AnnotatedTypes;

class TypesImpl
implements Types {
    private final BeanManager bm;

    public TypesImpl(BeanManager bm) {
        this.bm = bm;
    }

    @Override
    public jakarta.enterprise.lang.model.types.Type of(Class<?> clazz) {
        if (clazz.isArray()) {
            int dimensions = 1;
            Class<?> componentType = clazz.getComponentType();
            while (componentType.isArray()) {
                ++dimensions;
                componentType = componentType.getComponentType();
            }
            return this.ofArray(this.of(componentType), dimensions);
        }
        if (clazz.isPrimitive()) {
            if (clazz == Void.TYPE) {
                return this.ofVoid();
            }
            if (clazz == Boolean.TYPE) {
                return this.ofPrimitive(PrimitiveType.PrimitiveKind.BOOLEAN);
            }
            if (clazz == Byte.TYPE) {
                return this.ofPrimitive(PrimitiveType.PrimitiveKind.BYTE);
            }
            if (clazz == Short.TYPE) {
                return this.ofPrimitive(PrimitiveType.PrimitiveKind.SHORT);
            }
            if (clazz == Integer.TYPE) {
                return this.ofPrimitive(PrimitiveType.PrimitiveKind.INT);
            }
            if (clazz == Long.TYPE) {
                return this.ofPrimitive(PrimitiveType.PrimitiveKind.LONG);
            }
            if (clazz == Float.TYPE) {
                return this.ofPrimitive(PrimitiveType.PrimitiveKind.FLOAT);
            }
            if (clazz == Double.TYPE) {
                return this.ofPrimitive(PrimitiveType.PrimitiveKind.DOUBLE);
            }
            if (clazz == Character.TYPE) {
                return this.ofPrimitive(PrimitiveType.PrimitiveKind.CHAR);
            }
            throw LiteExtensionTranslatorLogger.LOG.unknownPrimitiveType(clazz);
        }
        return new ClassTypeImpl(clazz, this.bm);
    }

    @Override
    public VoidType ofVoid() {
        return new VoidTypeImpl(this.bm);
    }

    @Override
    public PrimitiveType ofPrimitive(PrimitiveType.PrimitiveKind kind) {
        switch (kind) {
            case BOOLEAN: {
                return new PrimitiveTypeImpl(Boolean.TYPE, this.bm);
            }
            case BYTE: {
                return new PrimitiveTypeImpl(Byte.TYPE, this.bm);
            }
            case SHORT: {
                return new PrimitiveTypeImpl(Short.TYPE, this.bm);
            }
            case INT: {
                return new PrimitiveTypeImpl(Integer.TYPE, this.bm);
            }
            case LONG: {
                return new PrimitiveTypeImpl(Long.TYPE, this.bm);
            }
            case FLOAT: {
                return new PrimitiveTypeImpl(Float.TYPE, this.bm);
            }
            case DOUBLE: {
                return new PrimitiveTypeImpl(Double.TYPE, this.bm);
            }
            case CHAR: {
                return new PrimitiveTypeImpl(Character.TYPE, this.bm);
            }
        }
        throw LiteExtensionTranslatorLogger.LOG.unknownPrimitiveType((Object)kind);
    }

    @Override
    public ClassType ofClass(String name) {
        try {
            Class<?> clazz = Class.forName(name, true, Thread.currentThread().getContextClassLoader());
            return new ClassTypeImpl(clazz, this.bm);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public ClassType ofClass(ClassInfo clazz) {
        return (ClassType)this.of(((jakarta.enterprise.inject.spi.AnnotatedType)((ClassInfoImpl)clazz).cdiDeclaration).getJavaClass());
    }

    @Override
    public ArrayType ofArray(jakarta.enterprise.lang.model.types.Type elementType, int dimensions) {
        return new ArrayTypeImpl(AnnotatedTypes.array(((AnnotatedType)((TypeImpl)elementType).reflection).getType(), dimensions), this.bm);
    }

    @Override
    public ParameterizedType parameterized(Class<?> genericType, Class<?> ... typeArguments) {
        return new ParameterizedTypeImpl(AnnotatedTypes.parameterized(genericType, typeArguments), this.bm);
    }

    @Override
    public ParameterizedType parameterized(Class<?> genericType, jakarta.enterprise.lang.model.types.Type ... typeArguments) {
        Type[] underlyingTypeArguments = new Type[typeArguments.length];
        for (int i = 0; i < typeArguments.length; ++i) {
            underlyingTypeArguments[i] = ((AnnotatedType)((TypeImpl)typeArguments[i]).reflection).getType();
        }
        return new ParameterizedTypeImpl(AnnotatedTypes.parameterized(genericType, underlyingTypeArguments), this.bm);
    }

    @Override
    public ParameterizedType parameterized(ClassType genericType, jakarta.enterprise.lang.model.types.Type ... typeArguments) {
        Class clazz = (Class)((AnnotatedType)((TypeImpl)((Object)genericType)).reflection).getType();
        Type[] underlyingTypeArguments = new Type[typeArguments.length];
        for (int i = 0; i < typeArguments.length; ++i) {
            underlyingTypeArguments[i] = ((AnnotatedType)((TypeImpl)typeArguments[i]).reflection).getType();
        }
        return new ParameterizedTypeImpl(AnnotatedTypes.parameterized(clazz, underlyingTypeArguments), this.bm);
    }

    @Override
    public WildcardType wildcardWithUpperBound(jakarta.enterprise.lang.model.types.Type upperBound) {
        return new WildcardTypeImpl(AnnotatedTypes.wildcardWithUpperBound(((AnnotatedType)((TypeImpl)upperBound).reflection).getType()), this.bm);
    }

    @Override
    public WildcardType wildcardWithLowerBound(jakarta.enterprise.lang.model.types.Type lowerBound) {
        return new WildcardTypeImpl(AnnotatedTypes.wildcardWithLowerBound(((AnnotatedType)((TypeImpl)lowerBound).reflection).getType()), this.bm);
    }

    @Override
    public WildcardType wildcardUnbounded() {
        return new WildcardTypeImpl(AnnotatedTypes.unboundedWildcardType(), this.bm);
    }
}

