/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.spi.folb;

import com.sun.corba.ee.spi.folb.SocketInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class ClusterInstanceInfo
implements Serializable {
    private final String name;
    private final int weight;
    private final List<SocketInfo> endpoints;

    public ClusterInstanceInfo(InputStream is) {
        this.name = is.read_string();
        this.weight = is.read_long();
        int size = is.read_long();
        ArrayList<SocketInfo> elist = new ArrayList<SocketInfo>(size);
        for (int ctr = 0; ctr < size; ++ctr) {
            elist.add(new SocketInfo(is));
        }
        this.endpoints = Collections.unmodifiableList(elist);
    }

    public ClusterInstanceInfo(String name, int weight, List<SocketInfo> endpoints) {
        this.name = name;
        this.weight = weight;
        this.endpoints = Collections.unmodifiableList(endpoints);
    }

    public List<SocketInfo> endpoints() {
        return this.endpoints;
    }

    public String name() {
        return this.name;
    }

    public int weight() {
        return this.weight;
    }

    public void write(OutputStream os) {
        os.write_string(this.name);
        os.write_long(this.weight);
        os.write_long(this.endpoints.size());
        for (SocketInfo si : this.endpoints) {
            si.write(os);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ClusterInstanceInfo[");
        sb.append("name=");
        sb.append(this.name);
        sb.append(" weight=");
        sb.append(this.weight);
        sb.append(" endpoints=");
        sb.append(this.endpoints.toString());
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClusterInstanceInfo other = (ClusterInstanceInfo)obj;
        if (this.name == null ? other.name() != null : !this.name.equals(other.name())) {
            return false;
        }
        if (this.weight != other.weight()) {
            return false;
        }
        return this.endpoints == other.endpoints() || this.endpoints != null && this.endpoints.equals(other.endpoints());
    }

    public int hashCode() {
        int hash = 3;
        hash = 79 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 79 * hash + this.weight;
        hash = 79 * hash + (this.endpoints != null ? this.endpoints.hashCode() : 0);
        return hash;
    }
}

