/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.util.Collections;
import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.JPQLQueryDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.Join;
import org.eclipse.persistence.mappings.DatabaseMapping;

abstract class Declaration
implements JPQLQueryDeclaration {
    Expression baseExpression;
    Expression declarationExpression;
    private ClassDescriptor descriptor;
    IdentificationVariable identificationVariable;
    private DatabaseMapping mapping;
    final JPQLQueryContext queryContext;
    private org.eclipse.persistence.expressions.Expression queryExpression;
    String rootPath;

    Declaration(JPQLQueryContext queryContext) {
        this.queryContext = queryContext;
    }

    abstract org.eclipse.persistence.expressions.Expression buildQueryExpression();

    public Expression getBaseExpression() {
        return this.baseExpression;
    }

    public Expression getDeclarationExpression() {
        return this.declarationExpression;
    }

    final ClassDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = this.resolveDescriptor();
        }
        return this.descriptor;
    }

    public List<Join> getJoins() {
        return Collections.emptyList();
    }

    final DatabaseMapping getMapping() {
        if (this.mapping == null) {
            this.mapping = this.resolveMapping();
        }
        return this.mapping;
    }

    final org.eclipse.persistence.expressions.Expression getQueryExpression() {
        if (this.queryExpression == null) {
            this.queryExpression = this.buildQueryExpression();
            this.queryContext.addQueryExpressionImp(this.getVariableName(), this.queryExpression);
        }
        return this.queryExpression;
    }

    public final String getVariableName() {
        if (this.identificationVariable == null) {
            return "";
        }
        return this.identificationVariable.getVariableName();
    }

    public boolean hasJoins() {
        return false;
    }

    abstract ClassDescriptor resolveDescriptor();

    abstract DatabaseMapping resolveMapping();

    public String toString() {
        if (this.declarationExpression != null) {
            return this.declarationExpression.toParsedText();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.rootPath);
        if (this.identificationVariable != null) {
            sb.append(' ');
            sb.append(this.identificationVariable.getText());
        }
        return sb.toString();
    }
}

