/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.dynamic.copyobject.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.TimeZone;
import org.glassfish.pfl.basic.concurrent.WeakHashMapSafeReadLock;
import org.glassfish.pfl.dynamic.copyobject.impl.CachingClassCopierFactory;
import org.glassfish.pfl.dynamic.copyobject.impl.ClassCopier;
import org.glassfish.pfl.dynamic.copyobject.impl.ClassCopierFactory;
import org.glassfish.pfl.dynamic.copyobject.impl.ClassCopierFactoryArrayImpl;
import org.glassfish.pfl.dynamic.copyobject.impl.ClassCopierFactoryPipelineImpl;
import org.glassfish.pfl.dynamic.copyobject.impl.ClassCopierOrdinaryImpl;
import org.glassfish.pfl.dynamic.copyobject.impl.DefaultClassCopiers;
import org.glassfish.pfl.dynamic.copyobject.impl.PipelineClassCopierFactory;
import org.glassfish.pfl.dynamic.copyobject.spi.ReflectiveCopyException;

public abstract class DefaultClassCopierFactories {
    public static final boolean USE_FAST_CACHE = false;
    private static final Class<?>[] SAFE_TO_COPY = new Class[]{TimeZone.class, Throwable.class, Proxy.class};

    private DefaultClassCopierFactories() {
    }

    public static ClassCopierFactory makeArrayClassCopierFactory(ClassCopierFactory ccf) {
        return new ClassCopierFactoryArrayImpl(ccf);
    }

    public static ClassCopierFactory makeOrdinaryClassCopierFactory(final PipelineClassCopierFactory ccf) {
        return new ClassCopierFactory(){

            @Override
            public ClassCopier getClassCopier(Class<?> cls) throws ReflectiveCopyException {
                if (this.notCopyable(cls)) {
                    return DefaultClassCopiers.getErrorClassCopier();
                }
                return new ClassCopierOrdinaryImpl(ccf, cls);
            }

            private boolean safe(Class cls) {
                for (Class<?> klass : SAFE_TO_COPY) {
                    if (cls != klass) continue;
                    return true;
                }
                return false;
            }

            private boolean notCopyable(Class<?> cls) {
                for (Class<?> current = cls; current != Object.class; current = current.getSuperclass()) {
                    Method[] methods;
                    if (this.safe(current)) {
                        return false;
                    }
                    if (System.getSecurityManager() == null) {
                        methods = current.getDeclaredMethods();
                    } else {
                        final Class<?> _current = current;
                        methods = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                return _current.getDeclaredMethods();
                            }
                        });
                    }
                    for (Method m : methods) {
                        if (!m.getName().equals("finalize") && !Modifier.isNative(m.getModifiers())) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public static CachingClassCopierFactory makeCachingClassCopierFactory() {
        return new CachingClassCopierFactory(){
            private Map<Class<?>, ClassCopier> cache = new WeakHashMapSafeReadLock();

            @Override
            public void put(Class<?> cls, ClassCopier copier) {
                this.cache.put(cls, copier);
            }

            @Override
            public ClassCopier getClassCopier(Class<?> cls) {
                return this.cache.get(cls);
            }
        };
    }

    public static ClassCopierFactory getNullClassCopierFactory() {
        return new ClassCopierFactory(){

            public ClassCopier getClassCopier(Class cls) {
                return null;
            }
        };
    }

    public static PipelineClassCopierFactory getPipelineClassCopierFactory() {
        return new ClassCopierFactoryPipelineImpl();
    }
}

