/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.grizzly;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.naming.NamingContext;
import org.glassfish.grizzly.http.server.util.Mapper;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Service;

@Service
@ContractsProvided(value={ContextMapper.class, Mapper.class})
public class ContextMapper
extends Mapper {
    protected final Logger logger;
    protected HttpHandler adapter;
    private String id;

    public ContextMapper() {
        this(Logger.getAnonymousLogger());
    }

    public ContextMapper(Logger logger) {
        this.logger = logger;
    }

    public void addWrapper(String hostName, String contextPath, String path, Object wrapper, boolean jspWildCard, String servletName, boolean isEmptyPathSpecial) {
        super.addWrapper(hostName, contextPath, path, wrapper, jspWildCard, servletName, isEmptyPathSpecial);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Wrapper-Host: {0} contextPath {1} wrapper {2} path {3} jspWildcard {4} servletName {5} isEmptyPathSpecial {6}", new Object[]{hostName, contextPath, wrapper, path, jspWildCard, servletName, isEmptyPathSpecial});
        }
    }

    public synchronized void addHost(String name, String[] aliases, Object host) {
        super.addHost(name, aliases, host);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Host-Host: {0} aliases {1} host {2}", new Object[]{name, Arrays.toString(aliases), host});
        }
    }

    public void addContext(String hostName, String path, Object context, String[] welcomeResources, NamingContext resources) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Context-Host: {0} path {1} context {2} port {3}", new Object[]{hostName, path, context, this.getPort()});
        }
        if (this.adapter != null && "org.apache.catalina.connector.CoyoteAdapter".equals(this.adapter.getClass().getName())) {
            this.removeContext(hostName, path);
        }
        super.addContext(hostName, path, context, welcomeResources, resources);
    }

    public synchronized void removeHost(String name) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Faking removal of host: {0}", name);
        }
    }

    public void setHttpHandler(HttpHandler adapter) {
        this.adapter = adapter;
    }

    public HttpHandler getHttpHandler() {
        return this.adapter;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }
}

