/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.cdi.BatchXMLMapper;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.spi.services.IBatchArtifactFactory;
import com.ibm.jbatch.spi.services.IBatchConfig;
import jakarta.enterprise.inject.AmbiguousResolutionException;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class CDIBatchArtifactFactoryImpl
implements IBatchArtifactFactory {
    private static final Logger logger = Logger.getLogger(CDIBatchArtifactFactoryImpl.class.getName());
    private static final String CLASSNAME = CDIBatchArtifactFactoryImpl.class.getName();

    @Override
    public Object load(String batchId) {
        Object loadedArtifact;
        String methodName = "load";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASSNAME, methodName, "Loading batch artifact id = " + batchId);
        }
        if ((loadedArtifact = this.getArtifactById(batchId)) != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(CLASSNAME, methodName, "For batch artifact id = " + batchId + ", loaded artifact instance: " + loadedArtifact + " of type: " + loadedArtifact.getClass().getCanonicalName());
            }
        } else if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASSNAME, methodName, "For batch artifact id = " + batchId + ", FAILED to load artifact instance");
        }
        return loadedArtifact;
    }

    protected BeanManager obtainBeanManager() throws NamingException {
        InitialContext initialContext = new InitialContext();
        return (BeanManager)initialContext.lookup("java:comp/BeanManager");
    }

    private Object getArtifactById(String id) {
        Object artifactInstance = null;
        try {
            BeanManager bm = this.obtainBeanManager();
            Bean<?> bean = bm != null ? this.getBeanById(bm, id) : null;
            Class clazz = bean.getBeanClass();
            artifactInstance = bm.getReference(bean, (Type)clazz, bm.createCreationalContext(bean));
        }
        catch (Exception e) {
            logger.fine("Tried but failed to load artifact with id: " + id + ", Exception = " + e);
        }
        return artifactInstance;
    }

    protected Bean<?> getBeanById(BeanManager bm, String id) {
        Bean<?> match = this.getUniqueBeanByBeanName(bm, id);
        if (match == null) {
            match = this.getUniqueBeanForBatchXMLEntry(bm, id);
        }
        if (match == null) {
            match = this.getUniqueBeanForClassName(bm, id);
        }
        return match;
    }

    protected Bean<?> getUniqueBeanByBeanName(BeanManager bm, String batchId) {
        Bean match = null;
        Set beans = bm.getBeans(batchId);
        try {
            match = bm.resolve(beans);
        }
        catch (AmbiguousResolutionException e) {
            return null;
        }
        return match;
    }

    protected Bean<?> getUniqueBeanForBatchXMLEntry(BeanManager bm, String batchId) {
        ClassLoader loader = this.getContextClassLoader();
        BatchXMLMapper batchXMLMapper = new BatchXMLMapper(loader);
        Class<?> clazz = batchXMLMapper.getArtifactById(batchId);
        if (clazz != null) {
            try {
                return this.findUniqueBeanForClass(bm, clazz);
            }
            catch (AmbiguousResolutionException e) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("getBeanForBatchXML: BatchCDIAmbiguousResolutionCheckedException: " + e.getMessage());
                }
                return null;
            }
        }
        return null;
    }

    protected Bean<?> getUniqueBeanForClassName(BeanManager bm, String className) {
        try {
            Class<?> clazz = this.getContextClassLoader().loadClass(className);
            return this.findUniqueBeanForClass(bm, clazz);
        }
        catch (AmbiguousResolutionException e) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("getBeanForClassName: BatchCDIAmbiguousResolutionCheckedException: " + e.getMessage());
            }
            return null;
        }
        catch (ClassNotFoundException cnfe) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("getBeanForClassName: ClassNotFoundException for " + className + ": " + cnfe);
            }
            return null;
        }
    }

    protected Bean<?> findUniqueBeanForClass(BeanManager beanManager, Class<?> clazz) throws AmbiguousResolutionException {
        HashSet<Bean> matches = new HashSet<Bean>();
        Bean retVal = null;
        Set beans = beanManager.getBeans(clazz, new Annotation[0]);
        if (beans == null || beans.isEmpty()) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("In findBeanForClass: found empty set or null for class: " + clazz);
            }
            return null;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("In findBeanForClass: found non-empty set: " + beans + " for class: " + clazz);
        }
        for (Bean bean : beans) {
            if (!bean.getBeanClass().equals(clazz)) continue;
            matches.add(bean);
        }
        try {
            retVal = beanManager.resolve(matches);
        }
        catch (AmbiguousResolutionException e) {
            throw new AmbiguousResolutionException("Found beans = " + matches + ", and could not resolve unambiguously");
        }
        return retVal;
    }

    protected ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        logger.fine("Initializing CDIBatchArtifactFactoryImpl");
    }

    @Override
    public void shutdown() throws BatchContainerServiceException {
        logger.fine("Shutdown CDIBatchArtifactFactoryImpl");
    }
}

