/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.ior;

import com.sun.corba.ee.impl.encoding.EncapsInputStream;
import com.sun.corba.ee.impl.encoding.EncapsInputStreamFactory;
import com.sun.corba.ee.impl.ior.Handler;
import com.sun.corba.ee.impl.ior.JIDLObjectKeyTemplate;
import com.sun.corba.ee.impl.ior.ObjectIdImpl;
import com.sun.corba.ee.impl.ior.ObjectKeyImpl;
import com.sun.corba.ee.impl.ior.ObjectKeyTemplateBase;
import com.sun.corba.ee.impl.ior.OldJIDLObjectKeyTemplate;
import com.sun.corba.ee.impl.ior.OldPOAObjectKeyTemplate;
import com.sun.corba.ee.impl.ior.POAObjectKeyTemplate;
import com.sun.corba.ee.spi.ior.ObjectKey;
import com.sun.corba.ee.spi.ior.ObjectKeyFactory;
import com.sun.corba.ee.spi.ior.ObjectKeyTemplate;
import com.sun.corba.ee.spi.logging.IORSystemException;
import java.io.IOException;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.OctetSeqHolder;
import org.omg.CORBA_2_3.portable.InputStream;

public class ObjectKeyFactoryImpl
implements ObjectKeyFactory {
    private static final IORSystemException wrapper = IORSystemException.self;
    public static final int MAGIC_BASE = -1347695874;
    public static final int JAVAMAGIC_OLD = -1347695874;
    public static final int JAVAMAGIC_NEW = -1347695873;
    public static final int JAVAMAGIC_NEWER = -1347695872;
    public static final int MAX_MAGIC = -1347695872;
    public static final byte JDK1_3_1_01_PATCH_LEVEL = 1;
    private final com.sun.corba.ee.spi.orb.ORB orb;
    private Handler fullKey = new Handler(){

        @Override
        public ObjectKeyTemplate handle(int magic, int scid, InputStream is, OctetSeqHolder osh) {
            ObjectKeyTemplateBase oktemp = null;
            if (scid >= 32 && scid <= 63) {
                oktemp = magic >= -1347695872 ? new POAObjectKeyTemplate(ObjectKeyFactoryImpl.this.orb, magic, scid, is, osh) : new OldPOAObjectKeyTemplate(ObjectKeyFactoryImpl.this.orb, magic, scid, is, osh);
            } else if (scid >= 0 && scid < 32) {
                oktemp = magic >= -1347695872 ? new JIDLObjectKeyTemplate(ObjectKeyFactoryImpl.this.orb, magic, scid, is, osh) : new OldJIDLObjectKeyTemplate(ObjectKeyFactoryImpl.this.orb, magic, scid, is, osh);
            }
            return oktemp;
        }
    };
    private Handler oktempOnly = new Handler(){

        @Override
        public ObjectKeyTemplate handle(int magic, int scid, InputStream is, OctetSeqHolder osh) {
            ObjectKeyTemplateBase oktemp = null;
            if (scid >= 32 && scid <= 63) {
                oktemp = magic >= -1347695872 ? new POAObjectKeyTemplate(ObjectKeyFactoryImpl.this.orb, magic, scid, is) : new OldPOAObjectKeyTemplate(ObjectKeyFactoryImpl.this.orb, magic, scid, is);
            } else if (scid >= 0 && scid < 32) {
                oktemp = magic >= -1347695872 ? new JIDLObjectKeyTemplate(ObjectKeyFactoryImpl.this.orb, magic, scid, is) : new OldJIDLObjectKeyTemplate(ObjectKeyFactoryImpl.this.orb, magic, scid, is);
            }
            return oktemp;
        }
    };

    public ObjectKeyFactoryImpl(com.sun.corba.ee.spi.orb.ORB orb) {
        this.orb = orb;
    }

    private boolean validMagic(int magic) {
        return magic >= -1347695874 && magic <= -1347695872;
    }

    private ObjectKeyTemplate create(InputStream is, Handler handler, OctetSeqHolder osh) {
        ObjectKeyTemplate oktemp = null;
        try {
            int magic = is.read_long();
            if (this.validMagic(magic)) {
                int scid = is.read_long();
                oktemp = handler.handle(magic, scid, is, osh);
            }
        }
        catch (MARSHAL mexc) {
            wrapper.createMarshalError(mexc);
        }
        return oktemp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectKey create(byte[] key) {
        ObjectKeyTemplate oktemp;
        OctetSeqHolder osh = new OctetSeqHolder();
        EncapsInputStream is = EncapsInputStreamFactory.newEncapsInputStream((ORB)this.orb, key, key.length);
        try {
            oktemp = this.create(is, this.fullKey, osh);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                wrapper.ioexceptionDuringStreamClose(e);
            }
        }
        if (oktemp == null) {
            oktemp = this.orb.getWireObjectKeyTemplate();
            osh.value = key;
        }
        ObjectIdImpl oid = new ObjectIdImpl(osh.value);
        return new ObjectKeyImpl(oktemp, oid);
    }

    @Override
    public ObjectKeyTemplate createTemplate(InputStream is) {
        ObjectKeyTemplate oktemp = this.create(is, this.oktempOnly, null);
        if (oktemp == null) {
            oktemp = this.orb.getWireObjectKeyTemplate();
        }
        return oktemp;
    }
}

