/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.validation;

import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import org.jboss.logging.processor.validation.ValidationMessage;

public final class ValidationMessageFactory {
    private ValidationMessageFactory() {
    }

    public static ValidationMessage createError(Element element, String message) {
        return new ValidationErrorMessage(element, message, null, null);
    }

    public static ValidationMessage createError(Element element, String format, Object ... args) {
        return new ValidationErrorMessage(element, String.format(format, args), null, null);
    }

    public static ValidationMessage createError(Element element, AnnotationMirror annotationMirror, String message) {
        return new ValidationErrorMessage(element, message, annotationMirror, null);
    }

    public static ValidationMessage createError(Element element, AnnotationMirror annotationMirror, String format, Object ... args) {
        return new ValidationErrorMessage(element, String.format(format, args), annotationMirror, null);
    }

    public static ValidationMessage createError(Element element, AnnotationMirror annotationMirror, AnnotationValue annotationValue, String message) {
        return new ValidationErrorMessage(element, message, annotationMirror, annotationValue);
    }

    public static ValidationMessage createError(Element element, AnnotationMirror annotationMirror, AnnotationValue annotationValue, String format, Object ... args) {
        return new ValidationErrorMessage(element, String.format(format, args), annotationMirror, annotationValue);
    }

    public static ValidationMessage createWarning(Element element, String message) {
        return new ValidationWarningMessage(element, message, null, null);
    }

    public static ValidationMessage createWarning(Element element, String format, Object ... args) {
        return new ValidationWarningMessage(element, String.format(format, args), null, null);
    }

    private static class ValidationWarningMessage
    extends AbstractValidationMessage {
        private ValidationWarningMessage(Element element, String message, AnnotationMirror annotationMirror, AnnotationValue annotationValue) {
            super(element, message, annotationMirror, annotationValue);
        }

        @Override
        public ValidationMessage.Type type() {
            return ValidationMessage.Type.WARN;
        }
    }

    private static class ValidationErrorMessage
    extends AbstractValidationMessage {
        private ValidationErrorMessage(Element element, String message, AnnotationMirror annotationMirror, AnnotationValue annotationValue) {
            super(element, message, annotationMirror, annotationValue);
        }

        @Override
        public ValidationMessage.Type type() {
            return ValidationMessage.Type.ERROR;
        }
    }

    private static abstract class AbstractValidationMessage
    implements ValidationMessage {
        private final Element element;
        private final String message;
        private final AnnotationMirror annotationMirror;
        private final AnnotationValue annotationValue;

        AbstractValidationMessage(Element element, String message, AnnotationMirror annotationMirror, AnnotationValue annotationValue) {
            this.element = element;
            this.message = message;
            this.annotationMirror = annotationMirror;
            this.annotationValue = annotationValue;
        }

        @Override
        public final Element getElement() {
            return this.element;
        }

        @Override
        public final String getMessage() {
            return this.message;
        }

        @Override
        public AnnotationMirror getAnnotationMirror() {
            return this.annotationMirror;
        }

        @Override
        public AnnotationValue getAnnotationValue() {
            return this.annotationValue;
        }
    }
}

