/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.generatortasks.restadapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.comma.behavior.behavior.Port;
import org.eclipse.comma.behavior.behavior.RequiredPort;
import org.eclipse.comma.behavior.component.component.Component;
import org.eclipse.comma.project.ProjectUtility;
import org.eclipse.comma.project.generatortasks.restadapter.Event;
import org.eclipse.comma.project.generatortasks.restadapter.EventMatch;
import org.eclipse.comma.project.generatortasks.restadapter.SUTToCommaTrace;
import org.eclipse.comma.project.generatortasks.restadapter.VectorDescriptor;
import org.eclipse.comma.project.project.EventMapping;
import org.eclipse.comma.project.project.FixedSegment;
import org.eclipse.comma.project.project.ParameterSegment;
import org.eclipse.comma.project.project.Path;
import org.eclipse.comma.project.project.PathMappings;
import org.eclipse.comma.project.project.SignatureMapping;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.Notification;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.signature.interfaceSignature.Signal;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.types.comments.SLCommentLocator;
import org.eclipse.comma.types.types.EnumElement;
import org.eclipse.comma.types.types.EnumTypeDecl;
import org.eclipse.comma.types.types.RecordField;
import org.eclipse.comma.types.types.RecordTypeDecl;
import org.eclipse.comma.types.types.SimpleTypeDecl;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.types.TypeDecl;
import org.eclipse.comma.types.types.TypeReference;
import org.eclipse.comma.types.types.VectorTypeConstructor;
import org.eclipse.comma.types.types.VectorTypeDecl;
import org.eclipse.comma.types.utilities.TypeUtilities;
import org.eclipse.emf.ecore.EObject;

public class RESTTraceConverter {
    public static CharSequence convertTrace(InputStream is, Component component, PathMappings mappings) throws Exception {
        StringBuilder result = new StringBuilder();
        HashMap<String, EventMatch> notifications = new HashMap<String, EventMatch>();
        HashMap<String, Object> calls = new HashMap<String, Object>();
        String componentDeclaration = String.format("{\"components\" : [{\"type\":\"%s\",\"value\":\"c\"}]}", component.getName());
        result.append(componentDeclaration);
        result.append(System.lineSeparator());
        try {
            Throwable throwable = null;
            Object var8_11 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                String line;
                while ((line = br.readLine()) != null) {
                    Event event;
                    String port;
                    Signature sig;
                    JsonObject paramInJson;
                    String connectionKey;
                    EventMatch match;
                    String uri;
                    String[] subFragments;
                    if (line.contains("Timestamps,HTTP/1.1 101")) continue;
                    String[] fragments = line.split("\t+", 6);
                    if (fragments[5].startsWith("GET") || fragments[5].startsWith("DELETE")) {
                        subFragments = fragments[5].split("\t+", 3);
                        uri = subFragments[1];
                        match = RESTTraceConverter.findEvent(uri, mappings);
                        if (match == null) continue;
                        if (match.event instanceof Notification) {
                            notifications.put(RESTTraceConverter.makeConnectionKey(fragments[1], fragments[2]), match);
                            continue;
                        }
                        connectionKey = RESTTraceConverter.makeConnectionKey(fragments[1], fragments[2]);
                        if (calls.containsKey(connectionKey)) continue;
                        Command command = (Command)match.event;
                        Signature sig2 = (Signature)match.event.eContainer();
                        String port2 = RESTTraceConverter.getPort(component, sig2);
                        boolean isRequiredPort = RESTTraceConverter.isRequiredPort(component, sig2);
                        Event event2 = !isRequiredPort ? new Event("Command", RESTTraceConverter.convertTimestamp(fragments[0]), sig2.getName(), match.event.getName(), "client", "clientPort", "c", port2) : new Event("Command", RESTTraceConverter.convertTimestamp(fragments[0]), sig2.getName(), match.event.getName(), "c", port2, "client", "clientPort");
                        for (Parameter p2 : command.getParameters()) {
                            if (p2.getDirection() != DIRECTION.IN) continue;
                            paramInJson = RESTTraceConverter.convertToCommaJson(p2.getType(), (JsonElement)new JsonPrimitive(match.bindings.get(p2.getName())));
                            event2.addParameter(paramInJson);
                        }
                        calls.put(connectionKey, command);
                        result.append(event2.toJson());
                        result.append(System.lineSeparator());
                        continue;
                    }
                    if (fragments[5].startsWith("PUT") || fragments[5].startsWith("POST")) {
                        subFragments = fragments[5].split("\t+", 3);
                        uri = subFragments[1];
                        match = RESTTraceConverter.findEvent(uri, mappings);
                        if (match == null || calls.containsKey(connectionKey = RESTTraceConverter.makeConnectionKey(fragments[1], fragments[2]))) continue;
                        ArrayList<Parameter> pathParameters = ProjectUtility.getPathParameters(mappings, match.event);
                        List<Parameter> nonPathParameters = ProjectUtility.getNonPathParameters(mappings, match.event);
                        JsonElement nonPathParamsJson = null;
                        if (nonPathParameters.size() > 0) {
                            String[] subsubFragments = subFragments[2].split("\t+", 2);
                            nonPathParamsJson = JsonParser.parseString((String)subsubFragments[0]);
                        }
                        Signature sig3 = (Signature)match.event.eContainer();
                        String kind = match.event instanceof Signal ? "Signal" : "Command";
                        calls.put(connectionKey, match.event);
                        String port3 = RESTTraceConverter.getPort(component, sig3);
                        boolean isRequiredPort = RESTTraceConverter.isRequiredPort(component, sig3);
                        Event event3 = !isRequiredPort ? new Event(kind, RESTTraceConverter.convertTimestamp(fragments[0]), sig3.getName(), match.event.getName(), "client", "clientPort", "c", port3) : new Event(kind, RESTTraceConverter.convertTimestamp(fragments[0]), sig3.getName(), match.event.getName(), "c", port3, "client", "clientPort");
                        for (Parameter p3 : match.event.getParameters()) {
                            JsonObject paramInJson2;
                            if (pathParameters.contains(p3)) {
                                paramInJson2 = RESTTraceConverter.convertToCommaJson(p3.getType(), (JsonElement)new JsonPrimitive(match.bindings.get(p3.getName())));
                                event3.addParameter(paramInJson2);
                                continue;
                            }
                            if (nonPathParameters.size() == 1) {
                                paramInJson2 = RESTTraceConverter.convertToCommaJson(p3.getType(), nonPathParamsJson);
                                event3.addParameter(paramInJson2);
                                continue;
                            }
                            paramInJson2 = RESTTraceConverter.convertToCommaJson(p3.getType(), nonPathParamsJson.getAsJsonObject().get(p3.getName()));
                            event3.addParameter(paramInJson2);
                        }
                        result.append(event3.toJson());
                        result.append(System.lineSeparator());
                        continue;
                    }
                    String connectionKey2 = RESTTraceConverter.makeConnectionKey(fragments[3], fragments[4]);
                    if (notifications.containsKey(connectionKey2)) {
                        Notification n = (Notification)((EventMatch)notifications.get((Object)connectionKey2)).event;
                        sig = (Signature)n.eContainer();
                        port = RESTTraceConverter.getPort(component, sig);
                        boolean isRequiredPort = RESTTraceConverter.isRequiredPort(component, sig);
                        event = !isRequiredPort ? new Event("Notification", RESTTraceConverter.convertTimestamp(fragments[0]), sig.getName(), n.getName(), "c", port, "client", "clientPort") : new Event("Notification", RESTTraceConverter.convertTimestamp(fragments[0]), sig.getName(), n.getName(), "client", "clientPort", "c", port);
                        ArrayList<Parameter> pathParameters = ProjectUtility.getPathParameters(mappings, (InterfaceEvent)n);
                        List<Parameter> nonPathParameters = ProjectUtility.getNonPathParameters(mappings, (InterfaceEvent)n);
                        JsonElement nonPathParamsJson = null;
                        if (nonPathParameters.size() > 0) {
                            String nonPathParams = fragments[5].substring(11);
                            nonPathParamsJson = JsonParser.parseString((String)nonPathParams);
                        }
                        for (Parameter p4 : n.getParameters()) {
                            if (pathParameters.contains(p4)) {
                                paramInJson = RESTTraceConverter.convertToCommaJson(p4.getType(), (JsonElement)new JsonPrimitive(((EventMatch)notifications.get((Object)fragments[4])).bindings.get(p4.getName())));
                                event.addParameter(paramInJson);
                                continue;
                            }
                            if (nonPathParameters.size() == 1) {
                                paramInJson = RESTTraceConverter.convertToCommaJson(p4.getType(), nonPathParamsJson);
                                event.addParameter(paramInJson);
                                continue;
                            }
                            paramInJson = RESTTraceConverter.convertToCommaJson(p4.getType(), nonPathParamsJson.getAsJsonObject().get(p4.getName()));
                            event.addParameter(paramInJson);
                        }
                        result.append(event.toJson());
                        result.append(System.lineSeparator());
                        continue;
                    }
                    if (!calls.containsKey(connectionKey2)) continue;
                    if (calls.get(connectionKey2) instanceof Signal) {
                        calls.remove(connectionKey2);
                        continue;
                    }
                    Command command = (Command)calls.get(connectionKey2);
                    sig = (Signature)command.eContainer();
                    port = RESTTraceConverter.getPort(component, sig);
                    boolean isRequiredPort = RESTTraceConverter.isRequiredPort(component, sig);
                    event = !isRequiredPort ? new Event("Reply", RESTTraceConverter.convertTimestamp(fragments[0]), sig.getName(), command.getName(), "c", port, "client", "clientPort") : new Event("Reply", RESTTraceConverter.convertTimestamp(fragments[0]), sig.getName(), command.getName(), "client", "clientPort", "c", port);
                    List outParams = command.getParameters().stream().filter(p -> p.getDirection() == DIRECTION.OUT).collect(Collectors.toList());
                    RecordTypeDecl returnType = (RecordTypeDecl)((TypeReference)command.getType()).getType();
                    List fields = TypeUtilities.getAllFields((RecordTypeDecl)returnType);
                    boolean isVoid = true;
                    for (RecordField field : fields) {
                        String comment = SLCommentLocator.getSLComment((EObject)field).trim();
                        if (!comment.startsWith("200")) continue;
                        isVoid = false;
                        break;
                    }
                    int returnValuesSize = outParams.size();
                    if (!isVoid) {
                        ++returnValuesSize;
                    }
                    String params = fragments[5].split("\t+", 2)[0];
                    int positionResponseCode = fragments[5].indexOf("HTTP/1.1") + 9;
                    String responseCode = fragments[5].substring(positionResponseCode, positionResponseCode + 3);
                    JsonElement paramsJson = null;
                    if (!responseCode.equals("204") || returnValuesSize > 0) {
                        paramsJson = JsonParser.parseString((String)params);
                    }
                    for (Parameter p5 : outParams) {
                        JsonObject paramInJson3 = null;
                        paramInJson3 = responseCode.equals("200") ? (returnValuesSize == 1 ? RESTTraceConverter.convertToCommaJson(p5.getType(), paramsJson) : RESTTraceConverter.convertToCommaJson(p5.getType(), paramsJson.getAsJsonObject().get(p5.getName()))) : RESTTraceConverter.defaultOutParam(p5.getType());
                        event.addParameter(paramInJson3);
                    }
                    JsonObject returnValue = new JsonObject();
                    EnumTypeDecl statusEnum = (EnumTypeDecl)((TypeReference)((RecordField)fields.get(0)).getType()).getType();
                    EnumElement statusLiteral = TypeUtilities.getEnumElementByValue((EnumTypeDecl)statusEnum, (int)Integer.parseInt(responseCode));
                    if (statusLiteral == null) {
                        throw new Exception("There is no enum item for code " + responseCode + " in type " + statusEnum.getName());
                    }
                    returnValue.addProperty(((RecordField)fields.get(0)).getName(), String.valueOf(statusEnum.getName()) + "::" + statusLiteral.getName());
                    boolean fieldFound = false;
                    for (RecordField field : fields) {
                        if (fields.indexOf(field) == 0) continue;
                        if (SLCommentLocator.getSLComment((EObject)field).trim().startsWith(responseCode)) {
                            fieldFound = true;
                            JsonObject value = null;
                            value = !responseCode.equals("200") ? RESTTraceConverter.convertToCommaJson(field.getType(), paramsJson) : (returnValuesSize == 1 ? RESTTraceConverter.convertToCommaJson(field.getType(), paramsJson) : RESTTraceConverter.convertToCommaJson(field.getType(), paramsJson.getAsJsonObject().get("result")));
                            if (value.get("type").getAsString().equals("record") || value.get("type").getAsString().equals("vector")) {
                                returnValue.add(field.getName(), (JsonElement)value);
                                continue;
                            }
                            returnValue.add(field.getName(), value.get("value"));
                            continue;
                        }
                        returnValue.add(field.getName(), RESTTraceConverter.defaultValue(field.getType()));
                    }
                    if (responseCode.equals("204")) {
                        fieldFound = true;
                    }
                    if (!(fieldFound || isVoid && responseCode.equals("200"))) {
                        throw new Exception("No field for code " + responseCode + " in type " + returnType.getName());
                    }
                    JsonObject returnParam = new JsonObject();
                    returnParam.addProperty("type", "record");
                    if (returnType.eContainer() instanceof Signature) {
                        returnParam.addProperty("record", String.valueOf(((Signature)returnType.eContainer()).getName()) + "_" + returnType.getName());
                    } else {
                        returnParam.addProperty("record", returnType.getName());
                    }
                    returnParam.add("value", (JsonElement)returnValue);
                    event.addParameter(returnParam);
                    result.append(event.toJson());
                    result.append(System.lineSeparator());
                    calls.remove(connectionKey2);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    private static JsonObject convertToCommaJson(Type type, JsonElement value) {
        if (type instanceof TypeReference) {
            TypeDecl typeDecl = ((TypeReference)type).getType();
            if (typeDecl instanceof SimpleTypeDecl) {
                if (((SimpleTypeDecl)typeDecl).getBase() != null) {
                    typeDecl = ((SimpleTypeDecl)typeDecl).getBase();
                }
                if (typeDecl.getName().equals("int")) {
                    return SUTToCommaTrace.convertInt(value);
                }
                if (typeDecl.getName().equals("string")) {
                    return SUTToCommaTrace.convertString(value);
                }
                if (typeDecl.getName().equals("real")) {
                    return SUTToCommaTrace.convertReal(value);
                }
                if (typeDecl.getName().equals("bool")) {
                    return SUTToCommaTrace.convertBool(value);
                }
            }
            if (typeDecl instanceof EnumTypeDecl) {
                return SUTToCommaTrace.convertEnum(typeDecl.getName(), value);
            }
            if (typeDecl instanceof RecordTypeDecl) {
                return SUTToCommaTrace.convertRecord((RecordTypeDecl)typeDecl, value);
            }
            if (typeDecl instanceof VectorTypeDecl) {
                VectorDescriptor descr = VectorDescriptor.getDescriptor(((VectorTypeDecl)typeDecl).getConstructor());
                SUTToCommaTrace.convertVector(descr.elementType, descr.dimensions, value);
            }
        }
        if (type instanceof VectorTypeConstructor) {
            VectorDescriptor descr = VectorDescriptor.getDescriptor((VectorTypeConstructor)type);
            return SUTToCommaTrace.convertVector(descr.elementType, descr.dimensions, value);
        }
        return null;
    }

    private static JsonObject defaultOutParam(Type type) {
        if (type instanceof TypeReference) {
            TypeDecl typeDecl = ((TypeReference)type).getType();
            JsonObject result = new JsonObject();
            if (typeDecl instanceof SimpleTypeDecl) {
                if (((SimpleTypeDecl)typeDecl).getBase() != null) {
                    typeDecl = ((SimpleTypeDecl)typeDecl).getBase();
                }
                result.add("value", RESTTraceConverter.defaultValue(type));
                result.addProperty("type", typeDecl.getName());
                return result;
            }
            if (typeDecl instanceof EnumTypeDecl) {
                result.add("value", RESTTraceConverter.defaultValue(type));
                result.addProperty("type", "enum");
                return result;
            }
        }
        return (JsonObject)RESTTraceConverter.defaultValue(type);
    }

    private static JsonElement defaultValue(Type type) {
        if (type instanceof TypeReference) {
            TypeDecl typeDecl = ((TypeReference)type).getType();
            if (typeDecl instanceof SimpleTypeDecl) {
                if (((SimpleTypeDecl)typeDecl).getBase() != null) {
                    typeDecl = ((SimpleTypeDecl)typeDecl).getBase();
                }
                if (typeDecl.getName().equals("int")) {
                    return new JsonPrimitive((Number)0);
                }
                if (typeDecl.getName().equals("string")) {
                    return new JsonPrimitive("");
                }
                if (typeDecl.getName().equals("real")) {
                    return new JsonPrimitive((Number)0.0);
                }
                if (typeDecl.getName().equals("bool")) {
                    return new JsonPrimitive(Boolean.valueOf(true));
                }
            }
            if (typeDecl instanceof EnumTypeDecl) {
                return new JsonPrimitive(String.valueOf(typeDecl.getName()) + "::" + ((EnumElement)((EnumTypeDecl)typeDecl).getLiterals().get(0)).getName());
            }
            if (typeDecl instanceof RecordTypeDecl) {
                JsonObject result = new JsonObject();
                result.addProperty("type", "record");
                String typeName = typeDecl.getName();
                if (typeDecl.eContainer() instanceof Signature) {
                    typeName = String.valueOf(((Signature)typeDecl.eContainer()).getName()) + "_" + typeName;
                }
                result.addProperty("record", typeName);
                JsonObject value = new JsonObject();
                for (RecordField field : TypeUtilities.getAllFields((RecordTypeDecl)((RecordTypeDecl)typeDecl))) {
                    value.add(field.getName(), RESTTraceConverter.defaultValue(field.getType()));
                }
                result.add("value", (JsonElement)value);
                return result;
            }
            if (typeDecl instanceof VectorTypeDecl) {
                VectorDescriptor descr = VectorDescriptor.getDescriptor(((VectorTypeDecl)typeDecl).getConstructor());
                return RESTTraceConverter.defaultVectorValue(descr.elementType, descr.dimensions);
            }
        }
        if (type instanceof VectorTypeConstructor) {
            VectorDescriptor descr = VectorDescriptor.getDescriptor((VectorTypeConstructor)type);
            return RESTTraceConverter.defaultVectorValue(descr.elementType, descr.dimensions);
        }
        return null;
    }

    private static JsonObject defaultVectorValue(TypeDecl type, int dimension) {
        JsonObject result = new JsonObject();
        result.addProperty("type", "vector");
        if (dimension > 1) {
            result.addProperty("typeElem", "vector");
            result.add("value", (JsonElement)new JsonArray());
            return result;
        }
        if (type instanceof SimpleTypeDecl) {
            String typeName = type.getName();
            if (((SimpleTypeDecl)type).getBase() != null) {
                typeName = ((SimpleTypeDecl)type).getBase().getName();
            }
            result.addProperty("typeElem", typeName);
            result.add("value", (JsonElement)new JsonArray());
        }
        if (type instanceof EnumTypeDecl) {
            result.addProperty("typeElem", "enum");
            result.add("value", (JsonElement)new JsonArray());
        }
        if (type instanceof RecordTypeDecl) {
            result.addProperty("typeElem", "record");
            result.add("value", (JsonElement)new JsonArray());
        }
        return result;
    }

    private static EventMatch findEvent(String uri, PathMappings mappings) {
        EventMatch result = null;
        for (SignatureMapping sigMapping : mappings.getSignatureMappings()) {
            for (EventMapping eventMapping : sigMapping.getEventMappings()) {
                result = RESTTraceConverter.matchPath(eventMapping.getPath(), uri);
                if (result == null) continue;
                result.event = eventMapping.getEvent();
                return result;
            }
        }
        return result;
    }

    private static EventMatch matchPath(Path path, String uri) {
        String[] uriFragments = uri.split("/");
        if (uriFragments.length - 1 != path.getSegments().size()) {
            return null;
        }
        HashMap<String, String> bindings = new HashMap<String, String>();
        int i = 0;
        while (i < path.getSegments().size()) {
            String segment;
            if (path.getSegments().get(i) instanceof FixedSegment) {
                segment = ((FixedSegment)path.getSegments().get(i)).getName();
                if (!segment.equals(uriFragments[i + 1])) {
                    return null;
                }
            } else {
                segment = ((ParameterSegment)path.getSegments().get(i)).getParameter().getName();
                bindings.put(segment, uriFragments[i + 1]);
            }
            ++i;
        }
        EventMatch result = new EventMatch();
        result.bindings = bindings;
        return result;
    }

    private static String convertTimestamp(String epochTime) {
        Double epochTimeDouble = Double.valueOf(epochTime);
        Long timeInMillis = (long)(epochTimeDouble * 1000.0);
        Instant epochTimeInstant = Instant.ofEpochMilli(timeInMillis);
        OffsetDateTime odt = OffsetDateTime.ofInstant(epochTimeInstant, ZoneId.of("Europe/Paris"));
        return odt.toString();
    }

    private static String makeConnectionKey(String ip, String port) {
        return String.valueOf(ip) + "_" + port;
    }

    private static String getPort(Component component, Signature sig) {
        for (Port port : component.getPorts()) {
            if (port.getInterface() != sig) continue;
            return port.getName();
        }
        return "";
    }

    private static boolean isRequiredPort(Component component, Signature sig) {
        for (Port port : component.getPorts()) {
            if (!(port instanceof RequiredPort) || port.getInterface() != sig) continue;
            return true;
        }
        return false;
    }
}

