/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction.java;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.ui.correction.java.FindClassResolutionsOperation;
import org.eclipse.pde.internal.ui.correction.java.JavaResolutionFactory;

public class QuickFixProcessor
implements IQuickFixProcessor {
    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        ArrayList<Object> results = new ArrayList<Object>();
        FindClassResolutionsOperation.AbstractClassResolutionCollector collector = this.createCollector(results);
        IProblemLocation[] iProblemLocationArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            IProblemLocation location = iProblemLocationArray[n2];
            int id = location.getProblemId();
            switch (id) {
                case 0x1000133: {
                    this.handleAccessRestrictionProblem(context, location, collector);
                }
                case 0x1000002: 
                case 33554515: 
                case 67108984: 
                case 0x8000081: 
                case 268435846: 
                case 0x22000032: {
                    this.handleImportNotFound(context, location, collector);
                }
            }
            ++n2;
        }
        return results.toArray(new IJavaCompletionProposal[results.size()]);
    }

    private void handleAccessRestrictionProblem(IInvocationContext context, IProblemLocation location, FindClassResolutionsOperation.AbstractClassResolutionCollector collector) {
        IJavaProject referencedJavaProject;
        IVariableBinding tempVariable;
        ITypeBinding referencedElement = null;
        ASTNode node = location.getCoveredNode(context.getASTRoot());
        if (node instanceof Type) {
            referencedElement = ((Type)node).resolveBinding();
        } else if (node instanceof Name) {
            referencedElement = ((Name)node).resolveBinding();
        } else if (node instanceof MethodInvocation) {
            IMethodBinding tempMethod = ((MethodInvocation)node).resolveMethodBinding();
            if (tempMethod != null) {
                referencedElement = tempMethod.getDeclaringClass();
            }
        } else if (node instanceof FieldAccess && (tempVariable = ((FieldAccess)node).resolveFieldBinding()) != null) {
            referencedElement = tempVariable.getDeclaringClass();
        }
        if (referencedElement != null && (referencedJavaProject = referencedElement.getJavaElement().getJavaProject()) != null && WorkspaceModelManager.isPluginProject((IProject)referencedJavaProject.getProject())) {
            IPackageFragment referencedPackage = (IPackageFragment)referencedElement.getJavaElement().getAncestor(4);
            IJavaProject currentProject = context.getCompilationUnit().getJavaProject();
            if (!WorkspaceModelManager.isPluginProject((IProject)currentProject.getProject())) {
                return;
            }
            if (!referencedJavaProject.equals(currentProject)) {
                IPluginModelBase referencedModel = PluginRegistry.findModel((IProject)referencedJavaProject.getProject());
                ExportPackageDescription[] exportPackages = referencedModel.getBundleDescription().getExportPackages();
                boolean packageExported = false;
                if (referencedPackage != null) {
                    ExportPackageDescription[] exportPackageDescriptionArray = exportPackages;
                    int n = exportPackages.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ExportPackageDescription exportPackage = exportPackageDescriptionArray[n2];
                        if (exportPackage.getName().equals(referencedPackage.getElementName())) {
                            packageExported = true;
                            this.handleAccessRestrictionByImportPackage(context.getCompilationUnit().getJavaProject().getProject(), exportPackage, collector);
                            break;
                        }
                        ++n2;
                    }
                    if (!packageExported) {
                        collector.addExportPackageResolutionModification(referencedPackage);
                    }
                }
            } else {
                this.handleAccessRestrictionByImportPackage(referencedPackage, collector);
            }
        }
    }

    private void handleAccessRestrictionByImportPackage(IPackageFragment fragment, FindClassResolutionsOperation.AbstractClassResolutionCollector collector) {
        HashSet<String> set = new HashSet<String>();
        IProject project = fragment.getJavaProject().getProject();
        String pkgName = fragment.getElementName();
        IPluginModelBase base = PluginRegistry.findModel((IProject)project);
        ExportPackageDescription[] descs = base.getBundleDescription().getResolvedImports();
        ExportPackageDescription foundExportPackage = null;
        ExportPackageDescription[] exportPackageDescriptionArray = descs;
        int n = descs.length;
        int n2 = 0;
        while (n2 < n) {
            ExportPackageDescription desc = exportPackageDescriptionArray[n2];
            BundleDescription exporter = desc.getExporter();
            if (set.add(exporter.getSymbolicName())) {
                ExportPackageDescription[] exportedPkgs;
                ExportPackageDescription[] exportPackageDescriptionArray2 = exportedPkgs = exporter.getExportPackages();
                int n3 = exportedPkgs.length;
                int n4 = 0;
                while (n4 < n3) {
                    ExportPackageDescription exportedPkg = exportPackageDescriptionArray2[n4];
                    if (exportedPkg.getName().equals(pkgName)) {
                        foundExportPackage = exportedPkg;
                        collector.addRequireBundleModification(project, exportedPkg, 16);
                        break;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (foundExportPackage != null) {
            collector.addResolutionModification(project, foundExportPackage);
        }
    }

    private void handleAccessRestrictionByImportPackage(IProject currentProject, ExportPackageDescription desc, FindClassResolutionsOperation.AbstractClassResolutionCollector collector) {
        BundleDescription supplier = desc.getSupplier();
        if (supplier != null) {
            String supplierId = supplier.getSymbolicName();
            IPluginModelBase base = PluginRegistry.findModel((IProject)currentProject);
            BundleDescription bd = base.getBundleDescription();
            BundleSpecification[] imports = bd.getRequiredBundles();
            boolean supplierImported = false;
            BundleSpecification[] bundleSpecificationArray = imports;
            int n = imports.length;
            int n2 = 0;
            while (n2 < n) {
                BundleSpecification importstatement = bundleSpecificationArray[n2];
                BundleDescription importSupplier = (BundleDescription)importstatement.getSupplier();
                if (importSupplier != null && importSupplier.getSymbolicName().equals(supplierId)) {
                    supplierImported = true;
                    break;
                }
                ++n2;
            }
            if (!supplierImported) {
                ImportPackageSpecification[] importPackages;
                boolean proposeImportPackage = true;
                ImportPackageSpecification[] importPackageSpecificationArray = importPackages = bd.getImportPackages();
                int n3 = importPackages.length;
                int n4 = 0;
                while (n4 < n3) {
                    ImportPackageSpecification importPackage = importPackageSpecificationArray[n4];
                    if (desc.getName().equals(importPackage.getName())) {
                        proposeImportPackage = false;
                        break;
                    }
                    ++n4;
                }
                if (proposeImportPackage) {
                    collector.addResolutionModification(currentProject, desc);
                }
                collector.addRequireBundleModification(currentProject, desc, 16);
            }
        }
    }

    private void handleImportNotFound(IInvocationContext context, IProblemLocation problemLocation, FindClassResolutionsOperation.AbstractClassResolutionCollector collector) {
        CompilationUnit cu = context.getASTRoot();
        ASTNode selectedNode = problemLocation.getCoveringNode(cu);
        if (selectedNode != null) {
            ASTNode node = QuickFixProcessor.getParent(selectedNode);
            String className = null;
            if (node == null) {
                if (selectedNode instanceof Name) {
                    ITypeBinding typeBinding = ((Name)selectedNode).resolveTypeBinding();
                    if (typeBinding != null) {
                        className = typeBinding.getBinaryName();
                    }
                    if (className == null && selectedNode instanceof SimpleName) {
                        className = ((SimpleName)selectedNode).getIdentifier();
                    }
                }
            } else if (node instanceof ImportDeclaration) {
                String packageName = ((ImportDeclaration)node).getName().getFullyQualifiedName();
                if (!((ImportDeclaration)node).isOnDemand()) {
                    int lastPeriod = packageName.lastIndexOf(46);
                    packageName = packageName.substring(0, lastPeriod >= 0 ? lastPeriod : packageName.length());
                }
                collector.addSearchRepositoriesModification(packageName);
            }
            if (className != null) {
                IProject project = cu.getJavaElement().getJavaProject().getProject();
                if (!WorkspaceModelManager.isPluginProject((IProject)project)) {
                    return;
                }
                FindClassResolutionsOperation findOperation = new FindClassResolutionsOperation(project, cu, className, collector);
                try {
                    findOperation.run((IProgressMonitor)new NullProgressMonitor());
                }
                catch (InterruptedException | InvocationTargetException exception) {}
            }
        }
    }

    private FindClassResolutionsOperation.AbstractClassResolutionCollector createCollector(final Collection<Object> result) {
        return new FindClassResolutionsOperation.AbstractClassResolutionCollector(){
            private Set<String> addedImportPackageResolutions = new HashSet<String>();
            boolean isDone = false;

            @Override
            public void addResolutionModification(IProject project, ExportPackageDescription desc) {
                this.addResolutionModification(project, desc, null, "");
            }

            @Override
            public void addResolutionModification(IProject project, ExportPackageDescription desc, CompilationUnit cu, String qualifiedTypeToImport) {
                if (this.addedImportPackageResolutions.contains(desc.getName())) {
                    return;
                }
                Object proposal = JavaResolutionFactory.createImportPackageProposal(project, desc, 1, 4, cu, qualifiedTypeToImport);
                if (proposal != null) {
                    this.addedImportPackageResolutions.add(desc.getName());
                    result.add(proposal);
                    this.isDone = true;
                }
            }

            @Override
            public Object addExportPackageResolutionModification(IPackageFragment aPackage) {
                Object proposal = super.addExportPackageResolutionModification(aPackage);
                if (proposal != null) {
                    result.add(proposal);
                }
                return proposal;
            }

            @Override
            public Object addRequireBundleModification(IProject project, ExportPackageDescription desc, int relevance) {
                return this.addRequireBundleModification(project, desc, relevance, null, "");
            }

            @Override
            public Object addRequireBundleModification(IProject project, ExportPackageDescription desc, int relevance, CompilationUnit cu, String qualifiedTypeToImport) {
                Object proposal = super.addRequireBundleModification(project, desc, relevance, cu, qualifiedTypeToImport);
                if (proposal != null) {
                    result.add(proposal);
                }
                return proposal;
            }

            @Override
            public Object addSearchRepositoriesModification(String packageName) {
                Object proposal = super.addSearchRepositoriesModification(packageName);
                if (proposal != null) {
                    result.add(proposal);
                }
                return proposal;
            }

            @Override
            public boolean isDone() {
                return this.isDone;
            }
        };
    }

    private static ASTNode getParent(ASTNode node) {
        while ((node = node.getParent()) != null && node.getNodeType() != 26) {
        }
        return node;
    }

    public boolean hasCorrections(ICompilationUnit unit, int problemId) {
        switch (problemId) {
            case 0x1000002: 
            case 0x1000133: 
            case 33554515: 
            case 67108984: 
            case 0x8000081: 
            case 268435846: 
            case 0x22000032: {
                IJavaProject project;
                IJavaElement parent = unit.getParent();
                if (parent == null || (project = parent.getJavaProject()) == null) break;
                return WorkspaceModelManager.isPluginProject((IProject)project.getProject());
            }
        }
        return false;
    }
}

