/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator;

import com.google.inject.Inject;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xtext.generator.model.TypeReference;
import org.eclipse.xtext.xtext.generator.model.project.IXtextProjectConfig;

public class XtextGeneratorNaming {
    @Inject
    private IXtextProjectConfig projectConfig;

    public String getRuntimeBasePackage(Grammar grammar) {
        return GrammarUtil.getNamespace((Grammar)grammar);
    }

    public String getRuntimeTestBasePackage(Grammar grammar) {
        return this.getRuntimeBasePackage(grammar) + ".tests";
    }

    public TypeReference getRuntimeModule(Grammar grammar) {
        return new TypeReference(this.getRuntimeBasePackage(grammar), GrammarUtil.getSimpleName((Grammar)grammar) + "RuntimeModule");
    }

    public TypeReference getRuntimeGenModule(Grammar grammar) {
        return new TypeReference(this.getRuntimeBasePackage(grammar), "Abstract" + GrammarUtil.getSimpleName((Grammar)grammar) + "RuntimeModule");
    }

    public TypeReference getRuntimeDefaultModule(Grammar grammar) {
        return new TypeReference("org.eclipse.xtext.service.DefaultRuntimeModule");
    }

    public TypeReference getRuntimeSetup(Grammar grammar) {
        return new TypeReference(this.getRuntimeBasePackage(grammar), GrammarUtil.getSimpleName((Grammar)grammar) + "StandaloneSetup");
    }

    public TypeReference getRuntimeGenSetup(Grammar grammar) {
        return new TypeReference(this.getRuntimeBasePackage(grammar), GrammarUtil.getSimpleName((Grammar)grammar) + "StandaloneSetupGenerated");
    }

    public String getGenericIdeBasePackage(Grammar grammar) {
        return this.getRuntimeBasePackage(grammar) + ".ide";
    }

    public String getGenericIdeTestBasePackage(Grammar grammar) {
        return this.getGenericIdeBasePackage(grammar) + ".tests";
    }

    public TypeReference getGenericIdeModule(Grammar grammar) {
        return new TypeReference(this.getGenericIdeBasePackage(grammar), GrammarUtil.getSimpleName((Grammar)grammar) + "IdeModule");
    }

    public TypeReference getGenericIdeGenModule(Grammar grammar) {
        return new TypeReference(this.getGenericIdeBasePackage(grammar), "Abstract" + GrammarUtil.getSimpleName((Grammar)grammar) + "IdeModule");
    }

    public TypeReference getGenericIdeDefaultModule(Grammar grammar) {
        return new TypeReference("org.eclipse.xtext.ide.DefaultIdeModule");
    }

    public TypeReference getGenericIdeSetup(Grammar grammar) {
        return new TypeReference(this.getGenericIdeBasePackage(grammar), GrammarUtil.getSimpleName((Grammar)grammar) + "IdeSetup");
    }

    public String getEclipsePluginBasePackage(Grammar grammar) {
        return GrammarUtil.getNamespace((Grammar)grammar) + ".ui";
    }

    public String getEclipsePluginTestBasePackage(Grammar grammar) {
        return this.getEclipsePluginBasePackage(grammar) + ".tests";
    }

    public TypeReference getEclipsePluginModule(Grammar grammar) {
        return new TypeReference(this.getEclipsePluginBasePackage(grammar), GrammarUtil.getSimpleName((Grammar)grammar) + "UiModule");
    }

    public TypeReference getEclipsePluginGenModule(Grammar grammar) {
        return new TypeReference(this.getEclipsePluginBasePackage(grammar), "Abstract" + GrammarUtil.getSimpleName((Grammar)grammar) + "UiModule");
    }

    public TypeReference getEclipsePluginDefaultModule(Grammar grammar) {
        return new TypeReference("org.eclipse.xtext.ui.DefaultUiModule");
    }

    public TypeReference getEclipsePluginExecutableExtensionFactory(Grammar grammar) {
        return new TypeReference(this.getEclipsePluginBasePackage(grammar), GrammarUtil.getSimpleName((Grammar)grammar) + "ExecutableExtensionFactory");
    }

    public TypeReference getEclipsePluginEditor(Grammar grammar) {
        return new TypeReference(this.getEclipsePluginBasePackage(grammar) + ".editor", GrammarUtil.getSimpleName((Grammar)grammar) + "Editor");
    }

    public TypeReference getEclipsePluginXbaseEditor(Grammar grammar) {
        return new TypeReference("org.eclipse.xtext.xbase.ui.editor.XbaseEditor");
    }

    public TypeReference getEclipsePluginDefaultEditor(Grammar grammar) {
        return new TypeReference("org.eclipse.xtext.ui.editor.XtextEditor");
    }

    public TypeReference getEclipsePluginActivator() {
        String pluginName = this.projectConfig.getEclipsePlugin().getName();
        if (pluginName == null) {
            return null;
        }
        String activatorName = pluginName.replaceAll("\\.ui$", "");
        activatorName = StringExtensions.toFirstUpper((String)activatorName.substring(activatorName.lastIndexOf(46) + 1)) + "Activator";
        return new TypeReference(pluginName + ".internal", activatorName);
    }

    public String getWebBasePackage(Grammar grammar) {
        return GrammarUtil.getNamespace((Grammar)grammar) + ".web";
    }

    public TypeReference getWebModule(Grammar grammar) {
        return new TypeReference(this.getWebBasePackage(grammar), GrammarUtil.getSimpleName((Grammar)grammar) + "WebModule");
    }

    public TypeReference getWebDefaultModule(Grammar grammar) {
        return new TypeReference("org.eclipse.xtext.web.server.DefaultWebModule");
    }

    public TypeReference getWebGenModule(Grammar grammar) {
        return new TypeReference(this.getWebBasePackage(grammar), "Abstract" + GrammarUtil.getSimpleName((Grammar)grammar) + "WebModule");
    }

    public TypeReference getWebSetup(Grammar grammar) {
        return new TypeReference(this.getWebBasePackage(grammar), GrammarUtil.getSimpleName((Grammar)grammar) + "WebSetup");
    }
}

