/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.rules.fa;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.fa.ControlNode;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementFunction;
import org.polarsys.capella.core.data.fa.SequenceLink;
import org.polarsys.capella.core.data.fa.SequenceLinkEnd;
import org.polarsys.capella.core.transition.common.constants.Messages;
import org.polarsys.capella.core.transition.common.handlers.log.LogHelper;
import org.polarsys.capella.transition.system2subsystem.handlers.attachment.FunctionalChainAttachmentHelper;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class ControlNodeRule
extends org.polarsys.capella.core.transition.system.rules.fa.ControlNodeRule {
    public IStatus transformRequired(EObject element, IContext context) {
        IStatus result = super.transformRequired(element, context);
        if (result.isOK()) {
            ControlNode controlNode = (ControlNode)element;
            FunctionalChainAttachmentHelper helper = FunctionalChainAttachmentHelper.getInstance(context);
            boolean invalidSource = this.getSourceFCIFs(controlNode).stream().anyMatch(inv -> helper.isValidElement((FunctionalChainInvolvement)inv, context) == false);
            boolean invalidTarget = this.getTargetFCIFs(controlNode).stream().anyMatch(inv -> helper.isValidElement((FunctionalChainInvolvement)inv, context) == false);
            if (invalidSource || invalidTarget) {
                result = new Status(2, Messages.Activity_Transformation, NLS.bind((String)"Control Node ''{0}'' is not valid.", (Object)LogHelper.getInstance().getText((Object)controlNode)));
            }
        }
        return result;
    }

    private Set<FunctionalChainInvolvementFunction> getSourceFCIFs(ControlNode controlNode) {
        HashSet<ControlNode> visited = new HashSet<ControlNode>();
        return this.getSourceFCIFs(controlNode, visited);
    }

    private Set<FunctionalChainInvolvementFunction> getSourceFCIFs(ControlNode controlNode, Set<ControlNode> visited) {
        HashSet<FunctionalChainInvolvementFunction> sourceFCIFs = new HashSet<FunctionalChainInvolvementFunction>();
        List incomingSequenceLinks = EObjectExt.getReferencers((EObject)controlNode, (EReference)FaPackage.Literals.SEQUENCE_LINK__TARGET);
        for (EObject eObj : incomingSequenceLinks) {
            if (!(eObj instanceof SequenceLink)) continue;
            SequenceLink sequenceLink = (SequenceLink)eObj;
            SequenceLinkEnd source = sequenceLink.getSource();
            if (source instanceof FunctionalChainInvolvementFunction) {
                sourceFCIFs.add((FunctionalChainInvolvementFunction)source);
                continue;
            }
            if (!(source instanceof ControlNode) || visited.contains(source)) continue;
            visited.add((ControlNode)source);
            sourceFCIFs.addAll(this.getSourceFCIFs((ControlNode)source, visited));
        }
        return sourceFCIFs;
    }

    private Set<FunctionalChainInvolvementFunction> getTargetFCIFs(ControlNode controlNode) {
        HashSet<ControlNode> visited = new HashSet<ControlNode>();
        return this.getTargetFCIFs(controlNode, visited);
    }

    private Set<FunctionalChainInvolvementFunction> getTargetFCIFs(ControlNode controlNode, Set<ControlNode> visited) {
        HashSet<FunctionalChainInvolvementFunction> targetFCIFs = new HashSet<FunctionalChainInvolvementFunction>();
        List outgoingSequenceLinks = EObjectExt.getReferencers((EObject)controlNode, (EReference)FaPackage.Literals.SEQUENCE_LINK__SOURCE);
        for (EObject eObj : outgoingSequenceLinks) {
            if (!(eObj instanceof SequenceLink)) continue;
            SequenceLink sequenceLink = (SequenceLink)eObj;
            SequenceLinkEnd target = sequenceLink.getTarget();
            if (target instanceof FunctionalChainInvolvementFunction) {
                targetFCIFs.add((FunctionalChainInvolvementFunction)target);
                continue;
            }
            if (!(target instanceof ControlNode) || visited.contains(target)) continue;
            visited.add((ControlNode)target);
            targetFCIFs.addAll(this.getTargetFCIFs((ControlNode)target, visited));
        }
        return targetFCIFs;
    }
}

