/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.validation;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.AcceleoASTNode;
import org.eclipse.acceleo.Binding;
import org.eclipse.acceleo.Block;
import org.eclipse.acceleo.Comment;
import org.eclipse.acceleo.ErrorBinding;
import org.eclipse.acceleo.ErrorBlockComment;
import org.eclipse.acceleo.ErrorComment;
import org.eclipse.acceleo.ErrorExpressionStatement;
import org.eclipse.acceleo.ErrorFileStatement;
import org.eclipse.acceleo.ErrorForStatement;
import org.eclipse.acceleo.ErrorIfStatement;
import org.eclipse.acceleo.ErrorImport;
import org.eclipse.acceleo.ErrorLetStatement;
import org.eclipse.acceleo.ErrorMargin;
import org.eclipse.acceleo.ErrorMetamodel;
import org.eclipse.acceleo.ErrorModule;
import org.eclipse.acceleo.ErrorProtectedArea;
import org.eclipse.acceleo.ErrorQuery;
import org.eclipse.acceleo.ErrorTemplate;
import org.eclipse.acceleo.ErrorVariable;
import org.eclipse.acceleo.Expression;
import org.eclipse.acceleo.ExpressionStatement;
import org.eclipse.acceleo.FileStatement;
import org.eclipse.acceleo.ForStatement;
import org.eclipse.acceleo.IfStatement;
import org.eclipse.acceleo.Import;
import org.eclipse.acceleo.LetStatement;
import org.eclipse.acceleo.Metamodel;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.ModuleElement;
import org.eclipse.acceleo.ModuleElementDocumentation;
import org.eclipse.acceleo.ModuleReference;
import org.eclipse.acceleo.ProtectedArea;
import org.eclipse.acceleo.Query;
import org.eclipse.acceleo.Statement;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.TextStatement;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.aql.AcceleoUtil;
import org.eclipse.acceleo.aql.parser.AcceleoAstResult;
import org.eclipse.acceleo.aql.parser.ModuleLoader;
import org.eclipse.acceleo.aql.validation.AcceleoValidationResult;
import org.eclipse.acceleo.aql.validation.IAcceleoValidationResult;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.parser.namespace.QualifiedNameAstValidator;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.ServiceRegistrationResult;
import org.eclipse.acceleo.query.runtime.ValidationMessageLevel;
import org.eclipse.acceleo.query.runtime.impl.ValidationMessage;
import org.eclipse.acceleo.query.runtime.impl.namespace.QualifiedNameValidationServices;
import org.eclipse.acceleo.query.runtime.lookup.basic.ServiceStore;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.ICollectionType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.util.AcceleoSwitch;

public class AcceleoValidator
extends AcceleoSwitch<Object> {
    public static final String DOESN_T_MATCH_RESOURCE_NAME = " doesn't match resource name ";
    public static final String INDEX_SUFFIX = "Index";
    private static final String IS_INCOMPATIBLE_WITH = " is incompatible with ";
    private static final String MISSING_NAME = "Missing name";
    private static final Object RETURN_VALUE = new Object();
    private final IQualifiedNameQueryEnvironment queryEnvironment;
    private final QualifiedNameAstValidator validator;
    private Deque<Map<String, Set<IType>>> variableTypesStack = new ArrayDeque<Map<String, Set<IType>>>();
    private boolean forceCollectionBinding;
    private AcceleoValidationResult result;
    private final IType stringType;
    private final IType booleanType;
    private final IType booleanObjectType;
    private final IType integerType;
    private final Map<String, List<VarRef>> unresolvedVarRefsMapping = new HashMap<String, List<VarRef>>();

    public AcceleoValidator(IQualifiedNameQueryEnvironment queryEnvironment) {
        this.queryEnvironment = queryEnvironment;
        this.stringType = new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, String.class);
        this.booleanType = new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Boolean.TYPE);
        this.booleanObjectType = new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Boolean.class);
        this.integerType = new ClassType((IReadOnlyQueryEnvironment)queryEnvironment, Integer.class);
        QualifiedNameValidationServices services = new QualifiedNameValidationServices(queryEnvironment);
        this.validator = new QualifiedNameAstValidator(services);
    }

    protected void pushVariableTypes(Map<String, Set<IType>> variableTypes) {
        this.variableTypesStack.addLast(variableTypes);
    }

    protected Map<String, Set<IType>> peekVariableTypes() {
        return this.variableTypesStack.peekLast();
    }

    protected Map<String, Set<IType>> popVariableTypes() {
        return this.variableTypesStack.removeLast();
    }

    private void addUnresolvedVarRef(IValidationResult validationResult) {
        for (VarRef unresolved : validationResult.getUnresolvedVarRef()) {
            this.unresolvedVarRefsMapping.computeIfAbsent(unresolved.getVariableName(), n -> new ArrayList()).add(unresolved);
        }
    }

    private void resolveVarRefVariable(Variable variable) {
        List<VarRef> unresolved = this.unresolvedVarRefsMapping.remove(variable.getName());
        if (unresolved != null) {
            for (VarRef varRef : unresolved) {
                this.result.putBindingResolvedVarRef(variable, varRef);
            }
        }
    }

    public IAcceleoValidationResult validate(AcceleoAstResult astResult, String moduleQualifiedName) {
        this.variableTypesStack = new ArrayDeque<Map<String, Set<IType>>>();
        this.pushVariableTypes(new HashMap<String, Set<IType>>());
        this.forceCollectionBinding = false;
        this.result = new AcceleoValidationResult(astResult);
        this.queryEnvironment.getLookupEngine().pushImportsContext(moduleQualifiedName, moduleQualifiedName);
        try {
            this.doSwitch(astResult.getModule());
        }
        finally {
            this.queryEnvironment.getLookupEngine().popContext(moduleQualifiedName);
        }
        return this.result;
    }

    protected void addMessage(AcceleoASTNode node, ValidationMessageLevel level, String messageString, int startPosition, int endPosition) {
        ValidationMessage message = new ValidationMessage(level, messageString, startPosition, endPosition);
        this.result.addMessage(node, (IValidationMessage)message);
    }

    @Override
    public Object caseModule(Module module) {
        this.checkName(module);
        this.checkMetamodels(module);
        if (module.getExtends() != null) {
            this.doSwitch(module.getExtends());
        }
        this.checkImports(module);
        this.checkDuplicatedServices(module);
        for (ModuleElement element : module.getModuleElements()) {
            this.doSwitch(element);
        }
        return RETURN_VALUE;
    }

    private void checkName(Module module) {
        String[] segments;
        if (module.getName() != null && module.eResource() != null && module.eResource().getURI() != null && (segments = module.eResource().getURI().toString().split("::")).length > 0) {
            String resourceName = segments[segments.length - 1];
            if (!module.getName().equals(resourceName)) {
                AcceleoAstResult acceleoAstResult = this.result.getAcceleoAstResult();
                this.addMessage(module, ValidationMessageLevel.ERROR, module.getName() + DOESN_T_MATCH_RESOURCE_NAME + resourceName, acceleoAstResult.getIdentifierStartPosition(module), acceleoAstResult.getIdentifierEndPosition(module));
            }
        }
    }

    private void checkImports(Module module) {
        HashSet<String> imports = new HashSet<String>();
        for (Import imp : module.getImports()) {
            this.doSwitch(imp);
            if (imp.getModule().getQualifiedName() == null) continue;
            AcceleoAstResult acceleoAstResult = this.result.getAcceleoAstResult();
            if (imports.add(imp.getModule().getQualifiedName())) continue;
            this.addMessage(module, ValidationMessageLevel.WARNING, imp.getModule().getQualifiedName() + " already imported", acceleoAstResult.getStartPosition(imp), acceleoAstResult.getEndPosition(imp));
        }
    }

    private void checkMetamodels(Module module) {
        HashSet<String> ePackages = new HashSet<String>();
        for (Metamodel metamodel : module.getMetamodels()) {
            AcceleoAstResult acceleoAstResult;
            this.doSwitch(metamodel);
            if (metamodel.getReferencedPackage() == null) continue;
            IQualifiedNameResolver resolver = this.queryEnvironment.getLookupEngine().getResolver();
            if (resolver.getEPackage(metamodel.getReferencedPackage()) == null) {
                acceleoAstResult = this.result.getAcceleoAstResult();
                this.addMessage(metamodel, ValidationMessageLevel.ERROR, "Invalid metamodel " + metamodel.getReferencedPackage(), acceleoAstResult.getStartPosition(metamodel), acceleoAstResult.getEndPosition(metamodel));
            }
            if (ePackages.add(metamodel.getReferencedPackage())) continue;
            acceleoAstResult = this.result.getAcceleoAstResult();
            this.addMessage(module, ValidationMessageLevel.WARNING, metamodel.getReferencedPackage() + " already referenced", acceleoAstResult.getStartPosition(metamodel), acceleoAstResult.getEndPosition(metamodel));
        }
    }

    private void checkDuplicatedServices(Module module) {
        ServiceStore serviceStore = new ServiceStore((IReadOnlyQueryEnvironment)this.queryEnvironment);
        ModuleLoader moduleLoader = new ModuleLoader(null, null);
        Set<IService<?>> services = moduleLoader.getServices(null, module, null);
        LinkedHashSet duplicatedServices = new LinkedHashSet();
        for (IService<?> service : services) {
            ServiceRegistrationResult registrationResult = serviceStore.add(service);
            for (List value : registrationResult.getDuplicated().values()) {
                duplicatedServices.addAll(value);
            }
            duplicatedServices.addAll(registrationResult.getDuplicated().keySet());
        }
        if (!duplicatedServices.isEmpty()) {
            AcceleoAstResult acceleoAstResult = this.result.getAcceleoAstResult();
            for (IService service : duplicatedServices) {
                ModuleElement origin = (ModuleElement)service.getOrigin();
                this.addMessage(origin, ValidationMessageLevel.ERROR, "Duplicated service signature", acceleoAstResult.getStartPosition(origin), acceleoAstResult.getEndPosition(origin));
            }
        }
    }

    @Override
    public Object caseModuleElementDocumentation(ModuleElementDocumentation moduleElementDocumentation) {
        return RETURN_VALUE;
    }

    @Override
    public Object caseComment(Comment comment) {
        return RETURN_VALUE;
    }

    @Override
    public Object caseErrorComment(ErrorComment errorComment) {
        if (errorComment.getMissingSpace() != -1) {
            String message = this.getMissingTokenMessage(" ");
            this.addMessage(errorComment, ValidationMessageLevel.ERROR, message, errorComment.getMissingSpace(), errorComment.getMissingSpace());
        } else if (errorComment.getMissingEndHeader() != -1) {
            String message = errorComment instanceof ErrorBlockComment ? this.getMissingTokenMessage("[/comment]") : this.getMissingTokenMessage("/]");
            this.addMessage(errorComment, ValidationMessageLevel.ERROR, message, errorComment.getMissingEndHeader(), errorComment.getMissingEndHeader());
        }
        return null;
    }

    @Override
    public Object caseErrorModule(ErrorModule errorModule) {
        if (errorModule.getMissingOpenParenthesis() != -1) {
            this.addMessage(errorModule, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("("), errorModule.getMissingOpenParenthesis(), errorModule.getMissingOpenParenthesis());
        } else if (errorModule.getMissingEPackage() != -1) {
            this.addMessage(errorModule, ValidationMessageLevel.ERROR, "Missing metamodel", errorModule.getMissingEPackage(), errorModule.getMissingEPackage());
        } else if (errorModule.getMissingCloseParenthesis() != -1) {
            this.addMessage(errorModule, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(")"), errorModule.getMissingCloseParenthesis(), errorModule.getMissingCloseParenthesis());
        } else if (errorModule.getMissingEndHeader() != -1) {
            this.addMessage(errorModule, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("/]"), errorModule.getMissingEndHeader(), errorModule.getMissingEndHeader());
        }
        return null;
    }

    @Override
    public Object caseMetamodel(Metamodel metamodel) {
        return RETURN_VALUE;
    }

    @Override
    public Object caseErrorMetamodel(ErrorMetamodel errorMetamodel) {
        IQualifiedNameResolver resolver = this.queryEnvironment.getLookupEngine().getResolver();
        if (resolver.getEPackage(errorMetamodel.getReferencedPackage()) == null) {
            AcceleoAstResult acceleoAstResult = this.result.getAcceleoAstResult();
            this.addMessage(errorMetamodel, ValidationMessageLevel.ERROR, "Invalid metamodel " + errorMetamodel.getReferencedPackage(), acceleoAstResult.getStartPosition(errorMetamodel), acceleoAstResult.getEndPosition(errorMetamodel));
        } else if (errorMetamodel.getMissingEndQuote() != -1) {
            this.addMessage(errorMetamodel, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("'"), errorMetamodel.getMissingEndQuote(), errorMetamodel.getMissingEndQuote());
        }
        return null;
    }

    @Override
    public Object caseImport(Import imp) {
        this.doSwitch(imp.getModule());
        return RETURN_VALUE;
    }

    @Override
    public Object caseErrorImport(ErrorImport errorImport) {
        this.doSwitch(errorImport.getModule());
        if (errorImport.getMissingEnd() != -1) {
            this.addMessage(errorImport, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("/]"), errorImport.getMissingEnd(), errorImport.getMissingEnd());
        }
        return null;
    }

    @Override
    public Object caseModuleReference(ModuleReference moduleReference) {
        if (moduleReference.getQualifiedName() != null && this.queryEnvironment.getLookupEngine().getResolver().resolve(moduleReference.getQualifiedName()) == null) {
            AcceleoAstResult acceleoAstResult = this.result.getAcceleoAstResult();
            this.addMessage(moduleReference, ValidationMessageLevel.ERROR, "Could not resolve " + moduleReference.getQualifiedName(), acceleoAstResult.getStartPosition(moduleReference), acceleoAstResult.getEndPosition(moduleReference));
        }
        return RETURN_VALUE;
    }

    @Override
    public Object caseBlock(Block block) {
        for (Statement statement : block.getStatements()) {
            this.doSwitch(statement);
        }
        return RETURN_VALUE;
    }

    @Override
    public Object caseTextStatement(TextStatement object) {
        return RETURN_VALUE;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object caseTemplate(Template template) {
        this.pushVariableTypes(new HashMap<String, Set<IType>>(this.peekVariableTypes()));
        try {
            parameterNames = new HashSet<String>();
            parameterTypes = new ArrayList<Set<IType>>();
            for (Variable parameter : template.getParameters()) {
                this.doSwitch(parameter);
                parameterTypes.add(this.peekVariableTypes().get(parameter.getName()));
                if (parameter.getName() == null || parameterNames.add(parameter.getName())) continue;
                acceleoAstResult = this.result.getAcceleoAstResult();
                this.addMessage(template, ValidationMessageLevel.ERROR, parameter.getName() + " duplicated parameter", acceleoAstResult.getStartPosition(parameter), acceleoAstResult.getEndPosition(parameter));
            }
            returnTypes = new LinkedHashSet<IType>();
            returnTypes.add((IType)new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, String.class));
            this.validateOverride(template, template.getName(), returnTypes, parameterTypes);
            if (template.getGuard() != null) {
                this.doSwitch(template.getGuard());
            }
            if (template.getPost() != null) {
                this.pushVariableTypes(new HashMap<String, Set<IType>>(this.peekVariableTypes()));
                possibleTypes = new LinkedHashSet<ClassType>();
                possibleTypes.add(new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, String.class));
                this.peekVariableTypes().put(AcceleoUtil.getTemplateImplicitVariableName(), possibleTypes);
                try {
                    this.doSwitch(template.getPost());
                }
                finally {
                    this.popVariableTypes();
                }
            }
            this.doSwitch(template.getBody());
        }
        finally {
            ** for (parameter : template.getParameters())
        }
lbl-1000:
        // 1 sources

        {
            this.resolveVarRefVariable(parameter);
            continue;
        }
lbl44:
        // 1 sources

        this.popVariableTypes();
        return AcceleoValidator.RETURN_VALUE;
    }

    protected void validateOverride(AcceleoASTNode node, String name, Set<IType> returnTypes, List<Set<IType>> parameterTypes) {
        String message = this.validator.validateOverrideReturnType(name, returnTypes, parameterTypes);
        if (message != null) {
            int startPosition = this.result.getAcceleoAstResult().getIdentifierStartPosition(node);
            int endPosition = this.result.getAcceleoAstResult().getIdentifierEndPosition(node);
            this.addMessage(node, ValidationMessageLevel.ERROR, message, startPosition, endPosition);
        }
    }

    @Override
    public Object caseErrorTemplate(ErrorTemplate errorTemplate) {
        if (errorTemplate.getMissingVisibility() != -1) {
            this.addMessage(errorTemplate, ValidationMessageLevel.ERROR, "Missing visibility", errorTemplate.getMissingVisibility(), errorTemplate.getMissingVisibility());
        } else if (errorTemplate.getMissingName() != -1) {
            this.addMessage(errorTemplate, ValidationMessageLevel.ERROR, MISSING_NAME, errorTemplate.getMissingName(), errorTemplate.getMissingName());
        } else if (errorTemplate.getMissingOpenParenthesis() != -1) {
            this.addMessage(errorTemplate, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("("), errorTemplate.getMissingOpenParenthesis(), errorTemplate.getMissingOpenParenthesis());
        } else if (errorTemplate.getMissingParameters() != -1) {
            this.addMessage(errorTemplate, ValidationMessageLevel.ERROR, "Missing parameter", errorTemplate.getMissingParameters(), errorTemplate.getMissingParameters());
        } else if (errorTemplate.getMissingCloseParenthesis() != -1) {
            this.addMessage(errorTemplate, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(")"), errorTemplate.getMissingCloseParenthesis(), errorTemplate.getMissingCloseParenthesis());
        } else if (errorTemplate.getMissingGuardOpenParenthesis() != -1) {
            this.addMessage(errorTemplate, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("("), errorTemplate.getMissingGuardOpenParenthesis(), errorTemplate.getMissingGuardOpenParenthesis());
        } else if (errorTemplate.getMissingGuardCloseParenthesis() != -1) {
            this.addMessage(errorTemplate, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(")"), errorTemplate.getMissingGuardCloseParenthesis(), errorTemplate.getMissingGuardCloseParenthesis());
        } else if (errorTemplate.getMissingPostCloseParenthesis() != -1) {
            this.addMessage(errorTemplate, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(")"), errorTemplate.getMissingPostCloseParenthesis(), errorTemplate.getMissingPostCloseParenthesis());
        } else if (errorTemplate.getMissingEndHeader() != -1) {
            this.addMessage(errorTemplate, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("]"), errorTemplate.getMissingEndHeader(), errorTemplate.getMissingEndHeader());
        } else if (errorTemplate.getMissingEnd() != -1) {
            this.addMessage(errorTemplate, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("[/template]"), errorTemplate.getMissingEnd(), errorTemplate.getMissingEnd());
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object caseQuery(Query query) {
        this.pushVariableTypes(new HashMap<String, Set<IType>>(this.peekVariableTypes()));
        try {
            parameterNames = new HashSet<String>();
            parameterTypes = new ArrayList<Set<IType>>();
            for (Variable parameter : query.getParameters()) {
                this.doSwitch(parameter);
                parameterTypes.add(this.peekVariableTypes().get(parameter.getName()));
                if (parameter.getName() == null || parameterNames.add(parameter.getName())) continue;
                acceleoAstResult = this.result.getAcceleoAstResult();
                this.addMessage(query, ValidationMessageLevel.ERROR, parameter.getName() + " duplicated parameter", acceleoAstResult.getStartPosition(parameter), acceleoAstResult.getEndPosition(parameter));
            }
            validationResult = (IValidationResult)this.doSwitch(query.getBody());
            possibleTypes = validationResult.getPossibleTypes(validationResult.getAstResult().getAst());
            if (query.getType() != null) {
                typeValidationResult = this.validator.validate(Collections.emptyMap(), query.getType());
                this.addUnresolvedVarRef(typeValidationResult);
                this.result.getAqlValidationResults().put(query.getType(), typeValidationResult);
                iTypes = this.validator.getDeclarationTypes((IReadOnlyQueryEnvironment)this.queryEnvironment, typeValidationResult.getPossibleTypes(query.getType().getAst()));
                this.checkTypesCompatibility(query, possibleTypes, iTypes);
                this.validateOverride(query, query.getName(), iTypes, parameterTypes);
            }
        }
        finally {
            var10_10 = query.getParameters().iterator();
            if (true) ** GOTO lbl34
        }
        {
        }
        do {
            parameter = (Variable)var10_10.next();
            this.resolveVarRefVariable(parameter);
lbl34:
            // 2 sources

        } while (var10_10.hasNext());
        this.popVariableTypes();
        return AcceleoValidator.RETURN_VALUE;
    }

    @Override
    public Object caseErrorQuery(ErrorQuery errorQuery) {
        if (errorQuery.getMissingVisibility() != -1) {
            this.addMessage(errorQuery, ValidationMessageLevel.ERROR, "Missing visibility", errorQuery.getMissingVisibility(), errorQuery.getMissingVisibility());
        } else if (errorQuery.getMissingName() != -1) {
            this.addMessage(errorQuery, ValidationMessageLevel.ERROR, MISSING_NAME, errorQuery.getMissingName(), errorQuery.getMissingName());
        } else if (errorQuery.getMissingOpenParenthesis() != -1) {
            this.addMessage(errorQuery, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("("), errorQuery.getMissingOpenParenthesis(), errorQuery.getMissingOpenParenthesis());
        } else if (errorQuery.getMissingParameters() != -1) {
            this.addMessage(errorQuery, ValidationMessageLevel.ERROR, "Missing parameter", errorQuery.getMissingParameters(), errorQuery.getMissingParameters());
        } else if (errorQuery.getMissingCloseParenthesis() != -1) {
            this.addMessage(errorQuery, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(")"), errorQuery.getMissingCloseParenthesis(), errorQuery.getMissingCloseParenthesis());
        } else if (errorQuery.getMissingColon() != -1) {
            this.addMessage(errorQuery, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(":"), errorQuery.getMissingColon(), errorQuery.getMissingColon());
        } else if (errorQuery.getMissingType() != -1) {
            this.addMessage(errorQuery, ValidationMessageLevel.ERROR, "Missing or invalid type", errorQuery.getMissingType(), errorQuery.getMissingType());
        } else if (errorQuery.getMissingEqual() != -1) {
            this.addMessage(errorQuery, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("="), errorQuery.getMissingEqual(), errorQuery.getMissingEqual());
        } else if (errorQuery.getMissingEnd() != -1) {
            this.addMessage(errorQuery, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("/]"), errorQuery.getMissingEnd(), errorQuery.getMissingEnd());
        }
        return null;
    }

    @Override
    public Object caseVariable(Variable variable) {
        if (this.peekVariableTypes().containsKey(variable.getName())) {
            AcceleoAstResult acceleoAstResult = this.result.getAcceleoAstResult();
            this.addMessage(variable, ValidationMessageLevel.WARNING, "Variable " + variable.getName() + " already exists.", acceleoAstResult.getStartPosition(variable), acceleoAstResult.getEndPosition(variable));
        }
        IValidationResult typeValidationResult = this.validator.validate(Collections.emptyMap(), variable.getType());
        this.addUnresolvedVarRef(typeValidationResult);
        this.result.getAqlValidationResults().put(variable.getType(), typeValidationResult);
        Set types = this.validator.getDeclarationTypes((IReadOnlyQueryEnvironment)this.queryEnvironment, typeValidationResult.getPossibleTypes(variable.getType().getAst()));
        this.peekVariableTypes().put(variable.getName(), types);
        return RETURN_VALUE;
    }

    @Override
    public Object caseErrorVariable(ErrorVariable errorVariable) {
        if (errorVariable.getMissingName() != -1) {
            this.addMessage(errorVariable, ValidationMessageLevel.ERROR, MISSING_NAME, errorVariable.getMissingName(), errorVariable.getMissingName());
        } else if (errorVariable.getMissingColon() != -1) {
            this.addMessage(errorVariable, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(":"), errorVariable.getMissingColon(), errorVariable.getMissingColon());
        } else if (errorVariable.getMissingType() != -1) {
            this.addMessage(errorVariable, ValidationMessageLevel.ERROR, "Missing or invalid type", errorVariable.getMissingType(), errorVariable.getMissingType());
        }
        return null;
    }

    @Override
    public Object caseBinding(Binding binding) {
        if (this.peekVariableTypes().containsKey(binding.getName())) {
            AcceleoAstResult acceleoAstResult = this.result.getAcceleoAstResult();
            this.addMessage(binding, ValidationMessageLevel.WARNING, "Variable " + binding.getName() + " already exists.", acceleoAstResult.getStartPosition(binding), acceleoAstResult.getEndPosition(binding));
        }
        IValidationResult validationResult = (IValidationResult)this.doSwitch(binding.getInitExpression());
        Set possibleTypes = validationResult.getPossibleTypes(validationResult.getAstResult().getAst());
        if (binding.getType() != null) {
            IValidationResult typeValidationResult = this.validator.validate(Collections.emptyMap(), binding.getType());
            this.result.getAqlValidationResults().put(binding.getType(), typeValidationResult);
            Set iTypes = this.validator.getDeclarationTypes((IReadOnlyQueryEnvironment)this.queryEnvironment, typeValidationResult.getPossibleTypes(binding.getType().getAst()));
            this.checkTypesCompatibility(binding, possibleTypes, iTypes);
        }
        LinkedHashSet<IType> variableTypes = new LinkedHashSet<IType>();
        if (this.forceCollectionBinding) {
            for (IType possibleType : possibleTypes) {
                if (possibleType instanceof ICollectionType) {
                    variableTypes.add(((ICollectionType)possibleType).getCollectionType());
                    continue;
                }
                variableTypes.add(possibleType);
            }
            LinkedHashSet<IType> indexTypes = new LinkedHashSet<IType>();
            indexTypes.add(this.integerType);
            this.peekVariableTypes().put(binding.getName() + INDEX_SUFFIX, indexTypes);
        } else {
            variableTypes.addAll(possibleTypes);
        }
        this.peekVariableTypes().put(binding.getName(), variableTypes);
        return RETURN_VALUE;
    }

    protected void checkTypesCompatibility(AcceleoASTNode node, Set<IType> possibleTypes, Set<IType> declaredTypes) {
        for (IType possibleType : possibleTypes) {
            ArrayList<IValidationMessage> messages = new ArrayList<IValidationMessage>();
            boolean hasCompatibleType = false;
            for (IType iType : declaredTypes) {
                if (!iType.isAssignableFrom(possibleType)) {
                    if (this.forceCollectionBinding) {
                        messages.addAll(this.validateBindingTypeForceCollection(node, iType, possibleType));
                        continue;
                    }
                    AcceleoAstResult acceleoAstResult = this.result.getAcceleoAstResult();
                    messages.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.WARNING, String.valueOf(iType) + IS_INCOMPATIBLE_WITH + String.valueOf(possibleType), acceleoAstResult.getStartPosition(node), acceleoAstResult.getEndPosition(node)));
                    continue;
                }
                hasCompatibleType = true;
            }
            if (hasCompatibleType) continue;
            this.result.addMessages(node, messages);
        }
    }

    protected List<IValidationMessage> validateBindingTypeForceCollection(AcceleoASTNode node, IType iType, IType possibleType) {
        ArrayList<IValidationMessage> res = new ArrayList<IValidationMessage>();
        if (possibleType instanceof ICollectionType) {
            if (!iType.isAssignableFrom(((ICollectionType)possibleType).getCollectionType())) {
                AcceleoAstResult acceleoAstResult = this.result.getAcceleoAstResult();
                res.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.WARNING, String.valueOf(iType) + IS_INCOMPATIBLE_WITH + String.valueOf(possibleType), acceleoAstResult.getStartPosition(node), acceleoAstResult.getEndPosition(node)));
            }
        } else if (!iType.isAssignableFrom(possibleType)) {
            AcceleoAstResult acceleoAstResult = this.result.getAcceleoAstResult();
            res.add((IValidationMessage)new ValidationMessage(ValidationMessageLevel.WARNING, String.valueOf(iType) + IS_INCOMPATIBLE_WITH + String.valueOf(possibleType), acceleoAstResult.getStartPosition(node), acceleoAstResult.getEndPosition(node)));
        }
        return res;
    }

    @Override
    public Object caseErrorBinding(ErrorBinding errorBinding) {
        if (errorBinding.getMissingName() != -1) {
            this.addMessage(errorBinding, ValidationMessageLevel.ERROR, MISSING_NAME, errorBinding.getMissingName(), errorBinding.getMissingName());
        } else if (errorBinding.getMissingColon() != -1) {
            this.addMessage(errorBinding, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(":"), errorBinding.getMissingColon(), errorBinding.getMissingColon());
        } else if (errorBinding.getMissingType() != -1) {
            this.addMessage(errorBinding, ValidationMessageLevel.ERROR, "Missing type literal", errorBinding.getMissingType(), errorBinding.getMissingType());
        } else if (errorBinding.getMissingAffectationSymbolePosition() != -1) {
            this.addMessage(errorBinding, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(errorBinding.getMissingAffectationSymbole()), errorBinding.getMissingAffectationSymbolePosition(), errorBinding.getMissingAffectationSymbolePosition());
        }
        return null;
    }

    @Override
    public Object caseExpressionStatement(ExpressionStatement expressionStatement) {
        this.doSwitch(expressionStatement.getExpression());
        return RETURN_VALUE;
    }

    @Override
    public Object caseErrorExpressionStatement(ErrorExpressionStatement errorExpressionStatement) {
        this.doSwitch(errorExpressionStatement.getExpression());
        if (errorExpressionStatement.getMissingEndHeader() != -1) {
            this.addMessage(errorExpressionStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("/]"), errorExpressionStatement.getMissingEndHeader(), errorExpressionStatement.getMissingEndHeader());
        }
        return null;
    }

    @Override
    public Object caseProtectedArea(ProtectedArea protectedArea) {
        IValidationResult idValidationResult = (IValidationResult)this.doSwitch(protectedArea.getId());
        Set idPossibleTypes = idValidationResult.getPossibleTypes(idValidationResult.getAstResult().getAst());
        this.checkStringType(protectedArea.getId(), idPossibleTypes);
        if (protectedArea.getStartTagPrefix() != null) {
            IValidationResult startTagPrefixValidationResult = (IValidationResult)this.doSwitch(protectedArea.getStartTagPrefix());
            Set startTagPrefixPossibleTypes = startTagPrefixValidationResult.getPossibleTypes(startTagPrefixValidationResult.getAstResult().getAst());
            this.checkStringType(protectedArea.getStartTagPrefix(), startTagPrefixPossibleTypes);
        }
        if (protectedArea.getEndTagPrefix() != null) {
            IValidationResult endTagPrefixValidationResult = (IValidationResult)this.doSwitch(protectedArea.getEndTagPrefix());
            Set endTagPrefixPossibleTypes = endTagPrefixValidationResult.getPossibleTypes(endTagPrefixValidationResult.getAstResult().getAst());
            this.checkStringType(protectedArea.getEndTagPrefix(), endTagPrefixPossibleTypes);
        }
        this.doSwitch(protectedArea.getBody());
        return RETURN_VALUE;
    }

    @Override
    public Object caseErrorProtectedArea(ErrorProtectedArea errorProtectedArea) {
        if (errorProtectedArea.getMissingOpenParenthesis() != -1) {
            this.addMessage(errorProtectedArea, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("("), errorProtectedArea.getMissingOpenParenthesis(), errorProtectedArea.getMissingOpenParenthesis());
        } else if (errorProtectedArea.getMissingStartTagPrefixCloseParenthesis() != -1) {
            this.addMessage(errorProtectedArea, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(")"), errorProtectedArea.getMissingStartTagPrefixCloseParenthesis(), errorProtectedArea.getMissingStartTagPrefixCloseParenthesis());
        } else if (errorProtectedArea.getMissingEndTagPrefixCloseParenthesis() != -1) {
            this.addMessage(errorProtectedArea, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(")"), errorProtectedArea.getMissingEndTagPrefixCloseParenthesis(), errorProtectedArea.getMissingEndTagPrefixCloseParenthesis());
        } else if (errorProtectedArea.getMissingCloseParenthesis() != -1) {
            this.addMessage(errorProtectedArea, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(")"), errorProtectedArea.getMissingCloseParenthesis(), errorProtectedArea.getMissingCloseParenthesis());
        } else if (errorProtectedArea.getMissingEndHeader() != -1) {
            this.addMessage(errorProtectedArea, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("]"), errorProtectedArea.getMissingEndHeader(), errorProtectedArea.getMissingEndHeader());
        } else if (errorProtectedArea.getMissingEnd() != -1) {
            this.addMessage(errorProtectedArea, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("[/protected]"), errorProtectedArea.getMissingEnd(), errorProtectedArea.getMissingEnd());
        }
        return null;
    }

    @Override
    public Object caseExpression(Expression expression) {
        IValidationResult res = this.validator.validate(this.peekVariableTypes(), expression.getAst());
        this.addUnresolvedVarRef(res);
        this.result.getAqlValidationResults().put(expression.getAst(), res);
        AcceleoAstResult acceleoAstResult = this.result.getAcceleoAstResult();
        this.result.addMessages(expression, this.shiftMessages(res.getMessages(), acceleoAstResult.getStartPosition(expression)));
        return res;
    }

    @Override
    public Object caseForStatement(ForStatement forStatement) {
        this.pushVariableTypes(new HashMap<String, Set<IType>>(this.peekVariableTypes()));
        try {
            if (forStatement.getBinding() != null) {
                this.forceCollectionBinding = true;
                try {
                    this.doSwitch(forStatement.getBinding());
                }
                finally {
                    this.forceCollectionBinding = false;
                }
            }
            if (forStatement.getSeparator() != null) {
                this.doSwitch(forStatement.getSeparator());
            }
            this.doSwitch(forStatement.getBody());
        }
        finally {
            if (forStatement.getBinding() != null) {
                this.resolveVarRefVariable(forStatement.getBinding());
            }
            this.popVariableTypes();
        }
        return RETURN_VALUE;
    }

    @Override
    public Object caseErrorForStatement(ErrorForStatement errorForStatement) {
        if (errorForStatement.getMissingOpenParenthesis() != -1) {
            this.addMessage(errorForStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("("), errorForStatement.getMissingOpenParenthesis(), errorForStatement.getMissingOpenParenthesis());
        } else if (errorForStatement.getMissingBinding() != -1) {
            this.addMessage(errorForStatement, ValidationMessageLevel.ERROR, "Missing binding", errorForStatement.getMissingBinding(), errorForStatement.getMissingBinding());
        } else if (errorForStatement.getMissingCloseParenthesis() != -1) {
            this.addMessage(errorForStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(")"), errorForStatement.getMissingCloseParenthesis(), errorForStatement.getMissingCloseParenthesis());
        } else if (errorForStatement.getMissingSeparatorCloseParenthesis() != -1) {
            this.addMessage(errorForStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(")"), errorForStatement.getMissingSeparatorCloseParenthesis(), errorForStatement.getMissingSeparatorCloseParenthesis());
        } else if (errorForStatement.getMissingEndHeader() != -1) {
            this.addMessage(errorForStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("]"), errorForStatement.getMissingEndHeader(), errorForStatement.getMissingEndHeader());
        } else if (errorForStatement.getMissingEnd() != -1) {
            this.addMessage(errorForStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("[/for]"), errorForStatement.getMissingEnd(), errorForStatement.getMissingEnd());
        }
        return null;
    }

    @Override
    public Object caseIfStatement(IfStatement ifStatement) {
        IValidationResult conditionValidationResult = (IValidationResult)this.doSwitch(ifStatement.getCondition());
        Set conditionPossibleTypes = conditionValidationResult.getPossibleTypes(ifStatement.getCondition().getAst().getAst());
        this.checkBooleanType(ifStatement.getCondition(), conditionPossibleTypes);
        HashMap<String, Set<IType>> thenTypes = new HashMap<String, Set<IType>>(this.peekVariableTypes());
        thenTypes.putAll(conditionValidationResult.getInferredVariableTypes(ifStatement.getCondition().getAst().getAst(), Boolean.TRUE));
        this.pushVariableTypes(thenTypes);
        try {
            this.doSwitch(ifStatement.getThen());
        }
        finally {
            this.popVariableTypes();
        }
        if (ifStatement.getElse() != null) {
            HashMap<String, Set<IType>> elseTypes = new HashMap<String, Set<IType>>(this.peekVariableTypes());
            elseTypes.putAll(conditionValidationResult.getInferredVariableTypes(ifStatement.getCondition().getAst().getAst(), Boolean.FALSE));
            this.pushVariableTypes(elseTypes);
            try {
                this.doSwitch(ifStatement.getElse());
            }
            finally {
                this.popVariableTypes();
            }
        }
        return RETURN_VALUE;
    }

    private void checkBooleanType(AcceleoASTNode node, Set<IType> possibleTypes) {
        if (!possibleTypes.isEmpty()) {
            boolean onlyBoolean = true;
            boolean onlyNotBoolean = true;
            for (IType type : possibleTypes) {
                boolean assignableFrom = this.booleanObjectType.isAssignableFrom(type) || this.booleanType.isAssignableFrom(type);
                onlyBoolean = onlyBoolean && assignableFrom;
                boolean bl = onlyNotBoolean = onlyNotBoolean && !assignableFrom;
                if (!onlyBoolean && !onlyNotBoolean) break;
            }
            if (!onlyBoolean) {
                if (onlyNotBoolean) {
                    message = String.format("The predicate never evaluates to a boolean type (%s).", possibleTypes);
                    acceleoAstResult = this.result.getAcceleoAstResult();
                    this.addMessage(node, ValidationMessageLevel.ERROR, message, acceleoAstResult.getStartPosition(node), acceleoAstResult.getEndPosition(node));
                } else {
                    message = String.format("The predicate may evaluate to a value that is not a boolean type (%s).", possibleTypes);
                    acceleoAstResult = this.result.getAcceleoAstResult();
                    this.addMessage(node, ValidationMessageLevel.WARNING, message, acceleoAstResult.getStartPosition(node), acceleoAstResult.getEndPosition(node));
                }
            }
        } else {
            String message = String.format("The predicate never evaluates to a boolean type (%s).", possibleTypes);
            AcceleoAstResult acceleoAstResult = this.result.getAcceleoAstResult();
            this.addMessage(node, ValidationMessageLevel.ERROR, message, acceleoAstResult.getStartPosition(node), acceleoAstResult.getEndPosition(node));
        }
    }

    @Override
    public Object caseErrorIfStatement(ErrorIfStatement errorIfStatement) {
        if (errorIfStatement.getMissingSpace() != -1) {
            this.addMessage(errorIfStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(" "), errorIfStatement.getMissingSpace(), errorIfStatement.getMissingSpace());
        } else if (errorIfStatement.getMissingOpenParenthesis() != -1) {
            this.addMessage(errorIfStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("("), errorIfStatement.getMissingOpenParenthesis(), errorIfStatement.getMissingOpenParenthesis());
        } else if (errorIfStatement.getMissingCloseParenthesis() != -1) {
            this.addMessage(errorIfStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(")"), errorIfStatement.getMissingCloseParenthesis(), errorIfStatement.getMissingCloseParenthesis());
        } else if (errorIfStatement.getMissingEndHeader() != -1) {
            this.addMessage(errorIfStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("]"), errorIfStatement.getMissingEndHeader(), errorIfStatement.getMissingEndHeader());
        } else if (errorIfStatement.getMissingEnd() != -1) {
            this.addMessage(errorIfStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("[/if]"), errorIfStatement.getMissingEnd(), errorIfStatement.getMissingEnd());
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object caseLetStatement(LetStatement letStatement) {
        this.pushVariableTypes(new HashMap<String, Set<IType>>(this.peekVariableTypes()));
        try {
            for (Binding binding : letStatement.getVariables()) {
                this.doSwitch(binding);
            }
            this.doSwitch(letStatement.getBody());
        }
        finally {
            ** for (binding : letStatement.getVariables())
        }
lbl-1000:
        // 1 sources

        {
            this.resolveVarRefVariable(binding);
            continue;
        }
lbl14:
        // 1 sources

        this.popVariableTypes();
        return AcceleoValidator.RETURN_VALUE;
    }

    @Override
    public Object caseErrorLetStatement(ErrorLetStatement errorLetStatement) {
        if (errorLetStatement.getMissingBindings() != -1) {
            this.addMessage(errorLetStatement, ValidationMessageLevel.WARNING, "Missing binding", errorLetStatement.getMissingBindings(), errorLetStatement.getMissingBindings());
        } else if (errorLetStatement.getMissingEndHeader() != -1) {
            this.addMessage(errorLetStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("]"), errorLetStatement.getMissingEndHeader(), errorLetStatement.getMissingEndHeader());
        } else if (errorLetStatement.getMissingEnd() != -1) {
            this.addMessage(errorLetStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("[/let]"), errorLetStatement.getMissingEnd(), errorLetStatement.getMissingEnd());
        }
        return null;
    }

    @Override
    public Object caseFileStatement(FileStatement fileStatement) {
        IValidationResult urlValidationResult = (IValidationResult)this.doSwitch(fileStatement.getUrl());
        Set urlPossibleTypes = urlValidationResult.getPossibleTypes(urlValidationResult.getAstResult().getAst());
        this.checkStringType(fileStatement.getUrl(), urlPossibleTypes);
        if (fileStatement.getCharset() != null) {
            IValidationResult charsetValidationResult = (IValidationResult)this.doSwitch(fileStatement.getCharset());
            Set charsetPossibleTypes = charsetValidationResult.getPossibleTypes(charsetValidationResult.getAstResult().getAst());
            this.checkStringType(fileStatement.getCharset(), charsetPossibleTypes);
        }
        this.doSwitch(fileStatement.getBody());
        return RETURN_VALUE;
    }

    @Override
    public Object caseErrorMargin(ErrorMargin errorMargin) {
        AcceleoAstResult acceleoAstResult = this.result.getAcceleoAstResult();
        this.addMessage(errorMargin, ValidationMessageLevel.ERROR, "Missing indentation before: " + errorMargin.getValue(), acceleoAstResult.getStartPosition(errorMargin), acceleoAstResult.getEndPosition(errorMargin));
        return RETURN_VALUE;
    }

    private void checkStringType(AcceleoASTNode node, Set<IType> possibleTypes) {
        if (!possibleTypes.isEmpty()) {
            boolean onlyString = true;
            boolean onlyNotString = true;
            for (IType type : possibleTypes) {
                boolean assignableFrom = this.stringType.isAssignableFrom(type);
                onlyString = onlyString && assignableFrom;
                boolean bl = onlyNotString = onlyNotString && !assignableFrom;
                if (!onlyString && !onlyNotString) break;
            }
            if (!onlyString) {
                if (onlyNotString) {
                    message = String.format("The expression never evaluates to a String type (%s).", possibleTypes);
                    acceleoAstResult = this.result.getAcceleoAstResult();
                    this.addMessage(node, ValidationMessageLevel.WARNING, message, acceleoAstResult.getStartPosition(node), acceleoAstResult.getEndPosition(node));
                } else {
                    message = String.format("The expression may evaluate to a value that is not a String type (%s).\"", possibleTypes);
                    acceleoAstResult = this.result.getAcceleoAstResult();
                    this.addMessage(node, ValidationMessageLevel.WARNING, message, acceleoAstResult.getStartPosition(node), acceleoAstResult.getEndPosition(node));
                }
            }
        } else {
            String message = String.format("The expression never evaluates to a String type (%s).", possibleTypes);
            AcceleoAstResult acceleoAstResult = this.result.getAcceleoAstResult();
            this.addMessage(node, ValidationMessageLevel.ERROR, message, acceleoAstResult.getStartPosition(node), acceleoAstResult.getEndPosition(node));
        }
    }

    @Override
    public Object caseErrorFileStatement(ErrorFileStatement errorFileStatement) {
        if (errorFileStatement.getMissingOpenParenthesis() != -1) {
            this.addMessage(errorFileStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("("), errorFileStatement.getMissingOpenParenthesis(), errorFileStatement.getMissingOpenParenthesis());
        } else if (errorFileStatement.getMissingComma() != -1) {
            this.addMessage(errorFileStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(","), errorFileStatement.getMissingComma(), errorFileStatement.getMissingComma());
        } else if (errorFileStatement.getMissingOpenMode() != -1) {
            this.addMessage(errorFileStatement, ValidationMessageLevel.ERROR, "Missing or invalid file open mode: overwrite, append, create", errorFileStatement.getMissingOpenMode(), errorFileStatement.getMissingOpenMode());
        } else if (errorFileStatement.getMissingCloseParenthesis() != -1) {
            this.addMessage(errorFileStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage(")"), errorFileStatement.getMissingCloseParenthesis(), errorFileStatement.getMissingCloseParenthesis());
        } else if (errorFileStatement.getMissingEndHeader() != -1) {
            this.addMessage(errorFileStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("]"), errorFileStatement.getMissingEndHeader(), errorFileStatement.getMissingEndHeader());
        } else if (errorFileStatement.getMissingEnd() != -1) {
            this.addMessage(errorFileStatement, ValidationMessageLevel.ERROR, this.getMissingTokenMessage("[/file]"), errorFileStatement.getMissingEnd(), errorFileStatement.getMissingEnd());
        }
        return null;
    }

    private List<IValidationMessage> shiftMessages(List<IValidationMessage> messages, int offset) {
        ArrayList<IValidationMessage> res = new ArrayList<IValidationMessage>(messages.size());
        for (IValidationMessage message : messages) {
            int newStartPosition = message.getStartPosition() + offset;
            int newEndPosition = message.getEndPosition() + offset;
            res.add((IValidationMessage)new ValidationMessage(message.getLevel(), message.getMessage(), newStartPosition, newEndPosition));
        }
        return res;
    }

    protected String getMissingTokenMessage(String token) {
        return "Missing \"" + token + "\"";
    }
}

