/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ide.ui.wizard;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.acceleo.aql.ide.ui.AcceleoUIPlugin;
import org.eclipse.acceleo.aql.ide.ui.GenerationCompareEditorInput;
import org.eclipse.acceleo.aql.ide.ui.module.main.MavenGenerationPomGenerator;
import org.eclipse.acceleo.aql.ide.ui.module.main.StandaloneGenerator;
import org.eclipse.acceleo.aql.ide.ui.wizard.GenerationPomConfiguration;
import org.eclipse.acceleo.aql.ide.ui.wizard.GenerationPomConfigurationPage;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MavenGenerationPomWizard
extends Wizard
implements INewWizard {
    private static final String OK_MESSAGE = "Maven generation POM %s created.";
    private IFile moduleFile;
    private GenerationPomConfiguration configuration;
    private GenerationPomConfigurationPage modulePage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (selection.getFirstElement() instanceof IFile) {
            this.moduleFile = (IFile)selection.getFirstElement();
            this.configuration = this.initializeGenerationPomConfiguration(this.moduleFile);
        }
    }

    private GenerationPomConfiguration initializeGenerationPomConfiguration(IFile moduleFile) {
        GenerationPomConfiguration res = new GenerationPomConfiguration();
        IFile pomFile = moduleFile.getProject().getFile("pom.xml");
        if (pomFile.isAccessible()) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document pom = db.parse(pomFile.getLocation().toFile());
                NodeList projectList = pom.getElementsByTagName("project");
                if (projectList != null && projectList.getLength() > 0) {
                    NodeList versionList;
                    NodeList artifactIdList;
                    Element project = (Element)projectList.item(0);
                    NodeList groupIdList = project.getElementsByTagName("groupId");
                    if (groupIdList != null && groupIdList.getLength() > 0) {
                        Element groupId = (Element)groupIdList.item(0);
                        res.setGeneratorGroupId(groupId.getTextContent());
                        res.setGenerationGroupId(groupId.getTextContent());
                    }
                    if ((artifactIdList = project.getElementsByTagName("artifactId")) != null && artifactIdList.getLength() > 0) {
                        Element artifactId = (Element)artifactIdList.item(0);
                        res.setGeneratorArtifactId(artifactId.getTextContent());
                        res.setGenerationArtifactId(artifactId.getTextContent() + "-generation");
                    }
                    if ((versionList = project.getElementsByTagName("version")) != null && versionList.getLength() > 0) {
                        Element version = (Element)versionList.item(0);
                        res.setGeneratorVersion(version.getTextContent());
                        res.setGenerationVersion(version.getTextContent());
                    }
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                AcceleoUIPlugin.getDefault().getLog().log((IStatus)new Status(2, ((Object)((Object)this)).getClass(), "Couldn't initialize Maven generation POM configuration from " + String.valueOf(moduleFile.getFullPath()), (Throwable)e));
            }
        }
        return res;
    }

    public void addPages() {
        this.modulePage = new GenerationPomConfigurationPage(this.configuration);
        this.addPage((IWizardPage)this.modulePage);
    }

    public boolean performFinish() {
        FinishJob job = new FinishJob(this.configuration);
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
        try {
            job.join();
            GenerationCompareEditorInput compareEditorInput = new GenerationCompareEditorInput(new CompareConfiguration(), job.getPreview(), (IContainer)ResourcesPlugin.getWorkspace().getRoot());
            if (compareEditorInput.hasDifferences()) {
                CompareUI.openCompareDialog((CompareEditorInput)compareEditorInput);
            }
        }
        catch (InterruptedException e) {
            AcceleoUIPlugin.getDefault().getLog().log((IStatus)new Status(4, ((Object)((Object)this)).getClass(), "Couldn't generate.", (Throwable)e));
        }
        return true;
    }

    public GenerationPomConfiguration getConfiguration() {
        return this.configuration;
    }

    private class FinishJob
    extends Job {
        private GenerationPomConfiguration pomConfiguration;
        private final Map<URI, String> preview;

        public FinishJob(GenerationPomConfiguration pomConfiguration) {
            super("Creating Maven generation POM file: " + String.valueOf(pomConfiguration.getPomFolderURI()));
            this.preview = new HashMap<URI, String>();
            this.pomConfiguration = pomConfiguration;
        }

        protected IStatus run(IProgressMonitor monitor) {
            Status res = new Status(0, "org.eclipse.acceleo.aql.ide.ui", String.format(MavenGenerationPomWizard.OK_MESSAGE, this.pomConfiguration.getPomFolderURI()));
            int amountOfWork = 2;
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            Monitor childMonitor = BasicMonitor.toMonitor((IProgressMonitorWithBlocking)subMonitor.split(1));
            try {
                StandaloneGenerator standaloneGenerator = new StandaloneGenerator(MavenGenerationPomWizard.this.moduleFile);
                standaloneGenerator.generate(childMonitor);
                this.preview.putAll(standaloneGenerator.getPreview());
            }
            finally {
                childMonitor.done();
            }
            if (!monitor.isCanceled()) {
                childMonitor = BasicMonitor.toMonitor((IProgressMonitorWithBlocking)subMonitor.split(1));
                try {
                    MavenGenerationPomGenerator generationPomGenerator = new MavenGenerationPomGenerator(MavenGenerationPomWizard.this.moduleFile, MavenGenerationPomWizard.this.configuration);
                    generationPomGenerator.generate(childMonitor);
                    this.preview.putAll(generationPomGenerator.getPreview());
                }
                finally {
                    childMonitor.done();
                }
            }
            return res;
        }

        public Map<URI, String> getPreview() {
            return this.preview;
        }
    }
}

