/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ide.ui.wizard;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.acceleo.aql.ide.ui.AcceleoUIPlugin;
import org.eclipse.acceleo.aql.ide.ui.dialog.FolderSelectionDialog;
import org.eclipse.acceleo.aql.ide.ui.message.AcceleoUIMessages;
import org.eclipse.acceleo.aql.ide.ui.wizard.GenerationPomConfiguration;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GenerationPomConfigurationPage
extends WizardPage {
    protected static final String WORKSPACE = "Workspace...";
    protected static final String FILE_SYSTEM = "File system...";
    private final GenerationPomConfiguration pomConfiguration;
    private Text generationPomDestinationText;
    private Text generatorGroupIdText;
    private Text generatorArtifactIdText;
    private Text generatorVersionText;
    private Text generationInputModelText;
    private Text generationTargetFolderText;
    private Text generationGroupIdText;
    private Text generationArtifactIdText;
    private Text generationVersionText;
    private boolean targetPomExists;

    public GenerationPomConfigurationPage(GenerationPomConfiguration pomConfiguration) {
        super("Generation Pom File");
        this.pomConfiguration = pomConfiguration;
    }

    public GenerationPomConfiguration getPomConfiguration() {
        return this.pomConfiguration;
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, parent.getStyle());
        control.setLayout((Layout)new GridLayout(1, false));
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        this.generationPomDestinationText = this.createPomDestinationComposite(control);
        this.generationInputModelText = this.createModelComposite(control);
        this.generationTargetFolderText = this.createGenerationTargetFolderComposite(control);
        this.createGenerationComposite(control);
        this.createGeneratorComposite(control);
        this.setControl((Control)control);
        this.reloadTargetPom(this.pomConfiguration);
        this.checkErrors();
    }

    private Text createModelComposite(Composite parent) {
        Group group = new Group(parent, parent.getStyle());
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group.setText("Generation model file:");
        final Text res = new Text((Composite)group, 2048);
        if (this.pomConfiguration.getGenerationModelPath() != null) {
            res.setText(this.pomConfiguration.getGenerationModelPath());
        }
        res.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        res.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GenerationPomConfigurationPage.this.pomConfiguration.setGenerationModelPath(res.getText());
                GenerationPomConfigurationPage.this.checkErrors();
            }
        });
        Button workspaceButton = this.createPushButton((Composite)group, WORKSPACE, null);
        workspaceButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GenerationPomConfigurationPage.this.handleWorkspaceModelButton();
            }
        });
        Button fileSystemButton = this.createPushButton((Composite)group, FILE_SYSTEM, null);
        fileSystemButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GenerationPomConfigurationPage.this.handleFileSystemModelButton();
            }
        });
        return res;
    }

    private Text createGenerationTargetFolderComposite(Composite parent) {
        Group group = new Group(parent, parent.getStyle());
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group.setText("Generation target folder:");
        final Text res = new Text((Composite)group, 2048);
        if (this.pomConfiguration.getGenerationTargetPath() != null) {
            res.setText(this.pomConfiguration.getGenerationTargetPath());
        }
        res.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        res.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GenerationPomConfigurationPage.this.pomConfiguration.setGenerationTargetPath(res.getText());
                GenerationPomConfigurationPage.this.checkErrors();
            }
        });
        Button workspaceButton = this.createPushButton((Composite)group, WORKSPACE, null);
        workspaceButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GenerationPomConfigurationPage.this.handleWorkspaceGenerationTargetFolderButton();
            }
        });
        Button fileSystemButton = this.createPushButton((Composite)group, FILE_SYSTEM, null);
        fileSystemButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GenerationPomConfigurationPage.this.handleFileSystemGenerationTargetFolderButton();
            }
        });
        return res;
    }

    private Text createPomDestinationComposite(Composite parent) {
        Group group = new Group(parent, parent.getStyle());
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group.setText("Pom Destination folder:");
        final Text res = new Text((Composite)group, 2048);
        if (this.pomConfiguration.getPomFolder() != null) {
            res.setText(this.pomConfiguration.getPomFolder());
        }
        res.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        res.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GenerationPomConfigurationPage.this.pomConfiguration.setPomFolder(res.getText());
                GenerationPomConfigurationPage.this.reloadTargetPom(GenerationPomConfigurationPage.this.pomConfiguration);
                GenerationPomConfigurationPage.this.checkErrors();
            }
        });
        Button workspaceButton = this.createPushButton((Composite)group, WORKSPACE, null);
        workspaceButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GenerationPomConfigurationPage.this.handleWorkspaceDestinationButton();
            }
        });
        Button fileSystemButton = this.createPushButton((Composite)group, FILE_SYSTEM, null);
        fileSystemButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                GenerationPomConfigurationPage.this.handleFileSystemDestinationButton();
            }
        });
        return res;
    }

    private void createGenerationComposite(Composite parent) {
        Group group = new Group(parent, parent.getStyle());
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group.setText("Generation:");
        Label groupIdLabel = new Label((Composite)group, 0);
        groupIdLabel.setText("groupId:");
        this.generationGroupIdText = new Text((Composite)group, 2048);
        if (this.pomConfiguration.getGenerationGroupId() != null) {
            this.generationGroupIdText.setText(this.pomConfiguration.getGenerationGroupId());
        }
        this.generationGroupIdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.generationGroupIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GenerationPomConfigurationPage.this.pomConfiguration.setGenerationGroupId(GenerationPomConfigurationPage.this.generationGroupIdText.getText());
                GenerationPomConfigurationPage.this.checkErrors();
            }
        });
        Label artifactIdLabel = new Label((Composite)group, 0);
        artifactIdLabel.setText("artifactId:");
        this.generationArtifactIdText = new Text((Composite)group, 2048);
        if (this.pomConfiguration.getGenerationArtifactId() != null) {
            this.generationArtifactIdText.setText(this.pomConfiguration.getGenerationArtifactId());
        }
        this.generationArtifactIdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.generationArtifactIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GenerationPomConfigurationPage.this.pomConfiguration.setGenerationArtifactId(GenerationPomConfigurationPage.this.generationArtifactIdText.getText());
                GenerationPomConfigurationPage.this.checkErrors();
            }
        });
        Label versionLabel = new Label((Composite)group, 0);
        versionLabel.setText("version:");
        this.generationVersionText = new Text((Composite)group, 2048);
        if (this.pomConfiguration.getGenerationVersion() != null) {
            this.generationVersionText.setText(this.pomConfiguration.getGenerationVersion());
        }
        this.generationVersionText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.generationVersionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GenerationPomConfigurationPage.this.pomConfiguration.setGenerationVersion(GenerationPomConfigurationPage.this.generationVersionText.getText());
                GenerationPomConfigurationPage.this.checkErrors();
            }
        });
    }

    private void createGeneratorComposite(Composite parent) {
        Group group = new Group(parent, parent.getStyle());
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group.setText("Generator:");
        Label groupIdLabel = new Label((Composite)group, 0);
        groupIdLabel.setText("groupId:");
        this.generatorGroupIdText = new Text((Composite)group, 2048);
        if (this.pomConfiguration.getGeneratorGroupId() != null) {
            this.generatorGroupIdText.setText(this.pomConfiguration.getGeneratorGroupId());
        }
        this.generatorGroupIdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.generatorGroupIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GenerationPomConfigurationPage.this.pomConfiguration.setGeneratorGroupId(GenerationPomConfigurationPage.this.generatorGroupIdText.getText());
                GenerationPomConfigurationPage.this.checkErrors();
            }
        });
        Label artifactIdLabel = new Label((Composite)group, 0);
        artifactIdLabel.setText("artifactId:");
        this.generatorArtifactIdText = new Text((Composite)group, 2048);
        if (this.pomConfiguration.getGeneratorArtifactId() != null) {
            this.generatorArtifactIdText.setText(this.pomConfiguration.getGeneratorArtifactId());
        }
        this.generatorArtifactIdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.generatorArtifactIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GenerationPomConfigurationPage.this.pomConfiguration.setGeneratorArtifactId(GenerationPomConfigurationPage.this.generatorArtifactIdText.getText());
                GenerationPomConfigurationPage.this.checkErrors();
            }
        });
        Label versionLabel = new Label((Composite)group, 0);
        versionLabel.setText("version:");
        this.generatorVersionText = new Text((Composite)group, 2048);
        if (this.pomConfiguration.getGeneratorVersion() != null) {
            this.generatorVersionText.setText(this.pomConfiguration.getGeneratorVersion());
        }
        this.generatorVersionText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.generatorVersionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GenerationPomConfigurationPage.this.pomConfiguration.setGeneratorVersion(GenerationPomConfigurationPage.this.generatorVersionText.getText());
                GenerationPomConfigurationPage.this.checkErrors();
            }
        });
    }

    private void handleWorkspaceModelButton() {
        FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(this.getShell(), false, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
        dialog.setTitle("Select the model file");
        String path = this.generationInputModelText.getText();
        if (path != null && path.length() > 0 && new Path(path).lastSegment().length() > 0) {
            dialog.setInitialPattern(new Path(path).lastSegment());
        } else {
            String initial = "*.xmi";
            dialog.setInitialPattern(initial);
        }
        dialog.open();
        if (dialog.getResult() != null && dialog.getResult().length > 0 && dialog.getResult()[0] instanceof IFile) {
            this.generationInputModelText.setText(((IFile)dialog.getResult()[0]).getFullPath().toString());
            this.checkErrors();
        }
    }

    private void handleFileSystemModelButton() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setText("Select the model file");
        String selected = dialog.open();
        if (selected != null) {
            this.generationInputModelText.setText(URI.createFileURI((String)selected).toString());
            this.checkErrors();
        }
    }

    private void handleWorkspaceDestinationButton() {
        IResource workspaceResource;
        FolderSelectionDialog dialog = this.pomConfiguration.getPomFolder() != null ? ((workspaceResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.pomConfiguration.getPomFolder()))) != null ? new FolderSelectionDialog(this.getShell(), "Select the destination folder", this.pomConfiguration.getPomFolder()) : new FolderSelectionDialog(this.getShell(), "Select the destination folder", null)) : new FolderSelectionDialog(this.getShell(), "Select the destination folder", null);
        int dialogResult = dialog.open();
        if (dialogResult == 0 && dialog.getFileName() != null && !dialog.getFileName().isEmpty()) {
            this.generationPomDestinationText.setText(dialog.getFileName());
            this.checkErrors();
            this.reloadTargetPom(this.pomConfiguration);
        }
    }

    private void handleFileSystemDestinationButton() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 4096);
        dialog.setText("Select the generation pom destination folder");
        String selected = dialog.open();
        if (selected != null) {
            if (selected.endsWith("/")) {
                this.generationPomDestinationText.setText(URI.createFileURI((String)selected).toString());
            } else {
                this.generationPomDestinationText.setText(URI.createFileURI((String)selected).toString() + "/");
            }
            this.checkErrors();
            this.reloadTargetPom(this.pomConfiguration);
        }
    }

    private void handleWorkspaceGenerationTargetFolderButton() {
        IResource workspaceResource;
        FolderSelectionDialog dialog = this.pomConfiguration.getGenerationTargetPath() != null ? ((workspaceResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.pomConfiguration.getGenerationTargetPath()))) != null ? new FolderSelectionDialog(this.getShell(), "Select the destination folder", this.pomConfiguration.getGenerationTargetPath()) : new FolderSelectionDialog(this.getShell(), "Select the destination folder", null)) : new FolderSelectionDialog(this.getShell(), "Select the destination folder", null);
        int dialogResult = dialog.open();
        if (dialogResult == 0 && dialog.getFileName() != null && !dialog.getFileName().isEmpty()) {
            this.generationTargetFolderText.setText(dialog.getFileName());
            this.checkErrors();
        }
    }

    private void handleFileSystemGenerationTargetFolderButton() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 4096);
        dialog.setText("Select the generation destination folder");
        String selected = dialog.open();
        if (selected != null) {
            if (selected.endsWith("/")) {
                this.generationTargetFolderText.setText(URI.createFileURI((String)selected).toString());
            } else {
                this.generationTargetFolderText.setText(URI.createFileURI((String)selected).toString() + "/");
            }
            this.checkErrors();
        }
    }

    private void checkErrors() {
        Status status;
        if (this.pomConfiguration.getPomFolder() == null || this.pomConfiguration.getPomFolder().isEmpty()) {
            String message = AcceleoUIMessages.getString("GenerationPomConfigurationPage.InvalidPomTargetFolder");
            status = new Status(4, "org.eclipse.acceleo.aql.ide.ui", message);
        } else if (this.pomConfiguration.getGenerationModelPath() == null || this.pomConfiguration.getGenerationModelPath().isEmpty()) {
            String message = AcceleoUIMessages.getString("GenerationPomConfigurationPage.InvalidGenerationModel");
            status = new Status(4, "org.eclipse.acceleo.aql.ide.ui", message);
        } else if (this.pomConfiguration.getGenerationTargetPath() == null || this.pomConfiguration.getGenerationTargetPath().isEmpty()) {
            String message = AcceleoUIMessages.getString("GenerationPomConfigurationPage.InvalidGenerationFolder");
            status = new Status(4, "org.eclipse.acceleo.aql.ide.ui", message);
        } else if (!this.targetPomExists && (this.pomConfiguration.getGenerationGroupId() == null || this.pomConfiguration.getGenerationGroupId().isEmpty())) {
            String message = AcceleoUIMessages.getString("GenerationPomConfigurationPage.InvalidGenerationGroupID");
            status = new Status(4, "org.eclipse.acceleo.aql.ide.ui", message);
        } else if (!this.targetPomExists && (this.pomConfiguration.getGenerationArtifactId() == null || this.pomConfiguration.getGenerationArtifactId().isEmpty())) {
            String message = AcceleoUIMessages.getString("GenerationPomConfigurationPage.InvalidGenerationArtifactID");
            status = new Status(4, "org.eclipse.acceleo.aql.ide.ui", message);
        } else if (!this.targetPomExists && (this.pomConfiguration.getGenerationVersion() == null || this.pomConfiguration.getGenerationVersion().isEmpty())) {
            String message = AcceleoUIMessages.getString("GenerationPomConfigurationPage.InvalidGenerationVersion");
            status = new Status(4, "org.eclipse.acceleo.aql.ide.ui", message);
        } else if (!this.targetPomExists && (this.pomConfiguration.getGeneratorGroupId() == null || this.pomConfiguration.getGeneratorGroupId().isEmpty())) {
            String message = AcceleoUIMessages.getString("GenerationPomConfigurationPage.InvalidGeneratorGroupID");
            status = new Status(4, "org.eclipse.acceleo.aql.ide.ui", message);
        } else if (this.pomConfiguration.getGeneratorArtifactId() == null || this.pomConfiguration.getGeneratorArtifactId().isEmpty()) {
            String message = AcceleoUIMessages.getString("GenerationPomConfigurationPage.InvalidGeneratorArtifactID");
            status = new Status(4, "org.eclipse.acceleo.aql.ide.ui", message);
        } else if (this.pomConfiguration.getGeneratorVersion() == null || this.pomConfiguration.getGeneratorVersion().isEmpty()) {
            String message = AcceleoUIMessages.getString("GenerationPomConfigurationPage.InvalidGeneratorVersion");
            status = new Status(4, "org.eclipse.acceleo.aql.ide.ui", message);
        } else {
            status = new Status(0, "org.eclipse.acceleo.aql.ide.ui", null);
        }
        this.applyToStatusLine((IStatus)status);
    }

    public void applyToStatusLine(IStatus status) {
        String message = status.getMessage();
        if (message != null && message.length() == 0) {
            message = null;
        }
        switch (status.getSeverity()) {
            case 0: {
                this.setMessage(message, 0);
                this.setErrorMessage(null);
                this.setPageComplete(true);
                break;
            }
            case 2: {
                this.setMessage(message, 2);
                this.setErrorMessage(null);
                this.setPageComplete(true);
                break;
            }
            case 1: {
                this.setMessage(message, 1);
                this.setErrorMessage(null);
                this.setPageComplete(true);
                break;
            }
            default: {
                this.setMessage(null);
                this.setErrorMessage(message);
                this.setPageComplete(false);
            }
        }
    }

    protected Button createPushButton(Composite parent, String label, Image image) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        if (image != null) {
            button.setImage(image);
        }
        if (label != null) {
            button.setText(label);
        }
        GridData gd = new GridData();
        button.setLayoutData((Object)gd);
        if (gd instanceof GridData) {
            PixelConverter converter = new PixelConverter((Control)button);
            int widthHint = converter.convertHorizontalDLUsToPixels(61);
            gd.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
            gd.horizontalAlignment = 4;
        }
        return button;
    }

    private void reloadTargetPom(GenerationPomConfiguration pomConfiguration) {
        URI pomTargetFolderURI = pomConfiguration.getPomFolderURI();
        if (pomTargetFolderURI != null) {
            URI pomURI = URI.createURI((String)"pom.xml").resolve(pomTargetFolderURI);
            if (URIConverter.INSTANCE.exists(pomURI, Collections.emptyMap())) {
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (InputStream input = URIConverter.INSTANCE.createInputStream(pomURI);){
                        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                        DocumentBuilder db = dbf.newDocumentBuilder();
                        Document pom = db.parse(input);
                        NodeList projectList = pom.getElementsByTagName("project");
                        if (projectList != null && projectList.getLength() > 0) {
                            NodeList versionList;
                            NodeList artifactIdList;
                            Element project = (Element)projectList.item(0);
                            NodeList groupIdList = project.getElementsByTagName("groupId");
                            if (groupIdList != null && groupIdList.getLength() > 0) {
                                Element groupId = (Element)groupIdList.item(0);
                                pomConfiguration.setGenerationGroupId(groupId.getTextContent());
                                this.generationGroupIdText.setText(groupId.getTextContent());
                            }
                            if ((artifactIdList = project.getElementsByTagName("artifactId")) != null && artifactIdList.getLength() > 0) {
                                Element artifactId = (Element)artifactIdList.item(0);
                                pomConfiguration.setGenerationArtifactId(artifactId.getTextContent());
                                this.generationArtifactIdText.setText(artifactId.getTextContent());
                            }
                            if ((versionList = project.getElementsByTagName("version")) != null && versionList.getLength() > 0) {
                                Element version = (Element)versionList.item(0);
                                pomConfiguration.setGenerationVersion(version.getTextContent());
                                this.generationVersionText.setText(version.getTextContent());
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    AcceleoUIPlugin.getDefault().getLog().log((IStatus)new Status(2, ((Object)((Object)this)).getClass(), "Couldn't initialize generation pom configuration from " + String.valueOf(pomURI), (Throwable)e));
                }
                this.checkErrors();
                this.targetPomExists = true;
            } else {
                this.targetPomExists = false;
            }
        } else {
            this.targetPomExists = false;
        }
        this.generationGroupIdText.setEnabled(!this.targetPomExists);
        this.generationArtifactIdText.setEnabled(!this.targetPomExists);
        this.generationVersionText.setEnabled(!this.targetPomExists);
    }
}

