/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.profiler.provider;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.eclipse.acceleo.aql.profiler.ProfileEntry;
import org.eclipse.acceleo.aql.profiler.provider.ProfileEntryItemProvider;
import org.eclipse.acceleo.aql.profiler.provider.ProfilerEditPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;

public class ProfileEntryItemProviderSpec
extends ProfileEntryItemProvider {
    private static final NumberFormat FORMAT = ProfileEntryItemProviderSpec.initFormat();

    public ProfileEntryItemProviderSpec(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    private static NumberFormat initFormat() {
        DecimalFormat res = new DecimalFormat();
        ((NumberFormat)res).setMaximumIntegerDigits(3);
        ((NumberFormat)res).setMaximumFractionDigits(2);
        return res;
    }

    @Override
    public Object getImage(Object object) {
        EObject monitored = ((ProfileEntry)object).getMonitored();
        Object res = monitored != null ? ProfilerEditPlugin.LABEL_PROVIDER.getImage((Object)monitored) : super.getImage(object);
        return res;
    }

    @Override
    public String getText(Object object) {
        String eClass;
        String text;
        ProfileEntry profileEntry = (ProfileEntry)object;
        EObject monitored = profileEntry.getMonitored();
        if (monitored != null) {
            text = ProfilerEditPlugin.LABEL_PROVIDER.getText((Object)monitored);
            eClass = monitored.eClass().getName();
        } else {
            text = "INTERNAL";
            eClass = "";
        }
        return FORMAT.format(profileEntry.getPercentage()) + "% / " + profileEntry.getDuration() + "ms / " + profileEntry.getCount() + " times " + eClass + " [" + text + "]";
    }
}

