/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.ui.st.util;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithm;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithmSource;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STMethod;
import org.eclipse.fordiac.ide.structuredtextalgorithm.ui.resource.STAlgorithmResourceSetInitializer;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.stfunction.STFunction;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.stfunction.STFunctionSource;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;

public final class STDebugUIUtil {
    private STDebugUIUtil() {
    }

    public static Resource getSourceResource(IResource file) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        XtextResourceSet resourceSet = new XtextResourceSet();
        new STAlgorithmResourceSetInitializer().initialize((ResourceSet)resourceSet, file.getProject());
        return resourceSet.getResource(uri, true);
    }

    public static Collection<? extends EObject> getSourceElements(Resource resource) {
        XtextResource xtextResource;
        IParseResult parseResult;
        if (resource instanceof XtextResource && (parseResult = (xtextResource = (XtextResource)resource).getParseResult()) != null) {
            EObject source = parseResult.getRootASTElement();
            if (source instanceof STAlgorithmSource) {
                STAlgorithmSource algorithmSource = (STAlgorithmSource)source;
                return algorithmSource.getElements();
            }
            if (source instanceof STFunctionSource) {
                STFunctionSource functionSource = (STFunctionSource)source;
                return functionSource.getFunctions();
            }
        }
        return Collections.emptyList();
    }

    public static EObject getSourceElement(Resource resource, int line) {
        return STDebugUIUtil.getSourceElements(resource).stream().filter(element -> {
            ICompositeNode node = NodeModelUtils.getNode((EObject)element);
            return node != null && node.getStartLine() <= line && node.getEndLine() >= line;
        }).findFirst().orElse(null);
    }

    public static Collection<? extends EObject> getAdditionalScope(IResource resource, int line) {
        return STDebugUIUtil.getAdditionalScope(STDebugUIUtil.getSourceElement(STDebugUIUtil.getSourceResource(resource), line));
    }

    public static Collection<? extends EObject> getAdditionalScope(EObject sourceElement) {
        if (sourceElement instanceof STAlgorithm) {
            STAlgorithm algorithm = (STAlgorithm)sourceElement;
            return algorithm.getBody().getVarTempDeclarations();
        }
        if (sourceElement instanceof STMethod) {
            STMethod method = (STMethod)sourceElement;
            return method.getBody().getVarDeclarations();
        }
        if (sourceElement instanceof STFunction) {
            STFunction function = (STFunction)sourceElement;
            return function.getVarDeclarations();
        }
        return Collections.emptyList();
    }
}

