/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ComparisonCanceledException;
import org.eclipse.emf.compare.EMFCompareMessages;
import org.eclipse.emf.compare.conflict.IConflictDetector;
import org.eclipse.emf.compare.conflict.MatchBasedConflictDetector;
import org.eclipse.emf.compare.diff.DefaultDiffEngine;
import org.eclipse.emf.compare.diff.DiffBuilder;
import org.eclipse.emf.compare.diff.IDiffEngine;
import org.eclipse.emf.compare.equi.DefaultEquiEngine;
import org.eclipse.emf.compare.equi.IEquiEngine;
import org.eclipse.emf.compare.internal.spec.ComparisonSpec;
import org.eclipse.emf.compare.internal.utils.SafeSubMonitor;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.match.impl.MatchEngineFactoryRegistryImpl;
import org.eclipse.emf.compare.merge.ResourceChangeAdapter;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.postprocessor.PostProcessorDescriptorRegistryImpl;
import org.eclipse.emf.compare.req.DefaultReqEngine;
import org.eclipse.emf.compare.req.IReqEngine;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class EMFCompare {
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.emf.compare";
    private final IMatchEngine.Factory.Registry matchEngineFactoryRegistry;
    private final IDiffEngine diffEngine;
    private final IReqEngine reqEngine;
    private final IEquiEngine equiEngine;
    private final IConflictDetector conflictDetector;
    private final IPostProcessor.Descriptor.Registry<?> postProcessorDescriptorRegistry;

    protected EMFCompare(IMatchEngine.Factory.Registry matchEngineFactoryRegistry, IDiffEngine diffEngine, IReqEngine reqEngine, IEquiEngine equiEngine, IConflictDetector conflictDetector, IPostProcessor.Descriptor.Registry<?> postProcessorFactoryRegistry) {
        this.matchEngineFactoryRegistry = (IMatchEngine.Factory.Registry)Preconditions.checkNotNull((Object)matchEngineFactoryRegistry);
        this.diffEngine = (IDiffEngine)Preconditions.checkNotNull((Object)diffEngine);
        this.reqEngine = (IReqEngine)Preconditions.checkNotNull((Object)reqEngine);
        this.equiEngine = (IEquiEngine)Preconditions.checkNotNull((Object)equiEngine);
        this.conflictDetector = conflictDetector;
        this.postProcessorDescriptorRegistry = (IPostProcessor.Descriptor.Registry)Preconditions.checkNotNull(postProcessorFactoryRegistry);
    }

    @Deprecated
    public static IComparisonScope createDefaultScope(Notifier left, Notifier right) {
        return new DefaultComparisonScope(left, right, null);
    }

    @Deprecated
    public static IComparisonScope createDefaultScope(Notifier left, Notifier right, Notifier origin) {
        return new DefaultComparisonScope(left, right, origin);
    }

    public Comparison compare(IComparisonScope scope) {
        return this.compare(scope, (Monitor)new BasicMonitor());
    }

    public Comparison compare(IComparisonScope scope, Monitor monitor) {
        Comparison comparison;
        block12: {
            Preconditions.checkNotNull((Object)scope);
            Preconditions.checkNotNull((Object)monitor);
            comparison = null;
            try {
                try {
                    SafeSubMonitor subMonitor = new SafeSubMonitor(monitor);
                    comparison = this.matchEngineFactoryRegistry.getHighestRankingMatchEngineFactory(scope).getMatchEngine().match(scope, subMonitor);
                    this.installResourceChangeAdapter(comparison, scope);
                    monitor.worked(1);
                    List<IPostProcessor> postProcessors = this.postProcessorDescriptorRegistry.getPostProcessors(scope);
                    this.postMatch(comparison, postProcessors, subMonitor);
                    monitor.worked(1);
                    if (!EMFCompare.hasToStop(comparison, monitor)) {
                        this.diffEngine.diff(comparison, subMonitor);
                        monitor.worked(1);
                        this.postDiff(comparison, postProcessors, subMonitor);
                        monitor.worked(1);
                        if (!EMFCompare.hasToStop(comparison, monitor)) {
                            this.reqEngine.computeRequirements(comparison, subMonitor);
                            monitor.worked(1);
                            this.postRequirements(comparison, postProcessors, subMonitor);
                            monitor.worked(1);
                            if (!EMFCompare.hasToStop(comparison, monitor)) {
                                this.equiEngine.computeEquivalences(comparison, subMonitor);
                                monitor.worked(1);
                                this.postEquivalences(comparison, postProcessors, subMonitor);
                                monitor.worked(1);
                                this.detectConflicts(comparison, postProcessors, subMonitor);
                                monitor.worked(1);
                                this.postComparison(comparison, postProcessors, subMonitor);
                                monitor.worked(1);
                            }
                        }
                    }
                }
                catch (ComparisonCanceledException e) {
                    if (comparison == null) {
                        comparison = new ComparisonSpec();
                    }
                    BasicDiagnostic cancelledDiag = new BasicDiagnostic(8, DIAGNOSTIC_SOURCE, 0, EMFCompareMessages.getString("ComparisonCancelled"), null);
                    Diagnostic diag = comparison.getDiagnostic();
                    if (diag != null && diag instanceof DiagnosticChain) {
                        ((DiagnosticChain)diag).merge((Diagnostic)cancelledDiag);
                    } else {
                        comparison.setDiagnostic((Diagnostic)cancelledDiag);
                    }
                    monitor.done();
                    break block12;
                }
            }
            catch (Throwable throwable) {
                monitor.done();
                throw throwable;
            }
            monitor.done();
        }
        if (scope instanceof Adapter) {
            comparison.eAdapters().add((Object)((Adapter)scope));
        }
        return comparison;
    }

    private void installResourceChangeAdapter(Comparison comparison, IComparisonScope scope) {
        Adapter existingAdapter;
        if (scope.getLeft() instanceof ResourceSet && scope.getRight() instanceof ResourceSet && (existingAdapter = EcoreUtil.getExistingAdapter((Notifier)comparison, ResourceChangeAdapter.class)) == null) {
            ResourceChangeAdapter adapter = new ResourceChangeAdapter(comparison, scope);
            comparison.eAdapters().add((Object)adapter);
            ResourceSet left = (ResourceSet)scope.getLeft();
            left.eAdapters().add((Object)adapter);
            for (Resource r : left.getResources()) {
                r.eAdapters().add((Object)adapter);
            }
            ResourceSet right = (ResourceSet)scope.getRight();
            right.eAdapters().add((Object)adapter);
            for (Resource r : right.getResources()) {
                r.eAdapters().add((Object)adapter);
            }
        }
    }

    private void detectConflicts(Comparison comparison, List<IPostProcessor> postProcessors, Monitor monitor) {
        if (!EMFCompare.hasToStop(comparison, monitor) && comparison.isThreeWay() && this.conflictDetector != null) {
            this.conflictDetector.detect(comparison, monitor);
            this.postConflicts(comparison, postProcessors, monitor);
        }
    }

    private void postMatch(Comparison comparison, List<IPostProcessor> postProcessors, Monitor monitor) {
        Iterator<IPostProcessor> processorsIterator = postProcessors.iterator();
        while (!EMFCompare.hasToStop(comparison, monitor) && processorsIterator.hasNext()) {
            IPostProcessor iPostProcessor = processorsIterator.next();
            iPostProcessor.postMatch(comparison, monitor);
        }
    }

    private void postDiff(Comparison comparison, List<IPostProcessor> postProcessors, Monitor monitor) {
        Iterator<IPostProcessor> processorsIterator = postProcessors.iterator();
        while (!EMFCompare.hasToStop(comparison, monitor) && processorsIterator.hasNext()) {
            IPostProcessor iPostProcessor = processorsIterator.next();
            iPostProcessor.postDiff(comparison, monitor);
        }
    }

    private void postRequirements(Comparison comparison, List<IPostProcessor> postProcessors, Monitor monitor) {
        Iterator<IPostProcessor> processorsIterator = postProcessors.iterator();
        while (!EMFCompare.hasToStop(comparison, monitor) && processorsIterator.hasNext()) {
            IPostProcessor iPostProcessor = processorsIterator.next();
            iPostProcessor.postRequirements(comparison, monitor);
        }
    }

    private void postEquivalences(Comparison comparison, List<IPostProcessor> postProcessors, Monitor monitor) {
        Iterator<IPostProcessor> processorsIterator = postProcessors.iterator();
        while (!EMFCompare.hasToStop(comparison, monitor) && processorsIterator.hasNext()) {
            IPostProcessor iPostProcessor = processorsIterator.next();
            iPostProcessor.postEquivalences(comparison, monitor);
        }
    }

    private void postConflicts(Comparison comparison, List<IPostProcessor> postProcessors, Monitor monitor) {
        Iterator<IPostProcessor> processorsIterator = postProcessors.iterator();
        while (!EMFCompare.hasToStop(comparison, monitor) && processorsIterator.hasNext()) {
            IPostProcessor iPostProcessor = processorsIterator.next();
            iPostProcessor.postConflicts(comparison, monitor);
        }
    }

    private void postComparison(Comparison comparison, List<IPostProcessor> postProcessors, Monitor monitor) {
        Iterator<IPostProcessor> processorsIterator = postProcessors.iterator();
        int postProcessorIndex = 1;
        while (!EMFCompare.hasToStop(comparison, monitor) && processorsIterator.hasNext()) {
            IPostProcessor postProcessor = processorsIterator.next();
            monitor.subTask(EMFCompareMessages.getString("PostComparison.monitor.postprocessor", postProcessor.getClass().getSimpleName(), String.valueOf(postProcessorIndex), String.valueOf(postProcessors.size())));
            postProcessor.postComparison(comparison, monitor);
            ++postProcessorIndex;
        }
    }

    private static boolean hasToStop(Comparison comparison, Monitor monitor) {
        return monitor.isCanceled() || comparison.getDiagnostic() != null && comparison.getDiagnostic().getSeverity() >= 4;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        protected IMatchEngine.Factory.Registry matchEngineFactoryRegistry;
        protected IReqEngine reqEngine;
        protected IDiffEngine diffEngine;
        protected IEquiEngine equiEngine;
        protected IConflictDetector conflictDetector;
        protected IPostProcessor.Descriptor.Registry<?> registry;

        protected Builder() {
        }

        public Builder setMatchEngineFactoryRegistry(IMatchEngine.Factory.Registry mefr) {
            this.matchEngineFactoryRegistry = (IMatchEngine.Factory.Registry)Preconditions.checkNotNull((Object)mefr);
            return this;
        }

        public Builder setDiffEngine(IDiffEngine de) {
            this.diffEngine = (IDiffEngine)Preconditions.checkNotNull((Object)de);
            return this;
        }

        public Builder setRequirementEngine(IReqEngine re) {
            this.reqEngine = (IReqEngine)Preconditions.checkNotNull((Object)re);
            return this;
        }

        public Builder setEquivalenceEngine(IEquiEngine ee) {
            this.equiEngine = (IEquiEngine)Preconditions.checkNotNull((Object)ee);
            return this;
        }

        public Builder setConflictDetector(IConflictDetector cd) {
            this.conflictDetector = (IConflictDetector)Preconditions.checkNotNull((Object)cd);
            return this;
        }

        public Builder setPostProcessorRegistry(IPostProcessor.Descriptor.Registry<?> r) {
            this.registry = (IPostProcessor.Descriptor.Registry)Preconditions.checkNotNull(r);
            return this;
        }

        public EMFCompare build() {
            if (this.matchEngineFactoryRegistry == null) {
                this.matchEngineFactoryRegistry = MatchEngineFactoryRegistryImpl.createStandaloneInstance();
            }
            if (this.diffEngine == null) {
                this.diffEngine = new DefaultDiffEngine(new DiffBuilder());
            }
            if (this.reqEngine == null) {
                this.reqEngine = new DefaultReqEngine();
            }
            if (this.equiEngine == null) {
                this.equiEngine = new DefaultEquiEngine();
            }
            if (this.registry == null) {
                this.registry = new PostProcessorDescriptorRegistryImpl();
            }
            if (this.conflictDetector == null) {
                this.conflictDetector = new MatchBasedConflictDetector();
            }
            return new EMFCompare(this.matchEngineFactoryRegistry, this.diffEngine, this.reqEngine, this.equiEngine, this.conflictDetector, this.registry);
        }
    }
}

