/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.preferences;

import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

class FullWidthFileFieldEditor
extends FileFieldEditor {
    private Composite wrapper;
    private GridData layoutData;

    public FullWidthFileFieldEditor(String configName, String label, boolean enforceAbsolute, Composite parent) {
        super(configName, label, enforceAbsolute, parent);
    }

    protected void createControl(Composite parent) {
        this.wrapper = new Composite(parent, 0);
        this.layoutData = GridDataFactory.fillDefaults().grab(true, false).create();
        this.wrapper.setLayoutData((Object)this.layoutData);
        GridLayoutFactory.fillDefaults().numColumns(super.getNumberOfControls()).applyTo(this.wrapper);
        this.doFillIntoGrid(this.wrapper, super.getNumberOfControls());
        if (SystemReader.getInstance().isMacOS()) {
            this.getChangeControl(this.wrapper).setToolTipText(UIText.FullWidthFileFieldEditor_buttonTooltipMac);
        }
    }

    public void indent(int horizontalIndent, int verticalIndent) {
        this.layoutData.horizontalIndent = horizontalIndent;
        this.layoutData.verticalIndent = verticalIndent;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        if (parent != this.wrapper) {
            this.layoutData.horizontalSpan = numColumns;
        }
        super.doFillIntoGrid(this.wrapper, super.getNumberOfControls());
    }

    protected void adjustForNumColumns(int numColumns) {
        this.layoutData.horizontalSpan = numColumns;
    }

    public Label getLabelControl(Composite parent) {
        return super.getLabelControl(this.wrapper);
    }

    public Text getTextControl(Composite parent) {
        return super.getTextControl(this.wrapper);
    }

    protected Button getChangeControl(Composite parent) {
        return super.getChangeControl(this.wrapper);
    }

    public int getNumberOfControls() {
        return 1;
    }
}

