/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.reorder;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.factory.primitive.IntIntMaps;
import org.eclipse.collections.api.factory.primitive.IntLists;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.MutableIntIntMap;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.command.ConfigureScalingCommand;
import org.eclipse.nebula.widgets.nattable.layer.event.ColumnStructuralRefreshEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralChangeEventHelper;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;
import org.eclipse.nebula.widgets.nattable.reorder.command.ColumnReorderCommandHandler;
import org.eclipse.nebula.widgets.nattable.reorder.command.ColumnReorderEndCommandHandler;
import org.eclipse.nebula.widgets.nattable.reorder.command.ColumnReorderStartCommandHandler;
import org.eclipse.nebula.widgets.nattable.reorder.command.MultiColumnReorderCommandHandler;
import org.eclipse.nebula.widgets.nattable.reorder.command.ResetColumnReorderCommandHandler;
import org.eclipse.nebula.widgets.nattable.reorder.config.DefaultColumnReorderLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.reorder.event.ColumnReorderEvent;
import org.eclipse.nebula.widgets.nattable.util.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnReorderLayer
extends AbstractLayerTransform
implements IUniqueIndexLayer {
    private static final Logger LOG = LoggerFactory.getLogger(ColumnReorderLayer.class);
    public static final String PERSISTENCE_KEY_COLUMN_INDEX_ORDER = ".columnIndexOrder";
    private final IUniqueIndexLayer underlying;
    protected final MutableIntList columnIndexOrder = IntLists.mutable.empty();
    protected final MutableIntIntMap indexPositionMapping = IntIntMaps.mutable.empty();
    private final MutableIntIntMap startXCache = IntIntMaps.mutable.empty();
    private int reorderFromColumnPosition;

    public ColumnReorderLayer(IUniqueIndexLayer underlyingLayer) {
        this(underlyingLayer, true);
    }

    public ColumnReorderLayer(IUniqueIndexLayer underlyingLayer, boolean useDefaultConfiguration) {
        super(underlyingLayer);
        this.underlying = underlyingLayer;
        this.populateIndexOrder();
        this.registerCommandHandlers();
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultColumnReorderLayerConfiguration());
        }
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        IStructuralChangeEvent structuralChangeEvent;
        if (event instanceof IStructuralChangeEvent && (structuralChangeEvent = (IStructuralChangeEvent)event).isHorizontalStructureChanged()) {
            Collection<StructuralDiff> structuralDiffs = structuralChangeEvent.getColumnDiffs();
            if (structuralDiffs == null) {
                this.populateIndexOrder();
            } else {
                StructuralChangeEventHelper.handleColumnDelete(structuralDiffs, (ILayer)this.underlying, (MutableIntCollection)this.columnIndexOrder, true);
                StructuralChangeEventHelper.handleColumnInsert(structuralDiffs, (ILayer)this.underlying, (MutableIntCollection)this.columnIndexOrder, true);
                this.refreshIndexPositionMapping();
            }
            this.invalidateCache();
        }
        super.handleLayerEvent(event);
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof ConfigureScalingCommand) {
            this.invalidateCache();
        }
        return super.doCommand(command);
    }

    @Override
    protected void registerCommandHandlers() {
        this.registerCommandHandler(new ColumnReorderCommandHandler(this));
        this.registerCommandHandler(new ColumnReorderStartCommandHandler(this));
        this.registerCommandHandler(new ColumnReorderEndCommandHandler(this));
        this.registerCommandHandler(new MultiColumnReorderCommandHandler(this));
        this.registerCommandHandler(new ResetColumnReorderCommandHandler(this));
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        super.saveState(prefix, properties);
        if (this.columnIndexOrder.size() > 0) {
            properties.setProperty(prefix + PERSISTENCE_KEY_COLUMN_INDEX_ORDER, this.columnIndexOrder.makeString(","));
        }
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        super.loadState(prefix, properties);
        String property = properties.getProperty(prefix + PERSISTENCE_KEY_COLUMN_INDEX_ORDER);
        if (property != null) {
            MutableIntList newColumnIndexOrder = IntLists.mutable.empty();
            StringTokenizer tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                String index = tok.nextToken();
                newColumnIndexOrder.add(Integer.parseInt(index));
            }
            if (this.isRestoredStateValid(newColumnIndexOrder.toArray())) {
                this.columnIndexOrder.clear();
                this.columnIndexOrder.addAll((IntIterable)newColumnIndexOrder);
                this.refreshIndexPositionMapping();
            }
        }
        this.invalidateCache();
        this.fireLayerEvent(new ColumnStructuralRefreshEvent(this));
    }

    protected boolean isRestoredStateValid(int[] newColumnIndexOrder) {
        if (newColumnIndexOrder.length != this.getColumnCount()) {
            LOG.error("Number of persisted columns ({}) is not the same as the number of columns in the data source ({}).\nSkipping restore of column ordering", (Object)newColumnIndexOrder.length, (Object)this.getColumnCount());
            return false;
        }
        int[] nArray = newColumnIndexOrder;
        int n = newColumnIndexOrder.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (!this.indexPositionMapping.containsKey(index)) {
                LOG.error("Column index: {} being restored, is not a available in the data soure.\nSkipping restore of column ordering", (Object)index);
                return false;
            }
            ++n2;
        }
        return true;
    }

    public List<Integer> getColumnIndexOrder() {
        return ArrayUtil.asIntegerList(this.columnIndexOrder.toArray());
    }

    public int[] getColumnIndexOrderArray() {
        return this.columnIndexOrder.toArray();
    }

    @Override
    public int getColumnIndexByPosition(int columnPosition) {
        if (columnPosition >= 0 && columnPosition < this.columnIndexOrder.size()) {
            return this.columnIndexOrder.get(columnPosition);
        }
        return -1;
    }

    @Override
    public int getColumnPositionByIndex(int columnIndex) {
        return this.indexPositionMapping.getIfAbsent(columnIndex, -1);
    }

    @Override
    public int localToUnderlyingColumnPosition(int localColumnPosition) {
        int columnIndex = this.getColumnIndexByPosition(localColumnPosition);
        return this.underlying.getColumnPositionByIndex(columnIndex);
    }

    @Override
    public int underlyingToLocalColumnPosition(ILayer sourceUnderlyingLayer, int underlyingColumnPosition) {
        int columnIndex = this.underlying.getColumnIndexByPosition(underlyingColumnPosition);
        return this.getColumnPositionByIndex(columnIndex);
    }

    @Override
    public Collection<Range> underlyingToLocalColumnPositions(ILayer sourceUnderlyingLayer, Collection<Range> underlyingColumnPositionRanges) {
        MutableIntList reorderedColumnPositions = IntLists.mutable.empty();
        for (Range underlyingColumnPositionRange : underlyingColumnPositionRanges) {
            int underlyingColumnPosition = underlyingColumnPositionRange.start;
            while (underlyingColumnPosition < underlyingColumnPositionRange.end) {
                int localColumnPosition = this.underlyingToLocalColumnPosition(sourceUnderlyingLayer, underlyingColumnPosition);
                reorderedColumnPositions.add(localColumnPosition);
                ++underlyingColumnPosition;
            }
        }
        return PositionUtil.getRanges(reorderedColumnPositions.toSortedArray());
    }

    @Override
    public int getColumnPositionByX(int x) {
        return LayerUtil.getColumnPositionByX(this, x);
    }

    @Override
    public int getStartXOfColumnPosition(int targetColumnPosition) {
        int cachedStartX = this.startXCache.getIfAbsent(targetColumnPosition, -1);
        if (cachedStartX != -1) {
            return cachedStartX;
        }
        int aggregateWidth = 0;
        int columnPosition = 0;
        while (columnPosition < targetColumnPosition) {
            aggregateWidth += this.underlying.getColumnWidthByPosition(this.localToUnderlyingColumnPosition(columnPosition));
            ++columnPosition;
        }
        this.startXCache.put(targetColumnPosition, aggregateWidth);
        return aggregateWidth;
    }

    protected void populateIndexOrder() {
        this.columnIndexOrder.clear();
        ILayer underlyingLayer = this.getUnderlyingLayer();
        int columnPosition = 0;
        while (columnPosition < underlyingLayer.getColumnCount()) {
            int index = underlyingLayer.getColumnIndexByPosition(columnPosition);
            this.columnIndexOrder.add(index);
            this.indexPositionMapping.put(index, columnPosition);
            ++columnPosition;
        }
    }

    protected void refreshIndexPositionMapping() {
        this.indexPositionMapping.clear();
        int position = 0;
        while (position < this.columnIndexOrder.size()) {
            int index = this.columnIndexOrder.get(position);
            this.indexPositionMapping.put(index, position);
            ++position;
        }
    }

    @Override
    public int getRowPositionByIndex(int rowIndex) {
        return this.underlying.getRowPositionByIndex(rowIndex);
    }

    private void moveColumn(int fromColumnPosition, int toColumnPosition, boolean reorderToLeftEdge) {
        if (!reorderToLeftEdge) {
            ++toColumnPosition;
        }
        int fromColumnIndex = this.columnIndexOrder.get(fromColumnPosition);
        this.columnIndexOrder.addAtIndex(toColumnPosition, fromColumnIndex);
        this.columnIndexOrder.removeAtIndex(fromColumnPosition + (fromColumnPosition > toColumnPosition ? 1 : 0));
        this.refreshIndexPositionMapping();
        this.invalidateCache();
    }

    public void reorderColumnPosition(int fromColumnPosition, int toColumnPosition) {
        boolean reorderToLeftEdge;
        if (toColumnPosition < this.getColumnCount()) {
            reorderToLeftEdge = true;
        } else {
            reorderToLeftEdge = false;
            --toColumnPosition;
        }
        this.reorderColumnPosition(fromColumnPosition, toColumnPosition, reorderToLeftEdge);
    }

    public void reorderColumnPosition(int fromColumnPosition, int toColumnPosition, boolean reorderToLeftEdge) {
        int fromColumnIndex = this.getColumnIndexByPosition(fromColumnPosition);
        int toColumnIndex = this.getColumnIndexByPosition(toColumnPosition);
        this.moveColumn(fromColumnPosition, toColumnPosition, reorderToLeftEdge);
        this.fireLayerEvent(new ColumnReorderEvent((ILayer)this, fromColumnPosition, fromColumnIndex, toColumnPosition, toColumnIndex, reorderToLeftEdge));
    }

    public void reorderMultipleColumnPositions(List<Integer> fromColumnPositions, int toColumnPosition) {
        this.reorderMultipleColumnPositions(fromColumnPositions.stream().mapToInt(Integer::intValue).toArray(), toColumnPosition);
    }

    public void reorderMultipleColumnPositions(int[] fromColumnPositions, int toColumnPosition) {
        boolean reorderToLeftEdge;
        if (toColumnPosition < this.getColumnCount()) {
            reorderToLeftEdge = true;
        } else {
            reorderToLeftEdge = false;
            --toColumnPosition;
        }
        this.reorderMultipleColumnPositions(fromColumnPositions, toColumnPosition, reorderToLeftEdge);
    }

    public void reorderMultipleColumnPositions(List<Integer> fromColumnPositions, int toColumnPosition, boolean reorderToLeftEdge) {
        this.reorderMultipleColumnPositions(fromColumnPositions.stream().mapToInt(Integer::intValue).toArray(), toColumnPosition, reorderToLeftEdge);
    }

    public void reorderMultipleColumnPositions(int[] fromColumnPositions, int toColumnPosition, boolean reorderToLeftEdge) {
        Arrays.sort(fromColumnPositions);
        int[] fromColumnIndexes = Arrays.stream(fromColumnPositions).map(this::getColumnIndexByPosition).toArray();
        int toColumnIndex = this.getColumnIndexByPosition(toColumnPosition);
        int fromColumnPositionsCount = fromColumnPositions.length;
        if (toColumnPosition > fromColumnPositions[fromColumnPositionsCount - 1]) {
            int firstColumnPosition = fromColumnPositions[0];
            int moved = 0;
            int columnCount = 0;
            while (columnCount < fromColumnPositionsCount) {
                int fromColumnPosition = fromColumnPositions[columnCount] - moved;
                this.moveColumn(fromColumnPosition, toColumnPosition, reorderToLeftEdge);
                ++moved;
                if (fromColumnPosition < firstColumnPosition) {
                    firstColumnPosition = fromColumnPosition;
                }
                ++columnCount;
            }
        } else if (toColumnPosition < fromColumnPositions[fromColumnPositionsCount - 1]) {
            int targetColumnPosition = toColumnPosition;
            int[] nArray = fromColumnPositions;
            int n = fromColumnPositions.length;
            int n2 = 0;
            while (n2 < n) {
                int fromColumnPosition;
                int fromColumnPositionInt = fromColumnPosition = nArray[n2];
                this.moveColumn(fromColumnPositionInt, targetColumnPosition++, reorderToLeftEdge);
                ++n2;
            }
        }
        this.fireLayerEvent(new ColumnReorderEvent((ILayer)this, fromColumnPositions, fromColumnIndexes, toColumnPosition, toColumnIndex, reorderToLeftEdge));
    }

    public void reorderMultipleColumnIndexes(List<Integer> fromColumnIndexes, int toColumnPosition, boolean reorderToLeftEdge) {
        this.reorderMultipleColumnIndexes(fromColumnIndexes.stream().mapToInt(Integer::intValue).toArray(), toColumnPosition, reorderToLeftEdge);
    }

    public void reorderMultipleColumnIndexes(int[] fromColumnIndexes, int toColumnPosition, boolean reorderToLeftEdge) {
        int[] fromColumnPositions = Arrays.stream(fromColumnIndexes).map(this::getColumnPositionByIndex).toArray();
        this.reorderMultipleColumnPositions(fromColumnPositions, toColumnPosition, reorderToLeftEdge);
    }

    protected void invalidateCache() {
        this.startXCache.clear();
    }

    public int getReorderFromColumnPosition() {
        return this.reorderFromColumnPosition;
    }

    public void setReorderFromColumnPosition(int fromColumnPosition) {
        this.reorderFromColumnPosition = fromColumnPosition;
    }

    public void resetReorder() {
        this.populateIndexOrder();
        this.invalidateCache();
        this.fireLayerEvent(new ColumnStructuralRefreshEvent(this));
    }
}

