/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.filterrow;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.nebula.widgets.nattable.edit.editor.TextCellEditor;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.util.PlatformHelper;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class FilterRowTextCellEditor
extends TextCellEditor {
    @Override
    protected Text createEditorControl(Composite parent, int style) {
        Text text = super.createEditorControl(parent, style);
        final ScheduledExecutorService service = Executors.newScheduledThreadPool(1);
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                service.schedule(new KeyPressCommitRunnable(FilterRowTextCellEditor.this.getEditorValue()), 150L, TimeUnit.MILLISECONDS);
            }
        });
        PaintListener paintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (FilterRowTextCellEditor.this.getEditorControl() != null && !FilterRowTextCellEditor.this.getEditorControl().isDisposed()) {
                    ILayerCell cell = FilterRowTextCellEditor.this.layerCell.getLayer().getCellByPosition(FilterRowTextCellEditor.this.layerCell.getColumnPosition(), FilterRowTextCellEditor.this.layerCell.getRowPosition());
                    Rectangle cellBounds = cell.getBounds();
                    Rectangle editorBounds = cell.getLayer().getLayerPainter().adjustCellBounds(cell.getColumnPosition(), cell.getRowPosition(), new Rectangle(cellBounds.x, cellBounds.y, cellBounds.width, cellBounds.height));
                    editorBounds = FilterRowTextCellEditor.this.calculateControlBounds(editorBounds);
                    if (editorBounds.x == 0) {
                        ++editorBounds.x;
                        --editorBounds.width;
                    }
                    FilterRowTextCellEditor.this.getEditorControl().setBounds(editorBounds);
                }
            }
        };
        PlatformHelper.callSetter((Object)parent, "addPaintListener", PaintListener.class, paintListener);
        text.addDisposeListener(e -> {
            service.shutdownNow();
            PlatformHelper.callSetter((Object)parent, "removePaintListener", PaintListener.class, paintListener);
        });
        return text;
    }

    private class KeyPressCommitRunnable
    implements Runnable {
        final String toCommit;

        KeyPressCommitRunnable(String toCommit) {
            this.toCommit = toCommit;
        }

        @Override
        public void run() {
            Display.getDefault().syncExec(() -> {
                if (FilterRowTextCellEditor.this.getEditorControl() != null && !FilterRowTextCellEditor.this.getEditorControl().isDisposed() && this.toCommit != null && this.toCommit.equals(FilterRowTextCellEditor.this.getEditorValue())) {
                    FilterRowTextCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.NONE, false);
                }
            });
        }
    }
}

