/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.navigator;

import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class TypeDecorator
implements ILightweightLabelDecorator {
    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void decorate(Object element, IDecoration decoration) {
        IFile file;
        String comment;
        if (element instanceof IFile && (comment = TypeDecorator.getComment(file = (IFile)element)) != null) {
            decoration.addSuffix(" [" + comment + "]");
        }
    }

    private static String getComment(IFile file) {
        TypeEntry entry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(file);
        if (entry != null) {
            String editorComment = (String)Display.getDefault().syncCall(() -> {
                LibraryElement libraryElement;
                IEditorPart editor = TypeDecorator.findEditor(file);
                if (editor != null && (libraryElement = (LibraryElement)editor.getAdapter(LibraryElement.class)) != null) {
                    return libraryElement.getComment();
                }
                return null;
            });
            return Objects.requireNonNullElse(editorComment, entry.getComment());
        }
        return null;
    }

    private static IEditorPart findEditor(IFile file) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return null;
        }
        return activePage.findEditor((IEditorInput)new FileEditorInput(file));
    }
}

