/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.commands;

import java.text.MessageFormat;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fordiac.ide.gef.Messages;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.libraryElement.ConnectionRoutingData;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.gef.commands.Command;

public class AdjustConnectionCommand
extends Command {
    private final Connection connection;
    private final Point point;
    private final int index;
    private final org.eclipse.fordiac.ide.model.libraryElement.Connection modelConnection;
    private final double zoom;
    private final ConnectionRoutingData oldRoutingData;
    private ConnectionRoutingData newRoutingData;

    public AdjustConnectionCommand(Connection connection, Point p, int index, org.eclipse.fordiac.ide.model.libraryElement.Connection modelConnection, double zoom) {
        this.connection = connection;
        this.point = p;
        this.index = index;
        this.modelConnection = modelConnection;
        this.zoom = zoom;
        this.oldRoutingData = modelConnection.getRoutingData();
    }

    public void execute() {
        this.createInitalNewRoutingData();
        this.updateNewRoutingData();
        this.updateRoutingData(this.newRoutingData);
    }

    public void undo() {
        this.updateRoutingData(this.oldRoutingData);
    }

    public void redo() {
        this.updateRoutingData(this.newRoutingData);
    }

    private void updateRoutingData(ConnectionRoutingData routingData) {
        this.modelConnection.setRoutingData(routingData);
        this.connection.revalidate();
    }

    private void updateNewRoutingData() {
        Point sourceP = this.getSourcePoint();
        Point destP = this.getDestinationPoint();
        int scaledMinDistance = (int)Math.floor(12.0 * this.zoom);
        switch (this.index) {
            case 2: {
                int newDx1 = Math.max(this.point.x - sourceP.x, scaledMinDistance);
                if (this.newRoutingData.is3SegementData()) {
                    newDx1 = Math.min(newDx1, destP.x - sourceP.x - scaledMinDistance);
                }
                this.newRoutingData.setDx1(AdjustConnectionCommand.fromScreen((int)Math.floor((double)newDx1 / this.zoom)));
                break;
            }
            case 4: {
                this.newRoutingData.setDy(AdjustConnectionCommand.fromScreen((int)Math.floor((double)(this.point.y - sourceP.y) / this.zoom)));
                break;
            }
            case 6: {
                int newDx2 = Math.max(destP.x - this.point.x, scaledMinDistance);
                this.newRoutingData.setDx2(AdjustConnectionCommand.fromScreen((int)Math.floor((double)newDx2 / this.zoom)));
                break;
            }
            default: {
                FordiacLogHelper.logError((String)MessageFormat.format(Messages.AdjustConnectionCommand_WrongConnectionSegmentIndex, this.index));
            }
        }
    }

    private void createInitalNewRoutingData() {
        this.newRoutingData = LibraryElementFactory.eINSTANCE.createConnectionRoutingData();
        this.newRoutingData.setDx1(this.oldRoutingData.getDx1());
        this.newRoutingData.setDx2(this.oldRoutingData.getDx2());
        this.newRoutingData.setDy(this.oldRoutingData.getDy());
    }

    private Point getDestinationPoint() {
        return this.connection.getTargetAnchor().getLocation(this.connection.getTargetAnchor().getReferencePoint()).getCopy();
    }

    private Point getSourcePoint() {
        return this.connection.getSourceAnchor().getLocation(this.connection.getSourceAnchor().getReferencePoint()).getCopy();
    }

    private static double fromScreen(int val) {
        return CoordinateConverter.INSTANCE.screenToIEC61499(val);
    }
}

