/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.parser;

import java.util.Calendar;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.parser.RegexFTPFileEntryParserImpl;

public class UnixFTPEntryParser
extends RegexFTPFileEntryParserImpl {
    private static final String MONTHS = "(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)";
    private static final String REGEX = "([bcdlfmpSs-])(((r|-)(w|-)([xsStTL-]))((r|-)(w|-)([xsStTL-]))((r|-)(w|-)([xsStTL-])))\\s+(\\d+)\\s+(\\S+)\\s+(?:(\\S+)\\s+)?(\\d+)\\s+(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\\s+((?:[0-9])|(?:[0-2][0-9])|(?:3[0-1]))\\s+((\\d\\d\\d\\d)|((?:[01]\\d)|(?:2[0123])|(?:\\d)):([012345]\\d))\\s+(\\S+)(\\s*.*)";

    public UnixFTPEntryParser() {
        super(REGEX);
    }

    public FTPFile parseFTPEntry(String string) {
        FTPFile fTPFile = new FTPFile();
        fTPFile.setRawListing(string);
        boolean bl = false;
        if (this.matches(string)) {
            int n;
            Object object;
            int n2;
            String string2 = this.group(1);
            String string3 = this.group(15);
            String string4 = this.group(16);
            String string5 = this.group(17);
            String string6 = this.group(18);
            String string7 = this.group(19);
            String string8 = this.group(20);
            String string9 = this.group(22);
            String string10 = this.group(23);
            String string11 = this.group(24);
            String string12 = this.group(25);
            String string13 = this.group(26);
            switch (string2.charAt(0)) {
                case 'd': {
                    n2 = 1;
                    break;
                }
                case 'l': {
                    n2 = 2;
                    break;
                }
                case 'b': 
                case 'c': {
                    bl = true;
                }
                case '-': 
                case 'f': {
                    n2 = 0;
                    break;
                }
                default: {
                    n2 = 3;
                }
            }
            fTPFile.setType(n2);
            int n3 = 4;
            int n4 = 0;
            while (n4 < 3) {
                fTPFile.setPermission(n4, 0, this.group(n3).equals("-") ^ true);
                fTPFile.setPermission(n4, 1, this.group(n3 + 1).equals("-") ^ true);
                object = this.group(n3 + 2);
                if (!((String)object).equals("-") && !Character.isUpperCase(((String)object).charAt(0))) {
                    fTPFile.setPermission(n4, 2, true);
                } else {
                    fTPFile.setPermission(n4, 2, false);
                }
                ++n4;
                n3 += 4;
            }
            if (!bl) {
                try {
                    fTPFile.setHardLinkCount(Integer.parseInt(string3));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            fTPFile.setUser(string4);
            fTPFile.setGroup(string5);
            try {
                fTPFile.setSize(Long.parseLong(string6));
            }
            catch (NumberFormatException numberFormatException) {}
            object = Calendar.getInstance();
            ((Calendar)object).set(14, 0);
            ((Calendar)object).set(13, 0);
            ((Calendar)object).set(12, 0);
            ((Calendar)object).set(11, 0);
            try {
                n = MONTHS.indexOf(string7);
                int n5 = n / 4;
                if (string9 != null) {
                    ((Calendar)object).set(1, Integer.parseInt(string9));
                } else {
                    int n6 = ((Calendar)object).get(1);
                    if (((Calendar)object).get(2) < n5) {
                        --n6;
                    }
                    ((Calendar)object).set(1, n6);
                    ((Calendar)object).set(11, Integer.parseInt(string10));
                    ((Calendar)object).set(12, Integer.parseInt(string11));
                }
                ((Calendar)object).set(2, n5);
                ((Calendar)object).set(5, Integer.parseInt(string8));
                fTPFile.setTimestamp((Calendar)object);
            }
            catch (NumberFormatException numberFormatException) {}
            if (string13 == null) {
                fTPFile.setName(string12);
            } else {
                string12 = String.valueOf(string12) + string13;
                if (n2 == 2) {
                    n = string12.indexOf(" -> ");
                    if (n == -1) {
                        fTPFile.setName(string12);
                    } else {
                        fTPFile.setName(string12.substring(0, n));
                        fTPFile.setLink(string12.substring(n + 4));
                    }
                } else {
                    fTPFile.setName(string12);
                }
            }
            return fTPFile;
        }
        return null;
    }
}

